<?php

return array(
    'dashboard' => array(
        'welcome' => __('Welcome to TheGem Theme', 'thegem'),
        'gratis' => __('Thank you for purchasing TheGem! Please activate your copy to get access to pre-built demos, bundled plugins and auto updates.', 'thegem'),
        'gratis_active' => __('Thank you for using TheGem! In the dashboard below you can check your theme activation, system status, install bundled plugins and get access to pre-built demos and updates.', 'thegem'),

        'title' => __('TheGem Dashboard', 'thegem'),
        'title_theme_activation' => __('Theme Activation', 'thegem'),
        'title_purchase_code' => __('Where Can I Find My Purchase Code?', 'thegem'),
        'title_buy_license' => __('Buy License', 'thegem'),
        'title_system_status' => __('System Status', 'thegem'),
        'title_useful_links' => __('Useful Links', 'thegem'),
        'title_install_plugin' => __('Install Plugin', 'thegem'),
        'title_install_update_plugin' => __('Install or Update Necessary Plugins', 'thegem'),
        'title_server_environment' => __('Server Environment', 'thegem'),
        'title_wp_environment' => __('WordPress Environment', 'thegem'),
        'title_permissions' => __('Permissions', 'thegem'),
        'title_theme' => __('Theme', 'thegem'),
        'button_check_your_activations' => __('Check your activations', 'thegem'),

        'button_activate' => __('Activate TheGem', 'thegem'),
        'button_activated' => __('Activated', 'thegem'),
        'button_purchase' => __('Purchase New License', 'thegem'),
        'button_more_info' => __('More Info', 'thegem'),
        'button_check_activations' => __('Check your activations', 'thegem'),
        'button_buy_license' => __('Buy new license', 'thegem'),
        'button_contact_support' => __('Contact support', 'thegem'),
        'button_changelog' => __('See full changelog', 'thegem'),

        'link_install_plugins' => __('Install Plugins', 'thegem'),
        'link_prebuilt_websites' => __('Pre-Built Demos', 'thegem'),
        'link_thegem_blocks' => __('TheGem Blocks', 'thegem'),
        'link_theme_options' => __('Theme Options', 'thegem'),
        'link_begin_install_plugins' => __('Begin installing plugins...', 'thegem'),
        'link_documentation' => __('Documentation', 'thegem'),
        'link_support' => __('Support', 'thegem'),
        'link_server_connection' => __('see this tutorial', 'thegem'),
        'link_theme_install' => __('this install link', 'thegem'),
        'link_elements_install' => __('this install link', 'thegem'),
        'link_install_now' => __('Install Now', 'thegem'),
        'link_activate_now' => __('ACTIVATE NOW', 'thegem'),
        'text_update_now' => __('UPDATE NOW', 'thegem'),

        'list_purchase_step1' => __('Please go to', 'thegem'),
        'list_purchase_step2' => __('Click the <b>Download</b> button in TheGem theme row', 'thegem'),
        'list_purchase_step3' => __('Select <b>License Certificate & Purchase code</b>', 'thegem'),
        'list_purchase_step4' => __('Copy <b>Item Purchase Code</b>', 'thegem'),
        'list_status_stylesheets' => __('Stylesheets writable', 'thegem'),
        'list_status_uploads' => __('Uploads folder writable', 'thegem'),
        'list_status_api_server' => __('API Server connection', 'thegem'),
        'list_status_php_memory' => __('PHP Memory Limit', 'thegem'),
        'list_status_php_time' => __('PHP Execution Time', 'thegem'),
        'list_status_php_upload' => __('PHP Upload Limit', 'thegem'),
        'list_status_php_postmaxsize' => __('PHP Post Max Size', 'thegem'),
        'list_server_msql_version' => __('MySQL Version', 'thegem'),
        'list_server_php_version' => __('PHP Version', 'thegem'),
        'list_server_php_memory_limit' => __('PHP Memory Limit', 'thegem'),
        'list_server_php_time_limit' => __('PHP Time Limit', 'thegem'),
        'list_server_php_input_vars' => __('PHP Max Input Vars', 'thegem'),
        'list_server_php_upload_limit' => __('PHP Upload Limit', 'thegem'),
        'list_server_connection' => __('Connection Time Limit', 'thegem'),
        'list_wp_version' => __('WP Version', 'thegem'),
        'list_wp_file' => __('WP File System', 'thegem'),
        'list_wp_lang' => __('Language', 'thegem'),
        'list_wp_direction' => __('Text Direction', 'thegem'),
        'list_wp_home_url' => __('Home URL', 'thegem'),
        'list_wp_site_url' => __('Site URL', 'thegem'),
        'list_permission_stylesheets' => __('Stylesheets writable', 'thegem'),
        'list_permission_uploads' => __('Uploads folder writable', 'thegem'),
        'list_permission_api_server' => __('API Server connection', 'thegem'),
        'list_theme_version' => __('Theme version', 'thegem'),
        'list_theme_registration' => __('Registration', 'thegem'),
        'list_theme_elements' => __('TheGem Elements', 'thegem'),
        'list_theme_builder' => __('Page Builder', 'thegem'),
        'list_activation' => __('Activation', 'thegem'),

        'text_another_license' => __('If you need another license for new website', 'thegem'),
        'text_status_uploads' => __('Uploads folder must be writable. Please set write permission to your wp-content/uploads folders', 'thegem'),
        'text_status_php_upload' => __('php.ini values are shown above. Real values may vary, please check your limits using', 'thegem'),
        'text_install_plugin' => __('Please install TheGem Demo Import plugin', 'thegem'),
        'text_install_update_plugin' => __('TheGem Elements and Elementor are the only required plugins. Any other plugins are optional.', 'thegem'),
        'text_server_connection1' => __('php.ini values are shown above. Real values may vary, please check your limits using', 'thegem'),
        'text_server_connection2' => __('For more details about file creation please refer to,', 'thegem'),
        'text_theme_builder' => __('Please install page builder by following', 'thegem'),
        'text_elements' => __('Please install elements plugin by following', 'thegem'),
        'text_theme_version' => __('Version', 'thegem'),
        'text_theme_version_available' => __('is available', 'thegem'),
        'text_theme_not_active' => __('Please activate your copy of TheGem.', 'thegem'),
        'text_theme_server_recommended' => __('Recommended', 'thegem'),
        'text_theme_server_recommended_ask' => __('Please ask your server administrator or hoster to update this PHP setting.', 'thegem'),

        'alert_check_activations' => __('You have exceeded the max. number of activations, allowed by this activation key.', 'thegem'),
        'alert_buy_license' => __('Please purchase additional copy of TheGem in order to get a new valid activation key.', 'thegem'),
        'alert_contact_support' => __('In case of any questions in this concern please contact our support.', 'thegem'),
        'alert_code_empty' => __('Purchase code is empty.', 'thegem'),
        'alert_code_valid' => __('Thank you, your purchase code is valid. TheGem has been activated.', 'thegem'),

        'placeholder_purchase_code' => __('Enter purchase code, e.g. 3oe95h8dk-a05d-3of9-ir95-1ims84ie02k', 'thegem'),
        'activation_failed' => __("Activation failed. Please try again."),

        'status_active' => __("Activated"),
        'status_not_active' => __("Not activated"),
    ),
    'info' => array (
        'portfolio_excerpt' => __('Specify description for this portfolio item to show in portfolio list / grid.'),
        'post_excerpt' => __('Specify description for this blog post to show in blog list / grid / slider and featured posts slider.'),
        'layout_style_layout' => __('<p>General website layout for desktop resolutions starting from 1260px and above.</p><p><b>Fullwidth:</b> page body covers the whole browser width.</p><p><b>Boxed:</b> page body is in the box of 1260px width and has a fullwidth background.</p><p><b>Body Frame:</b> page body has a frame around it.</p>', 'thegem'),
        'layout_style_body_frame' => __('Thickness of the frame around the body. Recommended max. value: 30px.', 'thegem'),
        'layout_background_style' => __('Specify the background type and select the background for boxed layout or body frame. This background will be used also in case of perspective menu.', 'thegem'),
        'content_background_type' => __('Specify the background type and select the background for main content area. Here you can specify it for the whole website globally. You can also specify it for individual posttypes and individual posts/pages separately.', 'thegem'),
        'content_top_padding' => __('Specify top padding for main content area. It is a spacing between header and main content. If title area is enabled, it is a spacing between title area and main content. Here you can specify it for the whole website globally. You can also specify it for individual posttypes and individual posts/pages separately.', 'thegem'),
        'content_top_padding_woo' => __('Specify top padding for WooCommerce pages: product pages and product archives (categories, tags). You can also specify different top padding for product pages and product archives in “Single Pages” and “Archive Pages” and for individual product pages and product archives in page options.', 'thegem'),
        'content_bottom_padding' => __('Specify bottom padding for main content area.  It is a spacing between main content and footer area. Here you can specify it for the whole website globally. You can also specify it for individual posttypes and individual posts/pages separately.', 'thegem'),
        'sidebar' => __('Enable or disable sidebar for the whole website globally. You can also switch on/off sidebar for individual posttypes and individual posts/pages separately.', 'thegem'),
        'sidebar_style' => __('Choose between left or right sidebar.', 'thegem'),
        'sidebar_sticky' => __('Enable in case you wish to make a sidebar sticky while vertical scrolling.', 'thegem'),
        'smooth_scroll' => __('Smooth scroll for vertical scrolling. Activate for better user experience. Deactivate for better pagespeed scores.', 'thegem'),
        'scroll_to_top_button' => __('This button appears in the right bottom corner of the page while scrolling vertically and allows quick scroll to the top of the page.', 'thegem'),
        'preloader' => __('Preloader appears while page is loading. Here you can enable or disable page preloader for the whole website globally. You can also switch on/off this preloader for individual posttypes and individual posts/pages separately.', 'thegem'),
        'preloader_style' => __('Select the preloader style. Choose from pre-made GIFs, CSS preloader or specify your own custom style.', 'thegem'),
        'preloader_colors' => __('Specify the colors of the circles in CSS preloader.', 'thegem'),
        'page_layout_breadcrumbs' => __('Enable/disable content breadcrumbs on WooCommerce pages: product archives and products.', 'thegem'),
        'page_layout_breadcrumbs_settings' => __('Set up colors of breadcrumbs, as well as its alignment in title area and choose delimiter.', 'thegem'),

        'logo_dark_logo' => __("Select or upload a website logo to be used on white/light header backgrounds. Use slider to define the width of the logo. For best retina results use image width 3 times larger than the width specified in slider. Example: on TheGem's demo website the logo width for desktops is specified with 164 px -> the logo image file used has 164 px x 3 = 492 pix width.", 'thegem'),
        'logo_light_logo' => __("Select or upload a website logo to be used on dark header backgrounds. Use slider to define the width of the logo. For best retina results use image width 3 times larger than the width specified in slider. Example: on TheGem's demo website the logo width for desktops is specified with 164 px -> the logo image file used has 164 px x 3 = 492 pix width.", 'thegem'),
        'logo_desktop' => __("Select or upload a default website logo for desktops. Use slider to define the width of the logo. For best retina results use image width 3 times larger than the width specified in slider. Example: on TheGem's demo website the logo width for desktops is specified with 164 px -> the logo image file used has 164 px x 3 = 492 pix width.", 'thegem'),
        'logo_desktop_light' => __("Select or upload a website logo to be used on dark header backgrounds. This logo will be used in case \"Use Light Menu & Logo\" setting is enabled in \"Menu & Header\" options. Use slider to define the width of the logo. For best retina results use image width 3 times larger than the width specified in slider. Example: on TheGem's demo website the logo width for desktops is specified with 164 px -> the logo image file used has 164 px x 3 = 492 pix width.", 'thegem'),
        'logo_mobile' => __("Select or upload a default website logo for mobiles. This logo is used in sticky menu as well. Use slider to define the width of the logo. For best retina results use image width 3 times larger than the width specified in slider. Example: on TheGem's demo website the logo width for mobiles is specified with 132 px -> the logo image file used has 132 px x 3 = 396 pix width.", 'thegem'),
        'logo_mobile_light' => __("Select or upload a website logo for mobiles to be used on dark header backgrounds. This logo will be used in case \"Use Light Menu & Logo\" setting is enabled in \"Menu & Header\" options. Use slider to define the width of the logo. For best retina results use image width 3 times larger than the width specified in slider. Example: on TheGem's demo website the logo width for mobiles is specified with 132 px -> the logo image file used has 132 px x 3 = 396 pix width.", 'thegem'),
        'favicon' => __('Select or upload a website favicon.', 'thegem'),

        'layout_header' => __('Header includes menu area and top area. Here you can enable or disable the header for the whole website globally. You can also switch on/off the header for individual posttypes and individual posts/pages separately.', 'thegem'),
        'layout_header_source' => __('<p>TheGem includes flexible <b>built-in header</b> with many configuration options as well as <b>header builder</b>, allowing you to create header templates with page builder. Here you can specify, which type of header to use globally across your website. You can also specify the type of header to use for individual posttypes and individual posts/pages separately.</p>', 'thegem'),
        'layout_header_builder_template' => __('<p>Select header template. You can create new header templates in <a href="'.get_site_url().'/wp-admin/edit.php?post_type=thegem_templates&templates_type=header" target="_blank">Templates Builder -> Header</a></p>', 'thegem'),
        'layout_header_sticky' => __('<p>Enable/disable sticky header for desktop/mobile. By enabling sticky header you can then select the header template to be used as sticky header and specify sticky header opacity. Alternatively, you can make sticky header by enabling "sticky" option in a row (WPBakery) / section (Elementor). <br/><br/> Additionally you can enable <b>"Hide On Scroll"</b> sticky effect. If enabled, the sticky header will first appear and then disappear by scrolling down. It will appear again by scrolling up.  </p>', 'thegem'),
        'layout_header_responsive_menu' => __('<p>Select the menu style for responsive menu. You can choose between four layout styles and select color preset (light/dark).</p>', 'thegem'),
        'layout_header_overlap' => __('<p>By enabling this option the selected header template will overlap the content area of the webpage. This option is useful for making transparent headers. If enabled, you can then specify the opacity of the header and enable light color scheme (useful for dark content area backgrounds).</p>', 'thegem'),
        'layout_menu_header_layout' => __('Specify the layout for website header & menu. "Preview" shows a dummy page with header & menu layout as specified in settings.', 'thegem'),
        'layout_menu_menu' => __('Here you can enable or disable menu for the whole website globally. You can also switch on/off menu for individual posttypes and individual posts/pages separately.', 'thegem'),
        'menu_menu_options' => __('<p><b> Menu Transparency:</b> if enabled, menu & header will be put upon your hero / slider / title area with transparent background. You can then control the transparency level using "Opacity" setting.</p><p><b>Use Light Menu & Logo:</b> in case your website has a dark header area, it is recommended to enable this option to show light menu & logo instead of defaults.</p><p><b>Search Icon:</b> show/hide search icon in menu.</p>', 'thegem'),
        'menu_sticky_header' => __('Enable or disable sticky header for vertical scroll.', 'thegem'),
        'top_area_top_area_layout' => __ ('Specifiy content alignment in top area.', 'thegem'),
        'top_area_top_area_options' => __ ('<p><b>Top Area Transparency:</b> if enabled, top area will be put upon your hero / slider / title area with transparent background. You can then control the transparency level using "Opacity" setting.</p><p><b>Show Contacts:</b> By activating this option your contact data will be displayed in top area of your website. You can edit your contact data in "Contacts & Socials" section of Theme Options.</p><p><b>Show Socials:</b> By activating this option the links to your social profiles will be displayed in top area of your website. You can edit your social profiles in "Contacts & Socials" section of Theme Options.</p>', 'thegem'),
        'top_area_sticky_top_area' => __ ('Enable or disable sticky top area for vertical scroll.', 'thegem'),
        'top_area_top_area_button' => __ ('Show/hide button in top area. You can specify button text & link.', 'thegem'),
        'top_area_button_colors' => __ ('Customize colors of top area button.', 'thegem'),

        'website_search' => __('Enable/disable website search and search icon/control in navigation.', 'thegem'),
        'website_search_layout' => __('Select layout for your website search.', 'thegem'),
        'website_search_placeholder_text' => __('Define placeholder text for search input.', 'thegem'),
        'website_search_post_types' => __('Select which post types should be shown on search results page.', 'thegem'),
        'website_search_ajax' => __('This will display quick search results / auto-suggestions whenever you input characters in the search box.', 'thegem'),
        'website_search_products_auto_suggestions' => __('Specify max. number of products suggestions.', 'thegem'),
        'website_search_posts_auto_suggestions' => __('Specify max. number of blog posts suggestions.', 'thegem'),
        'website_search_posts_result_title' => __('Specify title for posts results.', 'thegem'),
        'website_search_pages_auto_suggestions' => __('Specify max. number of pages suggestions.', 'thegem'),
        'website_search_pages_result_title' => __('Specify title for pages results.', 'thegem'),
        'website_search_portfolio_auto_suggestions' => __('Specify max. number of portfolio suggestions.', 'thegem'),
        'website_search_portfolio_result_title' => __('Specify title for portfolio results.', 'thegem'),
        'website_search_popular' => __('If enabled, you can then specify some search terms as suggestions for your website visitors.', 'thegem'),
        'website_search_popular_title' => __('Define title for popular searches.', 'thegem'),
        'website_search_select_terms' => __('Specify search terms suggestions for your website visitors.', 'thegem'),
        'website_search_view_results_button_text' => __('Specify text for "View Search Results" Button', 'thegem'),

        'main_menu_font' => __ ('Specify font for main menu items. Select font family, size, style and other options. Click on "Preview" to see the results.', 'thegem'),
        'main_menu_level_1_font_color' => __ ('Specify font colors for main menu items.', 'thegem'),
        'submenu_font' => __ ('Specify font for submenu items. Select font family, size, style and other options. Click on "Preview" to see the results.', 'thegem'),
        'submenu_level_2_font_color' => __ ('Specify font colors for submenu items (level 2).', 'thegem'),
        'submenu_level_3_font_color' => __ ('Specify font colors for submenu items (level 3).', 'thegem'),
        'overlay_menu_font' => __ ('Specify font for overlay menu items. Select font family, size, style and other options. Click on "Preview" to see the results.', 'thegem'),
        'overlay_menu_font_color' => __ ('Specify font colors for overlay menu items.', 'thegem'),
        'top_area_font_colors' => __('Specify font colors for top area items.', 'thegem'),

        'backgrounds_main_menu_header_area_background' => __('Specify the background type and select the background for main menu & header area.', 'thegem'),
        'backgrounds_main_menu_header_container_background' => __('Specify the background type and select the background for main menu & header container.', 'thegem'),
        'backgrounds_header_area_background' => __('Specify the background type and select the background for header area', 'thegem'),
        'backgrounds_navigation_area_background' => __('Specify the background type and select the background for navigation area which appears by clicking on hamburger icon', 'thegem'),
        'backgrounds_navigation_vertical_background' => __('Specify the background type and select the background for main menu area', 'thegem'),
        'backgrounds_navigation_vertical_mobile_background' => __('Specify the background type and select the background for header area in responsive mode', 'thegem'),
        'backgrounds_level_1_colors' => __('Specify background colors for main menu items.', 'thegem'),
        'backgrounds_level_2_colors' => __('Specify background colors for menu items (level 2).', 'thegem'),
        'backgrounds_level_3_colors' => __('Specify background colors for menu items (level 3).', 'thegem'),
        'backgrounds_menu_border_color' => __('Specify border color for submenus.', 'thegem'),
        'submenu_highlighter_color' => __('Specify color for submenu pointer ', 'thegem'),
        'hamburger_hamburger_color' => __('"X" (hide menu) color is the color of the "X" icon in responsive menu layouts (horizontal and vertical sliding types as well as overlay type). Social Icons Color is the color of the social icons in responsive menu layouts (horizontal and vertical sliding types as well as overlay type).', 'thegem'),
        'overlay_menu_overlay_menu_colors' => __('Specify background color for overlay in overlay menu type.', 'thegem'),
        'mega_menu_mega_menu_colors' => __('Specify colors for mega menu.', 'thegem'),
        'top_area_top_area_background_type' => __('Specify the background type and select the background for top area.', 'thegem'),
        'top_area_top_area_colors' => __('Define additional colors for top area.', 'thegem'),

        'title_area_general_title_area' => __('Title area includes post/page title, excerpt and breadcrumbs. Here you can enable or disable title area for the whole website globally. You can also switch on/off title area for individual posttypes and individual posts/pages separately. ', 'thegem'),
        'title_area_general_title_area_woo' => __('Enable/disable title area for WooCommerce pages: product pages and product archives (categories, tags). If disabled, you can additionally enable/disable menu & header separator.', 'thegem'),
        'title_area_type_of_title_area' => __('<p><b>Regular Title:</b> you can setup the layout & style of title area using the settings below.</p><p><b>Title Template:</b> you can select to use title area template created in Templates Builder.</p>', 'thegem'),
        'title_area_general_breadcrumbs' => __('Enable or disable breadcrumbs for the whole website globally. You can also switch on/off breadcrumbs for individual posttypes and individual posts/pages separately.', 'thegem'),
        'title_area_general_breadcrumbs_settings' => __('Set up colors of post/page breadcrumbs, as well as its alignment in title area.', 'thegem'),
        'title_area_style_alignment_fullheight' => __('Enable this setting in case your title area should cover full height of the viewport.', 'thegem'),
        'title_area_style_alignment_fullwidth' => __('Enable this setting in case your title area should cover 100% width of the viewport.', 'thegem'),
        'title_area_style_alignment_content_alignment' => __('Specify the alignment of content elements (title, excerpt etc) inside title area.', 'thegem'),
        'title_area_style_alignment_paddings' => __('Specify the title area paddings. You can also set up top margins for a post/page title and excerpt thus reagulating spacings between this content elements. Max. width means how wide should be the row with title or excerpt text.', 'thegem'),
        'title_area_style_alignment_title_top_margin' => __('Set up top margin for post/page title. In this way you can control spacing between title and icon or title and top of the title area.', 'thegem'),
        'title_area_style_alignment_title_max_width' => __('Max. width means how wide should be the row with title text.', 'thegem'),
        'title_area_style_alignment_excerpt_top_margin' => __('Set up top margin for post/page excerpt. In this way you can control spacing between excerpt and title.', 'thegem'),
        'title_area_style_alignment_excerpt_max_width' => __('Max. width means how wide should be the row with excerpt text.', 'thegem'),
        'title_area_style_alignment_xlarge_title' => __('Extra large size preset for a post/page title.', 'thegem'),
        'title_area_style_alignment_title_color' => __('Font color of a post/page title.', 'thegem'),
        'title_area_style_alignment_excerpt_color' => __('Font color of a post/page excerpt.', 'thegem'),
        'title_area_background_type' => __('Specify the background type and select the background for title area.  ', 'thegem'),
        'title_area_background_parallax' => __('Enable or disable parallax effect for title area.', 'thegem'),
        'title_area_general_settings' => __('If enabled, you can make individual style and backgrounds settings below, which then will be embeded in custom titles dynamically.', 'thegem'),

        'footer_general_footer'  => __('Footer may include post/page bottom area (copyright area), footer widget area and custom footer area. Here you can enable or disable footer for the whole website globally. You can also switch on/off footer for individual posttypes and individual posts/pages separately.', 'thegem'),
        'footer_general_parallax'  => __("Enable or disable parallax effect for website's footer.", 'thegem'),
        'footer_general_top_margin'  => __("Specify the top margin of your website's footer. In this way you can increase/decrease the spacing between main body area and footer area.", 'thegem'),
        'footer_widget_area_widget'  => __('Footer widget area is an area below the main body where you can use different sidebar widgets. Here you can enable/disable this area for the whole website globally.', 'thegem'),
        'footer_widget_area_fullwidth'  => __('Enable this setting in case your footer widget area should cover 100% width of the viewport.', 'thegem'),
        'footer_widget_area_grid_type'  => __('Specify number of columns in footer widget area grid.', 'thegem'),
        'footer_widget_area_padding'  => __('Specify paddings for footer widget area.', 'thegem'),
        'footer_bottom_area_bottom_area'  => __('Bottom area is also referenced as a copyright area of the website. Here you can enable or disable this area for the whole website globally.', 'thegem'),
        'footer_bottom_area_fullwidth'  => __('Enable this setting in case your bottom area should cover 100% width of the viewport.', 'thegem'),
        'footer_bottom_area_padding'  => __('Specify paddings for bottom area.', 'thegem'),
        'footer_bottom_area_text_for'  => __('Enter text to appear in bottom area.', 'thegem'),
        'footer_custom_footer'  => __('In addition (or instead of) footer widget area and bottom area you can also use footer template created in Templates Builder.', 'thegem'),
        'footer_select_custom_footer'  => __('Select footer template from the list.', 'thegem'),
        'footer_widget_woocommerce' => __('WooCommerce Bottom Area is an area below the main body of product pages and product categories where you can use different WooCommerce sidebar widgets. Here you can enable/disable this area for the whole website globally.', 'thegem'),
        'footer_widget_woocommerce_product' => __('WooCommerce Bottom Area is an area below the main body of product pages and product categories where you can use different WooCommerce sidebar widgets. Here you can enable/disable this area for all product pages.', 'thegem'),
        'footer_widget_woocommerce_archive' => __('WooCommerce Bottom Area is an area below the main body of product pages and product categories where you can use different WooCommerce sidebar widgets. Here you can enable/disable this area for all product archives.', 'thegem'),

        'footer_colors_widget_area_background'  => __('Specify the background type and select the background for footer widget area.', 'thegem'),
        'footer_colors_widget_area_font_colors'  => __('Specify font colors for text content in footer widget area.', 'thegem'),
        'footer_colors_widget_area_additional_colors'  => __('Specify additional colors for content in footer widget area.', 'thegem'),
        'footer_colors_bottom_area_background'  => __('Specify the background type and select the background for bottom area.', 'thegem'),
        'footer_colors_bottom_area_font_colors'  => __('Specify font colors for text content in bottom area.', 'thegem'),
        'footer_colors_bottom_area_additional_colors'  => __('Specify additional colors for bottom area.', 'thegem'),
        'footer_colors_custom_footer_background'  => __('Specify default background type and select default background for custom footer.', 'thegem'),

        'typography_headings_body_h1_font'  => __('Specify default font for H1 headings.', 'thegem'),
        'typography_headings_body_h1_color'  => __('Specify default font color for H1 headings.', 'thegem'),
        'typography_headings_body_h2_font'  => __('Specify default font for H2 headings.', 'thegem'),
        'typography_headings_body_h2_color'  => __('Specify default font color for H2 headings.', 'thegem'),
        'typography_headings_body_h3_font'  => __('Specify default font for H3 headings.', 'thegem'),
        'typography_headings_body_h3_color'  => __('Specify default font color for H3 headings.', 'thegem'),
        'typography_headings_body_h4_font'  => __('Specify default font for H4 headings.', 'thegem'),
        'typography_headings_body_h4_color'  => __('Specify default font color for H4 headings.', 'thegem'),
        'typography_headings_body_h5_font'  => __('Specify default font for H5 headings.', 'thegem'),
        'typography_headings_body_h5_color'  => __('Specify default font color for H5 headings.', 'thegem'),
        'typography_headings_body_h6_font'  => __('Specify default font for H6 headings.', 'thegem'),
        'typography_headings_body_h6_color'  => __('Specify default font color for H6 headings.', 'thegem'),
        'typography_headings_body_body_font'  => __('Specify default body font.', 'thegem'),
        'typography_headings_body_body_color'  => __('Specify default body font color.', 'thegem'),
        'typography_headings_body_excerpt_font'  => __('Specify default font for excerpt. Excerpts can be used in title area.', 'thegem'),
        'typography_headings_body_excerpt_color'  => __('Specify default font color for excerpt. ', 'thegem'),
        'typography_headings_body_styled_subtitle_font'  => __('Specify default font for styled subtitles.', 'thegem'),
        'typography_headings_body_styled_subtitle_color'  => __('Specify default font color for styled subtitles.', 'thegem'),
        'typography_headings_body_xlarge_font'  => __('Specify default font for XLarge title.', 'thegem'),
        'typography_headings_body_light_font'  => __('Light (or thin) title is an additional style option to display titles in other font. In this way you can create stylish “bold - thin” title combinations. Here you can specify default font for thin titles. ', 'thegem'),

        'typography_elements_buttons_regular_font'  => __('Specify default font for regular style of button text.', 'thegem'),
        'typography_elements_buttons_thin_font'  => __('Specify default font for thin style of button text.', 'thegem'),
        'typography_elements_tabs_accordions_title_bold'  => __('Specify default font for bold style of titles in tabs & accordions.', 'thegem'),
        'typography_elements_tabs_accordions_title_thin'  => __('Specify default font for thin style of titles in tabs & accordions.', 'thegem'),
        'typography_elements_counters_numbers_font'  => __('Specify default font for numbers in counters.', 'thegem'),
        'typography_elements_sidebar_widgets_font'  => __('Specify default font for titles in sidebar widgets.', 'thegem'),

        'colors_elements_styled_elements_background'  => __('Specify default background color for some TheGem elements and widgets. Check the screenshot to see where it is used.', 'thegem'),
        'colors_elements_divider'  => __('Specify default color for dividers.', 'thegem'),
        'colors_elements_links'  => __('Specify default colors for links.', 'thegem'),
        'colors_elements_flat_button'  => __('Specify default colors for flat style of buttons.', 'thegem'),
        'colors_elements_outline_button'  => __('Specify default colors for outline style of buttons.', 'thegem'),
        'colors_elements_sidebar_widgets_title'  => __('Specify default colors for titles of widgets in sidebar.', 'thegem'),
        'colors_elements_sidebar_widgets_links'  => __('Specify default colors for links of widgets in sidebar.', 'thegem'),
        'colors_elements_bullets_icon'  => __('Specify default color for bullets in lists.', 'thegem'),
        'colors_elements_blockquotes_icon_in_testimonials' => __('Specify default color for blockquotes used in testimonials.', 'thegem'),
        'colors_elements_blockquotes_icon_in_quoted_text' => __('Specify default color for blockquotes used in quoted text.', 'thegem'),
        'colors_elements_date_filter_team_subtitle'  => __('Specify default color for date and subtitle text in team element.', 'thegem'),
        'colors_elements_tags' => __('Specify default colors for tags on posts and product pages.', 'thegem'),
        'colors_elements_additional_colors_1'  => __('<p>Additional colors are used as auxiliary accent colors in different TheGem elements and widgets.</p><p><b>Additional Color 1:</b> Default accent color for different fragments inside TheGem widgets and elements.</p>', 'thegem'),
        'colors_elements_additional_colors_2'  => __('<p><b>Additional Color 2:</b> Used mainly for post icons like comments, navigation as well as tags widget in sidebar.</p>', 'thegem'),
        'colors_elements_additional_colors_3'  => __('<p><b>Additional Color 3:</b> Color for likes icons and accent color in sidebar widget.</p>', 'thegem'),
        'colors_elements_additional_colors_4'  => __('<p><b>Additional Color 4:</b> One more additional auxiliary color.</p>', 'thegem'),

        'colors_icons_content_icons' => __('Specify default colors for icon element.', 'thegem'),
        'colors_icons_system_icons' => __('Specify default colors for system icons.', 'thegem'),
        'colors_icons_social_icons' => __('Specify default colors for social icons.', 'thegem'),
        'colors_icons_elements' => __('Specify default border color for some TheGem elements and widgets. Check the screenshot to see where it is used.', 'thegem'),
        'colors_icons_portfolio_gallery_hover_color' => __('Specify default color for icons in portfolio & gallery hovers.', 'thegem'),

        'colors_pagination_numeric' => __('Specify default colors for numbers pagination.', 'thegem'),
        'colors_pagination_dots' => __('Specify default colors for dots pagination.', 'thegem'),

        'colors_forms_contact_form_light_style_input' => __('Specify default input colors for contact form in light style.', 'thegem'),
        'colors_forms_contact_form_light_style_button' => __('Specify default submit button colors for contact form in light style.', 'thegem'),
        'colors_forms_contact_form_light_style_label' => __('Specify default label color for contact form in light style.', 'thegem'),
        'colors_forms_contact_form_dark_style_input' => __('Specify default input colors for contact form in dark style.', 'thegem'),
        'colors_forms_contact_form_dark_style_button' => __('Specify default submit button colors for contact form in dark style.', 'thegem'),
        'colors_forms_contact_form_dark_style_label' => __('Specify default label color for contact form in dark style.', 'thegem'),
        'colors_forms_newsletter_in_content_input' => __('Specify default input colors for mailchimp form element used in content.', 'thegem'),
        'colors_forms_newsletter_in_content_button' => __('Specify default submit button colors for mailchimp form element used in content.', 'thegem'),
        'colors_forms_newsletter_in_content_label' => __('Specify default label color for mailchimp form element used in content.', 'thegem'),
        'colors_forms_newsletter_in_content_description' => __('Specify default description color for mailchimp form element used in content.', 'thegem'),
        'colors_forms_newsletter_in_sidebars_background' => __('Specify default background color for mailchimp form widget used in sidebar.', 'thegem'),
        'colors_forms_newsletter_in_sidebars_input' => __('Specify default input colors for mailchimp form widget used in sidebar.', 'thegem'),
        'colors_forms_newsletter_in_sidebars_button' => __('Specify default submit button colors for mailchimp form widget used in sidebar.', 'thegem'),
        'colors_forms_newsletter_in_sidebars_label' => __('Specify default label color for mailchimp form widget used in sidebar.', 'thegem'),
        'colors_forms_newsletter_in_sidebars_description' => __('Specify default description color for mailchimp form widget used in sidebar.', 'thegem'),
        'colors_forms_newsletter_in_footer_background' => __('Specify default background color for mailchimp form widget used in footer widget area.', 'thegem'),
        'colors_forms_newsletter_in_footer_input' => __('Specify default input colors for mailchimp form widget used in footer widget area.', 'thegem'),
        'colors_forms_newsletter_in_footer_button' => __('Specify default submit button colors for mailchimp form widget used in footer widget area.', 'thegem'),
        'colors_forms_newsletter_in_footer_label' => __('Specify default label color for mailchimp form widget used in footer widget area.', 'thegem'),
        'colors_forms_newsletter_in_footer_description' => __('Specify default description color for mailchimp form widget used in footer widget area.', 'thegem'),
        'colors_forms_content_forms_input' => __('Specify default input colors for comments forms and other content forms.', 'thegem'),

        'colors_hover_colors' => __('Specify default colors for different hover types.. ', 'thegem'),

        'thegem_posttypes_quickfinders_title_font_bold' => __('Specify default font for the bold style of quickfinders titles.', 'thegem'),
        'thegem_posttypes_quickfinders_title_font_thin' => __('Specify default font for the thin style of quickfinders titles.', 'thegem'),
        'thegem_posttypes_quickfinders_title_text_сolor' => __('Specify default font color for quickfinders titles.', 'thegem'),
        'thegem_posttypes_quickfinders_description_font' => __('Specify default font for description in quickfinders.', 'thegem'),
        'thegem_posttypes_quickfinders_description_text_color' => __('Specify default font color for description in quickfinders. ', 'thegem'),

        'thegem_posttypes_galleries_title_font_regular' => __('Specify default font for the regular style of gallery titles.', 'thegem'),
        'thegem_posttypes_galleries_title_font_bold' => __('Specify default font for the bold style of gallery titles.', 'thegem'),
        'thegem_posttypes_galleries_description_font' => __('Specify default font for gallery description.', 'thegem'),
        'thegem_posttypes_galleries_slider_arrows' => __('Specify default colors for gallery slider arrows.', 'thegem'),
        'thegem_posttypes_galleries_lightbox_colors' => __('Specify default colors for gallery lightbox.', 'thegem'),

        'thegem_posttypes_portfolio_grids_title_font' => __('Specify default font for portfolio titles in grids.', 'thegem'),
        'thegem_posttypes_portfolio_grids_title_color' => __('Specify default font color for portfolio titles in grid.', 'thegem'),
        'thegem_posttypes_portfolio_grids_description_font' => __('Specify default font for portfolio descriptions in grids.', 'thegem'),
        'thegem_posttypes_portfolio_grids_description_color' => __('Specify default font color for portfolio description in grid.', 'thegem'),
        'thegem_posttypes_portfolio_grids_filter_buttons' => __('Specify default colors of filter buttons in portfolio grids.', 'thegem'),
        'thegem_posttypes_portfolio_grids_sorting_controls' => __('Specify default colors of sorting controls in portfolio grids.', 'thegem'),
        'thegem_posttypes_portfolio_grids_date_sets' => __('Specify default colors of date & sets in portfolio grids.', 'thegem'),
        'thegem_posttypes_portfolio_grids_separator' => __('Specify default colors of separators in portfolio grids.', 'thegem'),
        'thegem_posttypes_portfolio_grids_portfolio_slider_arrows' => __('Specify default colors of portfolio slider arrows.', 'thegem'),

        'thegem_testimonials_quoted_text_font' => __('Specify default font for quoted text in testimonials.', 'thegem'),
        'thegem_testimonials_name_text_font' => __('Specify default font for name text in testimonials.', 'thegem'),
        'thegem_testimonials_company_text_font' => __('Specify default font for company text in testimonials.', 'thegem'),
        'thegem_testimonials_position_text_font' => __('Specify default font for position text in testimonials.', 'thegem'),
        'thegem_testimonials_slider_arrows' => __('Specify default colors of testimonials slider arrows.', 'thegem'),

        'single_pages_post_global_settings_for_all_posts' => __('Enable or disable uniform post settings for all posts globally. You can change this settings for individual posts in Page Options.', 'thegem'),
        'single_pages_post_apply_on_all_existing_posts' => __('By default, global settings will be applied on all new posts. Optionally you can apply global settings set below automatically to all existing posts as well by clicking on the button "Apply Now". Please note: by doing this, current settings in the existing posts will be replaced by global settings set below.', 'thegem'),
        'single_pages_post_featured_content' => __('Show or hide featured content inside the post.', 'thegem'),
        'single_pages_post_post_elements' => __('Show or hide different post elements.', 'thegem'),
        'single_pages_post_header' => __('Header includes menu area and top area. Here you can enable or disable the header for all posts globally. You can also switch on/off the header for individual posts separately.', 'thegem'),
        'single_pages_post_header_source' => __('<p>TheGem includes flexible <b>built-in header</b> with many configuration options as well as <b>header builder</b>, allowing you to create header templates with page builder. Here you can specify, which type of header to use on all posts of your website. You can also specify the type of header to use for individual posts/pages separately in page options.</p>', 'thegem'),
        'single_pages_post_menu' => __('<p>Enable or disable menu for all posts globally. You can also switch on/off the header for individual posts separately.</p><p><b>Menu Transparency:</b> if enabled, menu & header will be put upon your hero / slider / title area with transparent background. You can then control the transparency level using "Opacity" setting.</p><p><b>Use Light Menu & Logo:</b> in case your website has a dark header area, it is recommended to enable this option to show light menu & logo instead of defaults.</p>', 'thegem'),
        'single_pages_post_use_ligth_logo' => __('In case your website has a dark header area, it is recommended to enable this option to show light logo instead of default dark logo.', 'thegem'),
        'single_pages_post_top_area' => __('Enable or disable top area for all posts globally. You can also switch on/off top area for individual posts separately.', 'thegem'),
        'single_pages_post_title_area' => __('Title area includes post title, excerpt and breadcrumbs. Here you can enable or disable title area for all posts globally. You can also switch on/off title area for individual posts separately.', 'thegem'),
        'single_pages_post_type_of_title_area' => __('<p><b>Regular Title:</b> you can setup the layout & style of title area using the settings below.</p><p><b>Title Template:</b> you can select to use title area template created in Templates Builder.</p>', 'thegem'),
        'single_pages_post_breadcrumbs' => __('Enable or disable breadcrumbs for all posts globally. You can also switch on/off breadcrumbs for individual posts separately.', 'thegem'),
        'single_pages_post_breadcrumbs_settings' => __('Set up colors of post breadcrumbs, as well as its alignment in title area and choose delimiter.', 'thegem'),
        'single_pages_post_fullheight' => __('Enable this setting in case your title area should cover full height of the viewport.', 'thegem'),
        'single_pages_post_fullwidth' => __('Enable this setting in case your title area should cover 100% width of the viewport.', 'thegem'),
        'single_pages_post_content_alignment' => __('Specify the alignment of content elements (title, excerpt etc) inside title area.', 'thegem'),
        'single_pages_post_paddings' => __('Specify the title area paddings. You can also set up top margins for a post/page title and excerpt thus reagulating spacings between this content elements. Max. width means how wide should be the row with title or excerpt text.', 'thegem'),
        'single_pages_post_title_top_margin' => __('Set up top margin for post/page title. In this way you can control spacing between title and icon or title and top of the title area.', 'thegem'),
        'single_pages_post_title_max_width' => __('Max. width means how wide should be the row with title text.', 'thegem'),
        'single_pages_post_excerpt_top_margin' => __('Set up top margin for post/page excerpt. In this way you can control spacing between excerpt and title.', 'thegem'),
        'single_pages_post_excerpt_max_width' => __('Max. width means how wide should be the row with excerpt text.', 'thegem'),
        'single_pages_post_xlarge' => __('Extra large size preset for a post title.', 'thegem'),
        'single_pages_post_title_text_color' => __('Font color of a post title.', 'thegem'),
        'single_pages_post_excerpt_text_color' => __('Font color of a post excerpt.', 'thegem'),
        'single_pages_post_background_type' => __('Specify the background type and select the background for title area.', 'thegem'),
        'single_pages_post_parallax_background' => __('Enable or disable parallax effect for title area.', 'thegem'),
        'single_pages_post_content_background_type' => __('Specify the background type and select the background for title area.', 'thegem'),
        'single_pages_post_top_padding' => __('Specify top padding for main content area. It is a spacing between header and main content. If title area is enabled, it is a spacing between title area and main content.', 'thegem'),
        'single_pages_post_bottom_padding' => __('Specify bottom padding for main content area.  It is a spacing between main content and footer area.', 'thegem'),
        'single_pages_post_sidebar' => __('Enable or disable sidebar for all posts globally. You can also switch on/off sidebar for individual posts separately.', 'thegem'),
        'single_pages_post_sidebar_style' => __('Choose between left or right sidebar.', 'thegem'),
        'single_pages_post_sticky_sidebar' => __('Enable in case you wish to make a sidebar sticky while vertical scrolling.', 'thegem'),
        'single_pages_post_footer' => __('Footer may include post bottom area (copyright area), footer widget area and custom footer area. Here you can enable or disable footer for all posts globally. You can also switch on/off footer for individual posts separately.', 'thegem'),
        'single_pages_post_parallax' => __('Enable or disable parallax effect for post footer.', 'thegem'),
        'single_pages_post_top_margin' => __('Specify the top margin of post footer. In this way you can increase/decrease the spacing between main post body area and footer area.', 'thegem'),
        'single_pages_post_footer_widget_area' => __('Footer widget area is an area below the main body where you can use different sidebar widgets. Here you can enable/disable this area for all posts globally.', 'thegem'),
        'single_pages_post_footer_widget_area_fullwidth' => __('Enable this setting in case your footer widget area should cover 100% width of the viewport.', 'thegem'),
        'single_pages_post_footer_widget_area_grid_type' => __('Specify number of columns in footer widget area grid.', 'thegem'),
        'single_pages_post_footer_widget_area_padding' => __('Specify paddings for footer widget area. ', 'thegem'),
        'single_pages_post_bottom_area' => __('Bottom area is also referenced as a copyright area of the website. Here you can enable or disable this area for all posts globally.', 'thegem'),
        'single_pages_post_bottom_area_footer_fullwidth' => __('Enable this setting in case your bottom area should cover 100% width of the viewport.', 'thegem'),
        'single_pages_post_bottom_area_padding' => __('Specify paddings for bottom area. ', 'thegem'),
        'single_pages_post_custom_footer' => __('In addition (or instead of) footer widget area and bottom area you can also use some pre-made custom footer for your post footer area.', 'thegem'),
        'single_pages_post_select_custom_footer' => __('Select footer template from the list. ', 'thegem'),
        'single_pages_post_page_preloader' => __('Preloader appears while post is loading. Here you can enable or disable post preloader for all posts globally. You can also switch on/off this preloader for individual posts separately.', 'thegem'),
        'single_pages_post_lazy_loading' => __('Lazy loading animation happens once certain post elements / content appear in viewport while vertical scrolling. This setting enables or disables this kind of animations globally for all posts.', 'thegem'),

        'single_pages_page_global_settings_for_all_pages' => __('Enable or disable uniform page settings for all pages globally. You can change this settings for individual pages in Page Options.', 'thegem'),
        'single_pages_page_apply_on_all_existing_pages' => __('By default, global settings will be applied on all new pages. Optionally you can apply global settings set below automatically to all existing pages as well by clicking on the button "Apply Now". Please note: by doing this, current settings in the existing pages will be replaced by global settings set below.', 'thegem'),
        'single_pages_page_header' => __('Header includes menu area and top area. Here you can enable or disable the header for all pages globally. You can also switch on/off the header for individual pages separately.', 'thegem'),
        'single_pages_page_header_source' => __('<p>TheGem includes flexible <b>built-in header</b> with many configuration options as well as <b>header builder</b>, allowing you to create header templates with page builder. Here you can specify, which type of header to use on all pages of your website. You can also specify the type of header to use for individual posts/pages separately in page options.</p>', 'thegem'),
        'single_pages_page_menu' => __('<p>Enable or disable menu for all pages globally. You can also switch on/off header for individual pages separately.</p><p><b>Menu Transparency:</b> if enabled, menu & header will be put upon your hero / slider / title area with transparent background. You can then control the transparency level using "Opacity" setting.</p><p><b>Use Light Menu & Logo:</b> in case your website has a dark header area, it is recommended to enable this option to show light menu & logo instead of defaults.</p>', 'thegem'),
        'single_pages_page_use_ligth_logo' => __('In case your website has a dark header area, it is recommended to enable this option to show light logo instead of default dark logo.', 'thegem'),
        'single_pages_page_top_area' => __('Enable or disable top area for all posts globally. You can also switch on/off top area for individual posts separately.', 'thegem'),
        'single_pages_page_title_area' => __('Title area includes page title, excerpt and breadcrumbs. Here you can enable or disable title area for all pages globally. You can also switch on/off title area for individual pages separately.', 'thegem'),
        'single_pages_page_breadcrumbs' => __('Enable or disable breadcrumbs for all pages globally. You can also switch on/off breadcrumbs for individual pages separately.', 'thegem'),
        'single_pages_page_breadcrumbs_settings' => __('Set up colors of post breadcrumbs, as well as its alignment in title area and choose delimiter.', 'thegem'),
        'single_pages_page_fullheight' => __('Enable this setting in case your title area should cover full height of the viewport.', 'thegem'),
        'single_pages_page_fullwidth' => __('Enable this setting in case your title area should cover 100% width of the viewport.', 'thegem'),
        'single_pages_page_content_alignment' => __('Specify the alignment of content elements (title, excerpt etc) inside title area.', 'thegem'),
        'single_pages_page_paddings' => __('Specify the title area paddings. You can also set up top margins for a post/page title and excerpt thus reagulating spacings between this content elements. Max. width means how wide should be the row with title or excerpt text.', 'thegem'),
        'single_pages_page_title_top_margin' => __('Set up top margin for post/page title. In this way you can control spacing between title and icon or title and top of the title area.', 'thegem'),
        'single_pages_page_title_max_width' => __('Max. width means how wide should be the row with title text.', 'thegem'),
        'single_pages_page_excerpt_top_margin' => __('Set up top margin for post/page excerpt. In this way you can control spacing between excerpt and title.', 'thegem'),
        'single_pages_page_excerpt_max_width' => __('Max. width means how wide should be the row with excerpt text.', 'thegem'),
        'single_pages_page_xlarge' => __('Extra large size preset for a post title.', 'thegem'),
        'single_pages_page_title_text_color' => __('Font color of a post title.', 'thegem'),
        'single_pages_page_excerpt_text_color' => __('Font color of a post excerpt.', 'thegem'),
        'single_pages_page_background_type' => __('Specify the background type and select the background for title area.', 'thegem'),
        'single_pages_page_parallax_background' => __('Enable or disable parallax effect for title area.', 'thegem'),
        'single_pages_page_content_background_type' => __('Specify the background type and select the background for main content area.', 'thegem'),
        'single_pages_page_top_padding' => __('Specify top padding for main content area. It is a spacing between header and main content. If title area is enabled, it is a spacing between title area and main content.', 'thegem'),
        'single_pages_page_bottom_padding' => __('Specify bottom padding for main content area.  It is a spacing between main content and footer area.', 'thegem'),
        'single_pages_page_sidebar' => __('Enable or disable sidebar for all pages globally. You can also switch on/off sidebar for individual pages separately.', 'thegem'),
        'single_pages_page_sidebar_style' => __('Choose between left or right sidebar.', 'thegem'),
        'single_pages_page_sticky_sidebar' => __('Enable in case you wish to make a sidebar sticky while vertical scrolling.', 'thegem'),
        'single_pages_page_footer' => __("Footer may include page's bottom area (copyright area), footer widget area and custom footer area. Here you can enable or disable footer for all pages globally. You can also switch on/off footer for individual posts separately.", 'thegem'),
        'single_pages_page_parallax' => __('Enable or disable parallax effect for page footer.', 'thegem'),
        'single_pages_page_top_margin' => __('Specify the top margin of page footer. In this way you can increase/decrease the spacing between main page body area and footer area.', 'thegem'),
        'single_pages_page_footer_widget_area' => __('Footer widget area is an area below the main body where you can use different sidebar widgets. Here you can enable/disable this area for all pages globally.', 'thegem'),
        'single_pages_page_footer_widget_area_fullwidth' => __('Enable this setting in case your footer widget area should cover 100% width of the viewport.', 'thegem'),
        'single_pages_page_footer_widget_area_grid_type' => __('Specify number of columns in footer widget area grid.', 'thegem'),
        'single_pages_page_footer_widget_area_padding' => __('Specify paddings for footer widget area.', 'thegem'),
        'single_pages_page_bottom_area' => __('Bottom area is also referenced as a copyright area of the website. Here you can enable or disable this area for all pages globally.', 'thegem'),
        'single_pages_page_bottom_area_footer_fullwidth' => __('Enable this setting in case your bottom area should cover 100% width of the viewport.', 'thegem'),
        'single_pages_page_bottom_area_padding' => __('Specify paddings for bottom area.', 'thegem'),
        'single_pages_page_custom_footer' => __('In addition (or instead of) footer widget area and bottom area you can also use some pre-made custom footer for your page footer area.', 'thegem'),
        'single_pages_page_select_custom_footer' => __('Select footer template from the list. ', 'thegem'),
        'single_pages_page_page_preloader' => __('Preloader appears while page is loading. Here you can enable or disable page preloader for all pages globally. You can also switch on/off this preloader for individual pages separately.', 'thegem'),
        'single_pages_page_lazy_loading' => __('Lazy loading animation happens once certain page elements / content appear in viewport while vertical scrolling. This setting enables or disables this kind of animations globally for all pages.', 'thegem'),

        'single_pages_portfolio_global_settings_for_all' => __('Enable or disable uniform page settings for all portfolio pages globally. You can change this settings for individual portfolio pages in Page Options.', 'thegem'),
        'single_pages_portfolio_apply_on_all_existing' => __('By default, global settings will be applied on all new portfolio pages. Optionally you can apply global settings set below automatically to all existing TheGem portfolio pages as well by clicking on the button "Apply Now". Please note: by doing this, current settings in the existing portfolio pages will be replaced by global settings set below.', 'thegem'),
        'single_pages_portfolio_parent_page' => __('Select the main parent page for your portfolio items. This setting is useful for defining your breadcrumb structure on portfolio pages.', 'thegem'),
        'single_pages_portfolio_rewrite_slug_1' => __('<p>Here you can define your own slug to appear as part of portfolio\'s URL. By default /pf/ is used.</p><p><b>IMPORTANT:</b> after changing this slugs, please visit </p>', 'thegem'),
        'single_pages_portfolio_rewrite_slug_2' => __('"Permalink Settings"','thegem'),
        'single_pages_portfolio_rewrite_slug_3' => __('page and click on "Save changes".','thegem'),
        'single_pages_portfolio_page_elements' => __('Show or hide different portfolio page elements.', 'thegem'),
        'single_pages_portfolio_header' => __('Header includes menu area and top area. Here you can enable or disable the header for all portfolio pages globally. You can also switch on/off the header for individual pages separately.', 'thegem'),
        'single_pages_portfolio_header_source' => __('<p>TheGem includes flexible <b>built-in header</b> with many configuration options as well as <b>header builder</b>, allowing you to create header templates with page builder. Here you can specify, which type of header to use on all portfolio pages of your website. You can also specify the type of header to use for individual posts/pages separately in page options.</p>', 'thegem'),
        'single_pages_portfolio_menu' => __('<p>Enable or disable menu for all portfolio pages globally. You can also switch on/off header for individual pages separately.</p><p><b>Menu Transparency:</b> if enabled, menu & header will be put upon your hero / slider / title area with transparent background. You can then control the transparency level using "Opacity" setting.</p><p><b>Use Light Menu & Logo:</b> in case your website has a dark header area, it is recommended to enable this option to show light menu & logo instead of defaults.</p>', 'thegem'),
        'single_pages_portfolio_use_ligth_logo' => __('In case your website has a dark header area, it is recommended to enable this option to show light logo instead of default dark logo.', 'thegem'),
        'single_pages_portfolio_top_area' => __('Enable or disable top area for all portfolio pages globally. You can also switch on/off top area for individual pages separately.', 'thegem'),
        'single_pages_portfolio_title_area' => __('Title area includes page title, excerpt and breadcrumbs. Here you can enable or disable title area for all portfolio pages globally. You can also switch on/off title area for individual pages separately.', 'thegem'),
        'single_pages_portfolio_type_of_title_area' => __('<p><b>Regular Title:</b> you can setup the layout & style of title area using the settings below.</p><p><b>Title Template:</b> you can select to use title area template created in Templates Builder.</p>', 'thegem'),
        'single_pages_portfolio_breadcrumbs' => __('Enable or disable breadcrumbs for all portfolio pages globally. You can also switch on/off breadcrumbs for individual pages separately.', 'thegem'),
        'single_pages_portfolio_breadcrumbs_settings' => __('Set up colors of post breadcrumbs, as well as its alignment in title area and choose delimiter.', 'thegem'),
        'single_pages_portfolio_fullheight' => __('Enable this setting in case your title area should cover full height of the viewport.', 'thegem'),
        'single_pages_portfolio_fullwidth' => __('Enable this setting in case your title area should cover 100% width of the viewport.', 'thegem'),
        'single_pages_portfolio_content_alignment' => __('Specify the alignment of content elements (title, excerpt etc) inside title area.', 'thegem'),
        'single_pages_portfolio_paddings' => __('Specify the title area paddings. You can also set up top margins for a post/page title and excerpt thus reagulating spacings between this content elements. Max. width means how wide should be the row with title or excerpt text.', 'thegem'),
        'single_pages_portfolio_title_top_margin' => __('Set up top margin for post/page title. In this way you can control spacing between title and icon or title and top of the title area.', 'thegem'),
        'single_pages_portfolio_title_max_width' => __('Max. width means how wide should be the row with title text.', 'thegem'),
        'single_pages_portfolio_excerpt_top_margin' => __('Set up top margin for post/page excerpt. In this way you can control spacing between excerpt and title.', 'thegem'),
        'single_pages_portfolio_excerpt_max_width' => __('Max. width means how wide should be the row with excerpt text.', 'thegem'),
        'single_pages_portfolio_xlarge' => __('Extra large size preset for a post title.', 'thegem'),
        'single_pages_portfolio_title_text_color' => __('Font color of a post title. ', 'thegem'),
        'single_pages_portfolio_excerpt_text_color' => __('Font color of a post excerpt.', 'thegem'),
        'single_pages_portfolio_background_type' => __('Specify the background type and select the background for title area.', 'thegem'),
        'single_pages_portfolio_parallax_background' => __('Enable or disable parallax effect for title area.', 'thegem'),
        'single_pages_portfolio_content_background_type' => __('Specify the background type and select the background for main content area.', 'thegem'),
        'single_pages_portfolio_top_padding' => __('Specify top padding for main content area. It is a spacing between header and main content. If title area is enabled, it is a spacing between title area and main content.', 'thegem'),
        'single_pages_portfolio_bottom_padding' => __('Specify bottom padding for main content area.  It is a spacing between main content and footer area.', 'thegem'),
        'single_pages_portfolio_sidebar' => __('Enable or disable sidebar for all portfolio pages globally. You can also switch on/off sidebar for individual pages separately.', 'thegem'),
        'single_pages_portfolio_sidebar_style' => __('Choose between left or right sidebar.', 'thegem'),
        'single_pages_portfolio_sticky_sidebar' => __('Enable in case you wish to make a sidebar sticky while vertical scrolling.', 'thegem'),
        'single_pages_portfolio_footer' => __("Footer may include portfolio page's bottom area (copyright area), footer widget area and custom footer area. Here you can enable or disable footer for all pages globally. You can also switch on/off footer for individual posts separately.", 'thegem'),
        'single_pages_portfolio_parallax' => __('Enable or disable parallax effect for page footer.', 'thegem'),
        'single_pages_portfolio_top_margin' => __('Specify the top margin of page footer. In this way you can increase/decrease the spacing between main page body area and footer area.', 'thegem'),
        'single_pages_portfolio_footer_widget_area' => __('Footer widget area is an area below the main body where you can use different sidebar widgets. Here you can enable/disable this area for all pages globally.', 'thegem'),
        'single_pages_portfolio_footer_widget_area_fullwidth' => __('Enable this setting in case your footer widget area should cover 100% width of the viewport.', 'thegem'),
        'single_pages_portfolio_footer_widget_area_grid_type' => __('Specify number of columns in footer widget area grid.', 'thegem'),
        'single_pages_portfolio_footer_widget_area_padding' => __('Specify paddings for footer widget area.', 'thegem'),
        'single_pages_portfolio_bottom_area' => __('Bottom area is also referenced as a copyright area of the website. Here you can enable or disable this area for all pages globally.', 'thegem'),
        'single_pages_portfolio_bottom_area_footer_fullwidth' => __('Enable this setting in case your bottom area should cover 100% width of the viewport.', 'thegem'),
        'single_pages_portfolio_bottom_area_padding' => __('Specify paddings for bottom area.', 'thegem'),
        'single_pages_portfolio_custom_footer' => __('In addition (or instead of) footer widget area and bottom area you can also use some pre-made custom footer for your page footer area.', 'thegem'),
        'single_pages_portfolio_select_custom_footer' => __('Select footer template from the list. ', 'thegem'),
        'single_pages_portfolio_page_preloader' => __('Preloader appears while portfolio page is loading. Here you can enable or disable page preloader for all portfolio pages globally. You can also switch on/off this preloader for individual pages separately.', 'thegem'),
        'single_pages_portfolio_lazy_loading' => __('Lazy loading animation happens once certain page elements / content appear in viewport while vertical scrolling. This setting enables or disables this kind of animations globally for all pages.', 'thegem'),

        'single_pages_404_page' => __('In case you wish to use custom page for 404 page, you can enable this setting and select a page from the list.', 'thegem'),

        'archive_pages_blog_global_settings_for_all' => __('Enable or disable uniform settings for all blog archive pages globally. You can change this settings for individual archive pages (for example caregories) in archive page settings (for example in blog category settings).', 'thegem'),
        'archive_pages_blog_apply_on_all_existing' => __('By default, global settings will be applied on all new blog categories. Optionally you can apply global settings set below automatically to all existing blog categories as well by clicking on the button "Apply Now". Please note: by doing this, current settings in the existing blog categories will be replaced by global settings set below.', 'thegem'),
        'archive_pages_blog_header' => __('Header includes menu area and top area. Here you can enable or disable the header for blog archive pages. ', 'thegem'),
        'archive_pages_blog_header_source' => __('<p>TheGem includes flexible <b>built-in header</b> with many configuration options as well as <b>header builder</b>, allowing you to create header templates with page builder. Here you can specify, which type of header to use on all blog archive pages of your website. You can also specify the type of header to use for individual posts/pages separately in page options.</p>', 'thegem'),
        'archive_pages_blog_menu' => __('<p>Enable or disable menu for blog archive pages. </p><p><b>Menu Transparency:</b> if enabled, menu & header will be put upon your hero / slider / title area with transparent background. You can then control the transparency level using "Opacity" setting.</p><p><b>Use Light Menu & Logo:</b> in case your website has a dark header area, it is recommended to enable this option to show light menu & logo instead of defaults.</p>', 'thegem'),
        'archive_pages_blog_use_ligth_logo' => __('In case your website has a dark header area, it is recommended to enable this option to show light logo instead of default dark logo.', 'thegem'),
        'archive_pages_blog_top_area' => __('Enable or disable top area for all posts globally. You can also switch on/off top area for individual posts separately.', 'thegem'),
        'archive_pages_blog_title_area' => __('Title area includes title, excerpt and breadcrumbs. Here you can enable or disable title area for blog archive pages.', 'thegem'),
        'archive_pages_blog_type_of_title_area' => __('<p><b>Regular Title:</b> you can setup the layout & style of title area using the settings below.</p><p><b>Title Template:</b> you can select to use title area template created in Templates Builder.</p>', 'thegem'),
        'archive_pages_blog_breadcrumbs' => __('Enable or disable breadcrumbs for blog archive pages.', 'thegem'),
        'archive_pages_blog_breadcrumbs_settings' => __('Set up colors of breadcrumbs, as well as its alignment in title area and choose delimiter.', 'thegem'),
        'archive_pages_blog_fullheight' => __('Enable this setting in case your title area should cover full height of the viewport. ', 'thegem'),
        'archive_pages_blog_fullwidth' => __('Enable this setting in case your title area should cover 100% width of the viewport.', 'thegem'),
        'archive_pages_blog_content_alignment' => __('Specify the alignment of content elements (title, excerpt etc) inside title area.', 'thegem'),
        'archive_pages_blog_paddings' => __('Specify the title area paddings. You can also set up top margins for a post/page title and excerpt thus reagulating spacings between this content elements. Max. width means how wide should be the row with title or excerpt text.', 'thegem'),
        'archive_pages_blog_title_top_margin' => __('Set up top margin for post/page title. In this way you can control spacing between title and icon or title and top of the title area.', 'thegem'),
        'archive_pages_blog_title_max_width' => __('Max. width means how wide should be the row with title text.', 'thegem'),
        'archive_pages_blog_excerpt_top_margin' => __('Set up top margin for post/page excerpt. In this way you can control spacing between excerpt and title.', 'thegem'),
        'archive_pages_blog_excerpt_max_width' => __('Max. width means how wide should be the row with excerpt text.', 'thegem'),
        'archive_pages_blog_xlarge' => __('Extra large size preset for a page title.', 'thegem'),
        'archive_pages_blog_title_text_color' => __('Font color of a page title.', 'thegem'),
        'archive_pages_blog_excerpt_text_color' => __('Font color of a page excerpt.', 'thegem'),
        'archive_pages_blog_background_type' => __('Specify the background type and select the background for title area.', 'thegem'),
        'archive_pages_blog_parallax_background' => __('Enable or disable parallax effect for title area.', 'thegem'),
        'archive_pages_blog_content_background_type' => __('Specify the background type and select the background for main content area.', 'thegem'),
        'archive_pages_blog_top_padding' => __('Specify top padding for main content area. It is a spacing between header and main content. If title area is enabled, it is a spacing between title area and main content.', 'thegem'),
        'archive_pages_blog_bottom_padding' => __('Specify bottom padding for main content area.  It is a spacing between main content and footer area.', 'thegem'),
        'archive_pages_blog_sidebar' => __('Enable or disable sidebar for blog archive pages. ', 'thegem'),
        'archive_pages_blog_sidebar_style' => __('Choose between left or right sidebar.', 'thegem'),
        'archive_pages_blog_sticky_sidebar' => __('Enable in case you wish to make a sidebar sticky while vertical scrolling.', 'thegem'),
        'archive_pages_blog_footer' => __('Footer may include post bottom area (copyright area), footer widget area and custom footer area. Here you can enable or disable footer for blog archive pages.', 'thegem'),
        'archive_pages_blog_parallax' => __('Enable or disable footer parallax effect for blog archive pages.', 'thegem'),
        'archive_pages_blog_top_margin' => __('Specify the top margin of footer. In this way you can increase/decrease the spacing between main post body area and footer area.', 'thegem'),
        'archive_pages_blog_footer_widget_area' => __('Footer widget area is an area below the main body where you can use different sidebar widgets. Here you can enable/disable this area for blog archive pages.', 'thegem'),
        'archive_pages_blog_footer_widget_area_fullwidth' => __('Enable this setting in case your footer widget area should cover 100% width of the viewport.', 'thegem'),
        'archive_pages_blog_footer_widget_area_grid_type' => __('Specify number of columns in footer widget area grid.', 'thegem'),
        'archive_pages_blog_footer_widget_area_padding' => __('Specify paddings for footer widget area. ', 'thegem'),
        'archive_pages_blog_bottom_area' => __('Bottom area is also referenced as a copyright area of the website. Here you can enable or disable this area for blog archive pages. ', 'thegem'),
        'archive_pages_blog_bottom_area_footer_fullwidth' => __('Enable this setting in case your bottom area should cover 100% width of the viewport.', 'thegem'),
        'archive_pages_blog_bottom_area_padding' => __('Specify paddings for bottom area.', 'thegem'),
        'archive_pages_blog_custom_footer' => __('In addition (or instead of) footer widget area and bottom area you can also use some pre-made custom footer for your footer area.', 'thegem'),
        'archive_pages_blog_select_custom_footer' => __('Select footer template from the list. ', 'thegem'),
        'archive_pages_blog_page_preloader' => __('Preloader appears while page is loading. Here you can enable or disable preloader for blog archive pages.', 'thegem'),
        'archive_pages_blog_lazy_loading' => __('Lazy loading animation happens once certain elements / content appear in viewport while vertical scrolling. This setting enables or disables this kind of animations for blog archive pages.', 'thegem'),
        'archive_pages_blog_social_sharing' => __('Enable or disable the sharing button in the blog list.', 'thegem'),
        'archive_pages_blog_layout_type' => __('Select the layout type for the blog archive pages (categories, tags).', 'thegem'),
        'archive_pages_blog_layout_type_grid' => __('Select grid layout for the blog grid.', 'thegem'),
        'archive_pages_blog_layout_skin' => __('Select between two design skins for blog grid appearance.', 'thegem'),
        'archive_pages_blog_layout_columns' => __('Specify number of columns for the blog grid on different screens. In case of selecting 100% width for desktop, your blog grid will be automatically stretched to the 100% width of the page and you will get an additional option “100% Width Columns” to specify the number of columns for 100% width grid for screen resolutions greater than 1920px.', 'thegem'),
        'archive_pages_blog_layout_gaps' => __('Specify gaps width between posts in the blog grid.', 'thegem'),
        'archive_pages_blog_layout_sorting' => __('Show/hide sorting control in the blog grid.', 'thegem'),
        'archive_pages_blog_layout_hover_effect' => __('Select hover effect for post images while hovering on post in blog grid.', 'thegem'),
        'archive_pages_blog_layout_icon_on_hover' => __('Enable/disable icon on post hover in blog grid.', 'thegem'),
        'archive_pages_blog_layout_caption_position' => __('Specify the position of post caption in blog grid.', 'thegem'),
        'archive_pages_blog_layout_caption_featured_image' => __('Show/hide post featured image', 'thegem'),
        'archive_pages_blog_layout_caption_title' => __('Show/hide post title in posts in blog grid.', 'thegem'),
        'archive_pages_blog_layout_caption_description' => __('Show/hide post description in posts in blog grid.', 'thegem'),
        'archive_pages_blog_layout_caption_date' => __('Show/hide post date in posts in blog grid.', 'thegem'),
        'archive_pages_blog_layout_caption_categories' => __('Show/hide post category in posts in blog grid.', 'thegem'),
        'archive_pages_blog_layout_caption_author' => __('Show/hide author in posts in blog grid.', 'thegem'),
        'archive_pages_blog_layout_caption_author_avatar' => __('Show/hide author avatar in posts in blog grid.', 'thegem'),
        'archive_pages_blog_layout_caption_comments' => __('Show/hide comments in posts in blog grid.', 'thegem'),
        'archive_pages_blog_layout_caption_likes' => __('Show/hide likes in posts in blog grid.', 'thegem'),
        'archive_pages_blog_layout_caption_socials' => __('Show/hide social sharing in posts in blog grid.', 'thegem'),
        'archive_pages_blog_layout_caption_content_alignment' => __('Specify caption alignment.', 'thegem'),
        'archive_pages_blog_layout_caption_container_preset' => __('Here you can select between different color presets for caption container.', 'thegem'),
        'archive_pages_blog_layout_caption_container_bottom_border' => __('Show/hide bottom border in caption container.', 'thegem'),
        'archive_pages_blog_layout_pagination_items_per_page' => __('Specify number of posts to be displayed on one page in the blog grid.', 'thegem'),
        'archive_pages_blog_layout_pagination' => __('Enable/disable pagination in the blog grid.', 'thegem'),
        'archive_pages_blog_layout_pagination_type' => __('<p>Select pagination type.</p> <p><b>- Numbers:</b> classic numbered pagination</p> <p><b>- Load More Button:</b> additional items will be loaded by clicking on load more button</p> <p><b>- Infinite Scroll:</b> additional items will be automatically loaded while scrolling down</p>', 'thegem'),
        'archive_pages_blog_layout_load_more_text' => __('Specify text for "load more" button.', 'thegem'),
        'archive_pages_blog_layout_load_more_icon' => __('Select icon for "load more" button.', 'thegem'),
        'archive_pages_blog_layout_load_more_stretch' => __('Enable/disable fullwidth stretching for "load more" button.', 'thegem'),
        'archive_pages_blog_layout_load_more_separator' => __('Show/hide separator in "load more" button.', 'thegem'),
        'archive_pages_blog_layout_load_more_spacing' => __('Specify the spacing between the grid and the "load more" button.', 'thegem'),
        'archive_pages_blog_layout_load_more_btn_type' => __('Specify the button style preset for the "load more" button.', 'thegem'),
        'archive_pages_blog_layout_load_more_btn_size' => __('Specify the size preset for the "load more" button.', 'thegem'),
        'archive_pages_blog_layout_loading_animation' => __('Enable/disable lazy loading animation for posts in the blog grid.', 'thegem'),
        'archive_pages_blog_layout_animation_effect' => __('Select animation effect.', 'thegem'),
        'archive_pages_blog_layout_ignore_highlights' => __('In TheGem you can specify some posts to be emphasized in the blog grid - they will be displayed double bigger as other posts. You can make it by enabling the option "Highlighted Product" in page options of the blog post. This is a cool way of attracting visitors attention to some post highlights and to make creative grids. By activating “Ignore Highlighted Products” control here posts emphasizing will be ignored and all highlighted posts will be displayed as normal posts.', 'thegem'),
        'archive_pages_blog_layout_skeleton_loader' => __('Enable/disable skeleton preloader for grid loading.', 'thegem'),
        'archive_pages_search_custom_settings_for_search' => __('Enable or disable uniform custom settings for search page.', 'thegem'),
        'archive_pages_search_header' => __('Header includes menu area and top area. Here you can enable or disable the header for search page.', 'thegem'),
        'archive_pages_search_header_source' => __('<p>TheGem includes flexible <b>built-in header</b> with many configuration options as well as <b>header builder</b>, allowing you to create header templates with page builder. Here you can specify, which type of header to use on a search page of your website. You can also specify the type of header to use for individual posts/pages separately in page options.</p>', 'thegem'),
        'archive_pages_search_menu' => __('<p>Enable or disable menu for search page. </p><p><b>Menu Transparency:</b> if enabled, menu & header will be put upon your hero / slider / title area with transparent background. You can then control the transparency level using "Opacity" setting.</p><p><b>Use Light Menu & Logo:</b> in case your website has a dark header area, it is recommended to enable this option to show light menu & logo instead of defaults.</p>', 'thegem'),
        'archive_pages_search_use_ligth_logo' => __('In case your website has a dark header area, it is recommended to enable this option to show light logo instead of default dark logo.', 'thegem'),
        'archive_pages_search_top_area' => __('Enable or disable top area for all posts globally. You can also switch on/off top area for individual posts separately.', 'thegem'),
        'archive_pages_search_title_area' => __('Title area includes title, excerpt and breadcrumbs. Here you can enable or disable title area for search page. ', 'thegem'),
        'archive_pages_search_type_of_title_area' => __('<p><b>Regular Title:</b> you can setup the layout & style of title area using the settings below.</p><p><b>Title Template:</b> you can select to use title area template created in Templates Builder.</p>', 'thegem'),
        'archive_pages_search_breadcrumbs' => __('Enable or disable breadcrumbs for search page. ', 'thegem'),
        'archive_pages_search_breadcrumbs_settings' => __('Set up colors of breadcrumbs, as well as its alignment in title area and choose delimiter.', 'thegem'),
        'archive_pages_search_fullheight' => __('Enable this setting in case your title area should cover full height of the viewport. ', 'thegem'),
        'archive_pages_search_fullwidth' => __('Enable this setting in case your title area should cover 100% width of the viewport.', 'thegem'),
        'archive_pages_search_content_alignment' => __('Specify the alignment of content elements (title, excerpt etc) inside title area.', 'thegem'),
        'archive_pages_search_paddings' => __('Specify the title area paddings. You can also set up top margins for a post/page title and excerpt thus reagulating spacings between this content elements. Max. width means how wide should be the row with title or excerpt text.', 'thegem'),
        'archive_pages_search_title_top_margin' => __('Set up top margin for post/page title. In this way you can control spacing between title and icon or title and top of the title area.', 'thegem'),
        'archive_pages_search_title_max_width' => __('Max. width means how wide should be the row with title text.', 'thegem'),
        'archive_pages_search_excerpt_top_margin' => __('Set up top margin for post/page excerpt. In this way you can control spacing between excerpt and title. ', 'thegem'),
        'archive_pages_search_excerpt_max_width' => __('Max. width means how wide should be the row with excerpt text.', 'thegem'),
        'archive_pages_search_xlarge_title' => __('Extra large size preset for a title.', 'thegem'),
        'archive_pages_search_title_color' => __('Font color of a page title.', 'thegem'),
        'archive_pages_search_excerpt_text_color' => __('Font color of a page excerpt.', 'thegem'),
        'archive_pages_search_background_type' => __('Specify the background type and select the background for title area.', 'thegem'),
        'archive_pages_search_parallax_background' => __('Enable or disable parallax effect for title area.', 'thegem'),
        'archive_pages_search_content_background_type' => __('Specify the background type and select the background for main content area.', 'thegem'),
        'archive_pages_search_top_padding' => __('Specify top padding for main content area. It is a spacing between header and main content. If title area is enabled, it is a spacing between title area and main content.', 'thegem'),
        'archive_pages_search_bottom_padding' => __('Specify bottom padding for main content area.  It is a spacing between main content and footer area.', 'thegem'),
        'archive_pages_search_sidebar' => __('Enable or disable sidebar for search page.', 'thegem'),
        'archive_pages_search_sidebar_style' => __('Choose between left or right sidebar.', 'thegem'),
        'archive_pages_search_sticky_sidebar' => __('Enable in case you wish to make a sidebar sticky while vertical scrolling.', 'thegem'),
        'archive_pages_search_footer' => __('Footer may include page bottom area (copyright area), footer widget area and custom footer area. Here you can enable or disable footer for search page.', 'thegem'),
        'archive_pages_search_parallax' => __('Enable or disable footer parallax effect for search page.', 'thegem'),
        'archive_pages_search_top_margin' => __('Specify the top margin of footer. In this way you can increase/decrease the spacing between page body area and footer area.', 'thegem'),
        'archive_pages_search_footer_widget_area' => __('Footer widget area is an area below the main body where you can use different sidebar widgets. Here you can enable/disable this area for search page. ', 'thegem'),
        'archive_pages_search_footer_widget_area_fullwidth' => __('Enable this setting in case your footer widget area should cover 100% width of the viewport.', 'thegem'),
        'archive_pages_search_footer_widget_area_grid_type' => __('Specify number of columns in footer widget area grid.', 'thegem'),
        'archive_pages_search_footer_widget_area_padding' => __('Specify paddings for footer widget area.', 'thegem'),
        'archive_pages_search_bottom_area' => __('Bottom area is also referenced as a copyright area of the website. Here you can enable or disable this area for search page.', 'thegem'),
        'archive_pages_search_bottom_area_footer_fullwidth' => __('Enable this setting in case your bottom area should cover 100% width of the viewport.', 'thegem'),
        'archive_pages_search_bottom_area_padding' => __('Specify paddings for bottom area.', 'thegem'),
        'archive_pages_search_custom_footer' => __('In addition (or instead of) footer widget area and bottom area you can also use some pre-made custom footer for your footer area.', 'thegem'),
        'archive_pages_search_select_custom_footer' => __('Select footer template from the list. ', 'thegem'),
        'archive_pages_search_page_preloader' => __('Preloader appears while page is loading. Here you can enable or disable preloader for search page. ', 'thegem'),
        'archive_pages_search_lazy_loading' => __('Lazy loading animation happens once certain elements / content appear in viewport while vertical scrolling. This setting enables or disables this kind of animations for search page.', 'thegem'),
        'archive_pages_search_layout_type' => __('Select the layout type for the search results grid.', 'thegem'),
        'archive_pages_search_layout_type_grid' => __('Select grid layout for the search results grid.', 'thegem'),
        'archive_pages_search_layout_skin' => __('Select between two design skins for search results grid appearance.', 'thegem'),
        'archive_pages_search_layout_columns' => __('Specify number of columns for the search results grid on different screens. In case of selecting 100% width for desktop, your search results grid will be automatically stretched to the 100% width of the page and you will get an additional option “100% Width Columns” to specify the number of columns for 100% width grid for screen resolutions greater than 1920px.', 'thegem'),
        'archive_pages_search_layout_gaps' => __('Specify gaps width between posts in the search results grid.', 'thegem'),
        'archive_pages_search_layout_sorting' => __('Show/hide sorting control in the search results grid.', 'thegem'),
        'archive_pages_search_layout_hover_effect' => __('Select hover effect for post images while hovering on post in search results grid.', 'thegem'),
        'archive_pages_search_layout_icon_on_hover' => __('Enable/disable icon on post hover in search results grid.', 'thegem'),
        'archive_pages_search_layout_post_type_indication' => __('Enable/disable indication of the search result`s post type.', 'thegem'),
        'archive_pages_search_layout_caption_position' => __('Specify the position of post caption in search results grid.', 'thegem'),
        'archive_pages_search_layout_caption_featured_image' => __('Show/hide post featured image', 'thegem'),
        'archive_pages_search_layout_caption_title' => __('Show/hide post title in posts in search results grid.', 'thegem'),
        'archive_pages_search_layout_caption_description' => __('Show/hide post description in posts in search results grid.', 'thegem'),
        'archive_pages_search_layout_caption_date' => __('Show/hide post date in posts in search results grid.', 'thegem'),
        'archive_pages_search_layout_caption_categories' => __('Show/hide post category in posts in search results grid.', 'thegem'),
        'archive_pages_search_layout_caption_author' => __('Show/hide author in posts in search results grid.', 'thegem'),
        'archive_pages_search_layout_caption_author_avatar' => __('Show/hide author avatar in posts in search results grid.', 'thegem'),
        'archive_pages_search_layout_caption_content_alignment' => __('Specify caption alignment.', 'thegem'),
        'archive_pages_search_layout_caption_container_preset' => __('Here you can select between different color presets for caption container.', 'thegem'),
        'archive_pages_search_layout_caption_container_bottom_border' => __('Show/hide bottom border in caption container.', 'thegem'),
        'archive_pages_search_layout_pagination_items_per_page' => __('Specify number of posts to be displayed on one page in the search results grid.', 'thegem'),
        'archive_pages_search_layout_pagination' => __('Enable/disable pagination in the search results grid.', 'thegem'),
        'archive_pages_search_layout_pagination_type' => __('<p>Select pagination type.</p> <p><b>- Numbers:</b> classic numbered pagination</p> <p><b>- Load More Button:</b> additional items will be loaded by clicking on load more button</p> <p><b>- Infinite Scroll:</b> additional items will be automatically loaded while scrolling down</p>', 'thegem'),
        'archive_pages_search_layout_load_more_text' => __('Specify text for "load more" button.', 'thegem'),
        'archive_pages_search_layout_load_more_icon' => __('Select icon for "load more" button.', 'thegem'),
        'archive_pages_search_layout_load_more_stretch' => __('Enable/disable fullwidth stretching for "load more" button.', 'thegem'),
        'archive_pages_search_layout_load_more_separator' => __('Show/hide separator in "load more" button.', 'thegem'),
        'archive_pages_search_layout_load_more_spacing' => __('Specify the spacing between the grid and the "load more" button.', 'thegem'),
        'archive_pages_search_layout_load_more_btn_type' => __('Specify the button style preset for the "load more" button.', 'thegem'),
        'archive_pages_search_layout_load_more_btn_size' => __('Specify the size preset for the "load more" button.', 'thegem'),
        'archive_pages_search_layout_mixed_grids_items' => __('Specify the number of search results to display.', 'thegem'),
        'archive_pages_search_layout_mixed_grids_title' => __('Specify title text for posts and pages results.', 'thegem'),
        'archive_pages_search_layout_mixed_grids_show_all' => __('Specify the button text for "Show all results" button', 'thegem'),
        'archive_pages_search_layout_mixed_grids_show_all_icon' => __('Select icon for "Show all results" button.', 'thegem'),
        'archive_pages_search_layout_mixed_grids_show_all_stretch' => __('Enable/disable fullwidth stretching for ""Show all results" button.', 'thegem'),
        'archive_pages_search_layout_mixed_grids_show_all_separator' => __('Show/hide separator in "Show all results" button.', 'thegem'),
        'archive_pages_search_layout_mixed_grids_show_all_spacing' => __('Specify the spacing between the grid and the "Show all results" button.', 'thegem'),
        'archive_pages_search_layout_mixed_grids_show_all_btn_type' => __('Specify the button style preset for the "Show all results" button.', 'thegem'),
        'archive_pages_search_layout_mixed_grids_show_all_btn_size' => __('Specify the size preset for the "Show all results" button.', 'thegem'),
        'archive_pages_search_layout_loading_animation' => __('Enable/disable lazy loading animation for posts in the search results grid.', 'thegem'),
        'archive_pages_search_layout_animation_effect' => __('Select animation effect.', 'thegem'),
        'archive_pages_search_layout_skeleton_loader' => __('Enable/disable skeleton preloader for grid loading.', 'thegem'),

        'woocommerce_general_catalog_mode' => __('Here you can enable a catalog mode for your online shop. If enabled, all prices, add to cart buttons, cart and checkout will be deactivated in your shop.', 'thegem'),
        'woocommerce_general_quick_view' => __('If enabled, quick view option will be available in product lists and grids.', 'thegem'),
        'woocommerce_general_product_list_pagination' => __('Select pagintaion type for product lists.', 'thegem'),
        'woocommerce_general_size_guide_image' => __('Select size guide image in case you wish to enable size guide on product pages.', 'thegem'),
        'woocommerce_general_use_custom_image_settings' => __('If enabled, you can then specify your own custom image sizes for product images in product lists, product pages and for product thumbnails. To apply this custom image sizes, you need to re-generate image thumbnails in', 'thegem'),
        'woocommerce_general_catalog_image_sizes' => __('This image size is used for product lists like shop main page, shop categories and archives, related products in case "Classic Grid" layout type has been selected in', 'thegem'),
        'woocommerce_general_product_image_sizes' => __('Specify your own custom image sizes for product images in gallery grids on product pages. To apply this custom image sizes, you need to re-generate image thumbnails in', 'thegem'),
        'woocommerce_general_thumbnail_image_sizes1' => __('This image size is used for product galleries on product page in case horizontal thumbnails gallery type has been selected in', 'thegem'),
        'woocommerce_general_thumbnail_image_sizes2' => __('as well as for WooCommerce sidebar widgets with products', 'thegem'),

        'woocommerce_product_styles_title_font_listings_grids' => __('Specify typography for product titles in product catalogs, listings and grids.', 'thegem'),
        'woocommerce_product_styles_title_font_product_page' => __('Specify typography for product titles in product pages.', 'thegem'),
        'woocommerce_product_styles_title_font_widget' => __('Specify typography for product titles in sidebar widgets.', 'thegem'),
        'woocommerce_product_styles_title_font_cart' => __('Specify typography for product titles in cart.', 'thegem'),
        'woocommerce_product_styles_price_font_listings_grids' => __('Specify typography for product price in product catalogs, listings and grids.', 'thegem'),
        'woocommerce_product_styles_price_font_product_page' => __('Specify typography for product price in product pages.', 'thegem'),
        'woocommerce_product_styles_price_font_widget' => __('Specify typography for product price in sidebar widgets.', 'thegem'),
        'woocommerce_product_styles_price_font_cart' => __('Specify typography for product price in cart.', 'thegem'),
        'woocommerce_product_styles_price_font_product_categories' => __('Specify typography for product price in product categories.', 'thegem'),
        'woocommerce_product_styles_listings_and_grids' => __('Specify the color for product separator in listings & grids.', 'thegem'),
        'woocommerce_product_styles_labels' => __('TheGem comes with 6 different styles of labels, which you can choose from.', 'thegem'),
        'woocommerce_product_styles_label_new' => __('Specify text for "New" label.', 'thegem'),
        'woocommerce_product_styles_label_sale' => __('Select type and specify text for "Sale" label.', 'thegem'),
        'woocommerce_product_styles_label_out_of_stock' => __('Specify text for "Out of stock" label.', 'thegem'),

        'woocommerce_product_page_layout_source' => __('<p>TheGem includes flexible <b>built-in settings</b> for single product page layout with many configuration options as well as <b>single product builder</b>, allowing you to create product page templates with page builder. Here you can specify, which type of layout settings to use for single product pages. You can also specify the type of layout settings to use for individual product pages in page options of this products separately.</p>', 'thegem'),
        'woocommerce_product_page_layout_source_po' => __('<p>TheGem includes flexible <b>built-in settings</b> for single product page layout with many configuration options (located in <a href="'.get_site_url().'/wp-admin/admin.php?page=thegem-theme-options#/woocommerce/product-layout" target="_blank">Theme Options -> WooCommerce -> Product</a>) as well as <b>single product builder</b>, allowing you to create product page templates with page builder. Here you can specify, which type of layout settings to use for this product page.</p>', 'thegem'),
        'woocommerce_product_page_builder_template' => __('<p>Select single product template. You can create new product templates in <a href="'.get_site_url().'/wp-admin/edit.php?post_type=thegem_templates&templates_type=single-product" target="_blank">Templates Builder -> Single Product</a></p>', 'thegem'),
        'woocommerce_product_page_global_settings_for_all' => __('Enable or disable uniform product page settings for all product pages globally. You can change this settings for individual product pages in Page Options.', 'thegem'),
        'woocommerce_product_page_apply_on_all_existing' => __('By default, global settings will be applied on all new products. Optionally you can apply global settings set below automatically to all existing products as well by clicking on the button "Apply Now". Please note: by doing this, current settings in the existing products will be replaced by global settings set below.', 'thegem'),
        'woocommerce_product_page_layout_ajax_add_to_cart' => __('Enable/disable adding product to the cart using AJAX (without reloading the product page).', 'thegem'),
        'woocommerce_product_page_layout_product_layout' => __('Select product layout.', 'thegem'),
        'woocommerce_product_page_layout_preset' => __('Here you can select pre-made product layout preset, which you can further adjust using the settings below.', 'thegem'),
        'woocommerce_product_page_layout_columns_width_preset' => __('Here you can select width preset for the product columns.', 'thegem'),
        'woocommerce_product_page_layout_gallery_columns_width' => __('Specify width of the column with the product gallery.', 'thegem'),
        'woocommerce_product_page_layout_full_width_layout' => __('Enable/disable 100% width layout for product (stretch content to 100% width).', 'thegem'),
        'woocommerce_product_page_layout_sticky_product' => __('If enabled, column with product gallery will stay sticky on scroll. In case the section with product gallery is higher than the section with product description, product description will stay sticky instead.', 'thegem'),
        'woocommerce_product_page_skeleton_loader' => __('Enable/disable skeleton preloader for product.', 'thegem'),
        'woocommerce_product_page_layout_centered' => __('If enabled, the section with product title, price and short description will be centered horizontally and vertically in relation to product gallery.', 'thegem'),
        'woocommerce_product_page_layout_centered_top_margin' => __('Specify top margin for product info.', 'thegem'),
        'woocommerce_product_page_layout_centered_boxed' => __('If enabled, section with product title, price and short description will be placed in the box.', 'thegem'),
        'woocommerce_product_page_layout_centered_boxed_color' => __('Specify background color for product info box.', 'thegem'),
        'woocommerce_product_page_layout_background' => __('Specify background color for product gallery & product info section.', 'thegem'),
        'woocommerce_product_page_header' => __('Header includes menu area and top area. Here you can enable or disable the header for product page.', 'thegem'),
        'woocommerce_product_page_header_source' => __('<p>TheGem includes flexible <b>built-in header</b> with many configuration options as well as <b>header builder</b>, allowing you to create header templates with page builder. Here you can specify, which type of header to use on all product pages of your website. You can also specify the type of header to use for individual posts/pages separately in page options.</p>', 'thegem'),
        'woocommerce_product_page_menu' => __('<p>Enable or disable menu for product page. </p><p><b>Menu Transparency:</b> if enabled, menu & header will be put upon your hero / slider / title area with transparent background. You can then control the transparency level using "Opacity" setting.</p><p><b>Use Light Menu & Logo:</b> in case your website has a dark header area, it is recommended to enable this option to show light menu & logo instead of defaults.</p>', 'thegem'),
        'woocommerce_product_page_use_ligth_logo' => __('In case your website has a dark header area, it is recommended to enable this option to show light logo instead of default dark logo.', 'thegem'),
        'woocommerce_product_page_top_area' => __('Enable or disable top area for all posts globally. You can also switch on/off top area for individual posts separately.', 'thegem'),
        'woocommerce_product_page_title_area' => __('Title area includes title, excerpt and breadcrumbs. Here you can enable or disable title area for product page. If disabled, you can additionally enable/disable menu & header separator.', 'thegem'),
        'woocommerce_product_page_type_of_title_area' => __('<p><b>Regular Title:</b> you can setup the layout & style of title area using the settings below.</p><p><b>Title Template:</b> you can select to use title area template created in Templates Builder.</p>', 'thegem'),
        'woocommerce_product_page_breadcrumbs' => __('Enable or disable breadcrumbs for product page.', 'thegem'),
        'woocommerce_product_page_breadcrumbs_settings' => __('Set up colors of breadcrumbs, as well as its alignment in title area and choose delimiter.', 'thegem'),
        'woocommerce_product_page_fullheight' => __('Enable this setting in case your title area should cover full height of the viewport.', 'thegem'),
        'woocommerce_product_page_fullwidth' => __('Enable this setting in case your title area should cover 100% width of the viewport.', 'thegem'),
        'woocommerce_product_page_content_alignment' => __('Specify the alignment of content elements (title, excerpt etc) inside title area.', 'thegem'),
        'woocommerce_product_page_paddings' => __('Specify the title area paddings. You can also set up top margins for a post/page title and excerpt thus reagulating spacings between this content elements. Max. width means how wide should be the row with title or excerpt text.', 'thegem'),
        'woocommerce_product_page_title_top_margin' => __('Set up top margin for post/page title. In this way you can control spacing between title and icon or title and top of the title area.', 'thegem'),
        'woocommerce_product_page_title_max_width' => __('Max. width means how wide should be the row with title text.', 'thegem'),
        'woocommerce_product_page_excerpt_top_margin' => __('Set up top margin for post/page excerpt. In this way you can control spacing between excerpt and title.', 'thegem'),
        'woocommerce_product_page_excerpt_max_width' => __('Max. width means how wide should be the row with excerpt text.', 'thegem'),
        'woocommerce_product_page_xlarge_title' => __('Extra large size preset for a page title.', 'thegem'),
        'woocommerce_product_page_title_text_color' => __('Font color of a page title.', 'thegem'),
        'woocommerce_product_page_excerpt_text_color' => __('Font color of a page excerpt.', 'thegem'),
        'woocommerce_product_page_background_type' => __('Specify the background type and select the background for title area.', 'thegem'),
        'woocommerce_product_page_parallax_background' => __('Enable or disable parallax effect for title area.', 'thegem'),
        'woocommerce_product_page_content_background_type' => __('Specify the background type and select the background for main content area.', 'thegem'),
        'woocommerce_product_page_top_padding' => __('Specify top padding for main content area. It is a spacing between header and main content. If title area is enabled, it is a spacing between title area and main content.', 'thegem'),
        'woocommerce_product_page_bottom_padding' => __('Specify bottom padding for main content area.  It is a spacing between main content and footer area.', 'thegem'),
        'woocommerce_product_page_sidebar' => __('Enable or disable sidebar for product page.', 'thegem'),
        'woocommerce_product_page_sidebar_style' => __('Choose between left or right sidebar.', 'thegem'),
        'woocommerce_product_page_sticky_sidebar' => __('Enable in case you wish to make a sidebar sticky while vertical scrolling.', 'thegem'),
        'woocommerce_product_page_footer' => __('Footer may include post bottom area (copyright area), footer widget area and custom footer area. Here you can enable or disable footer for product page.', 'thegem'),
        'woocommerce_product_page_parallax' => __('Enable or disable footer parallax effect for product page.', 'thegem'),
        'woocommerce_product_page_top_margin' => __('Specify the top margin of footer. In this way you can increase/decrease the spacing between main post body area and footer area.', 'thegem'),
        'woocommerce_product_page_footer_widget_area' => __('Footer widget area is an area below the main body where you can use different sidebar widgets. Here you can enable/disable this area for product page.', 'thegem'),
        'woocommerce_product_page_footer_widget_area_fullwidth' => __('Enable this setting in case your footer widget area should cover 100% width of the viewport.', 'thegem'),
        'woocommerce_product_page_footer_widget_area_grid_type' => __('Specify number of columns in footer widget area grid.', 'thegem'),
        'woocommerce_product_page_footer_widget_area_padding' => __('Specify paddings for footer widget area.', 'thegem'),
        'woocommerce_product_page_bottom_area' => __('Bottom area is also referenced as a copyright area of the website. Here you can enable or disable this area for product page.', 'thegem'),
        'woocommerce_product_page_bottom_area_footer_fullwidth' => __('Enable this setting in case your bottom area should cover 100% width of the viewport.', 'thegem'),
        'woocommerce_product_page_bottom_area_padding' => __('Specify paddings for bottom area.', 'thegem'),
        'woocommerce_product_page_custom_footer' => __('In addition (or instead of) footer widget area and bottom area you can also use some pre-made custom footer for your footer area.', 'thegem'),
        'woocommerce_product_page_select_custom_footer' => __('Select footer template from the list. ', 'thegem'),
        'woocommerce_product_page_page_preloader' => __('Preloader appears while page is loading. Here you can enable or disable preloader for product page.', 'thegem'),
        'woocommerce_product_page_lazy_loading' => __('Lazy loading animation happens once certain elements / content appear in viewport while vertical scrolling. This setting enables or disables this kind of animations for product page.', 'thegem'),
        'woocommerce_product_page_social_sharing' => __('Enable or disable the social sharing in the product page.', 'thegem'),
        'woocommerce_product_page_layout_breadcrumbs' => __('Enable/disable content breadcrumbs on product pages.', 'thegem'),
        'woocommerce_product_builder_preview_product' => __('Here you can select a product to be used as a preview product in a single product builder. The data from this product will be used as an example to display different product elements while editing product template in page builder.', 'thegem'),

        'woocommerce_product_categories_global_settings_for_all' => __('Enable or disable uniform product page settings for all product categories globally. You can change this settings for individual product categories in product categories settings.', 'thegem'),
        'woocommerce_product_categories_apply_on_all_existing' => __('By default, global settings will be applied on all new product categories. Optionally you can apply global settings set below automatically to all existing product categories as well by clicking on the button "Apply Now". Please note: by doing this, current settings in the existing product categories will be replaced by global settings set below.', 'thegem'),
        'woocommerce_product_categories_header' => __('Header includes menu area and top area. Here you can enable or disable the header for product categories.', 'thegem'),
        'woocommerce_product_categories_header_source' => __('<p>TheGem includes flexible <b>built-in header</b> with many configuration options as well as <b>header builder</b>, allowing you to create header templates with page builder. Here you can specify, which type of header to use on all product archive pages of your website. You can also specify the type of header to use for individual posts/pages separately in page options.</p>', 'thegem'),
        'woocommerce_product_categories_menu' => __('<p>Enable or disable menu for product categories.</p><p><b>Menu Transparency:</b> if enabled, menu & header will be put upon your hero / slider / title area with transparent background. You can then control the transparency level using "Opacity" setting.</p><p><b>Use Light Menu & Logo:</b> in case your website has a dark header area, it is recommended to enable this option to show light menu & logo instead of defaults.</p>', 'thegem'),
        'woocommerce_product_categories_use_ligth_logo' => __('In case your website has a dark header area, it is recommended to enable this option to show light logo instead of default dark logo.', 'thegem'),
        'woocommerce_product_categories_top_area' => __('Enable or disable top area for all posts globally. You can also switch on/off top area for individual posts separately.', 'thegem'),
        'woocommerce_product_categories_title_area' => __('Title area includes title, excerpt and breadcrumbs. Here you can enable or disable title area for product categories. If disabled, you can additionally enable/disable menu & header separator.', 'thegem'),
        'woocommerce_product_categories_type_of_title_area' => __('<p><b>Regular Title:</b> you can setup the layout & style of title area using the settings below.</p><p><b>Title Template:</b> you can select to use title area template created in Templates Builder.</p>', 'thegem'),
        'woocommerce_product_categories_breadcrumbs' => __('Enable or disable breadcrumbs for product categories. ', 'thegem'),
        'woocommerce_product_categories_breadcrumbs_settings' => __('Set up colors of breadcrumbs, as well as its alignment in title area and choose delimiter.', 'thegem'),
        'woocommerce_product_categories_fullheight' => __('Enable this setting in case your title area should cover full height of the viewport. ', 'thegem'),
        'woocommerce_product_categories_fullwidth' => __('Enable this setting in case your title area should cover 100% width of the viewport.', 'thegem'),
        'woocommerce_product_categories_content_alignment' => __('Specify the alignment of content elements (title, excerpt etc) inside title area.', 'thegem'),
        'woocommerce_product_categories_paddings' => __('Specify the title area paddings. You can also set up top margins for a post/page title and excerpt thus reagulating spacings between this content elements. Max. width means how wide should be the row with title or excerpt text.', 'thegem'),
        'woocommerce_product_categories_title_top_margin' => __('Set up top margin for post/page title. In this way you can control spacing between title and icon or title and top of the title area.', 'thegem'),
        'woocommerce_product_categories_title_max_width' => __('Max. width means how wide should be the row with title text.', 'thegem'),
        'woocommerce_product_categories_excerpt_top_margin' => __('Set up top margin for post/page excerpt. In this way you can control spacing between excerpt and title.', 'thegem'),
        'woocommerce_product_categories_excerpt_max_width' => __('Max. width means how wide should be the row with excerpt text.', 'thegem'),
        'woocommerce_product_categories_xlarge_title' => __('Extra large size preset for a page title.', 'thegem'),
        'woocommerce_product_categories_title_text_color' => __('Font color of a page title.', 'thegem'),
        'woocommerce_product_categories_excerpt_text_color' => __('Font color of a page excerpt.', 'thegem'),
        'woocommerce_product_categories_background_type' => __('Specify the background type and select the background for title area.', 'thegem'),
        'woocommerce_product_categories_parallax_background' => __('Enable or disable parallax effect for title area.', 'thegem'),
        'woocommerce_product_categories_content_background_type' => __('Specify the background type and select the background for main content area.', 'thegem'),
        'woocommerce_product_categories_top_padding' => __('Specify top padding for main content area. It is a spacing between header and main content. If title area is enabled, it is a spacing between title area and main content.', 'thegem'),
        'woocommerce_product_categories_bottom_padding' => __('Specify bottom padding for main content area.  It is a spacing between main content and footer area.', 'thegem'),
        'woocommerce_product_categories_sidebar' => __('Enable or disable sidebar for product categories.', 'thegem'),
        'woocommerce_product_categories_sidebar_style' => __('Choose between left or right sidebar.', 'thegem'),
        'woocommerce_product_categories_sticky_sidebar' => __('Enable in case you wish to make a sidebar sticky while vertical scrolling.', 'thegem'),
        'woocommerce_product_categories_footer' => __('Footer may include post bottom area (copyright area), footer widget area and custom footer area. Here you can enable or disable footer for product categories.', 'thegem'),
        'woocommerce_product_categories_parallax' => __('Enable or disable footer parallax effect for product categories.', 'thegem'),
        'woocommerce_product_categories_top_margin' => __('Specify the top margin of footer. In this way you can increase/decrease the spacing between main post body area and footer area.', 'thegem'),
        'woocommerce_product_categories_footer_widget_area' => __('Footer widget area is an area below the main body where you can use different sidebar widgets. Here you can enable/disable this area for product categories. ', 'thegem'),
        'woocommerce_product_categories_footer_widget_area_fullwidth' => __('Enable this setting in case your footer widget area should cover 100% width of the viewport.', 'thegem'),
        'woocommerce_product_categories_footer_widget_area_grid_type' => __('Specify number of columns in footer widget area grid.', 'thegem'),
        'woocommerce_product_categories_footer_widget_area_padding' => __('Specify paddings for footer widget area.', 'thegem'),
        'woocommerce_product_categories_bottom_area' => __('Bottom area is also referenced as a copyright area of the website. Here you can enable or disable this area for product categories. ', 'thegem'),
        'woocommerce_product_categories_bottom_area_footer_fullwidth' => __('Enable this setting in case your bottom area should cover 100% width of the viewport.', 'thegem'),
        'woocommerce_product_categories_bottom_area_padding' => __('Specify paddings for bottom area. ', 'thegem'),
        'woocommerce_product_categories_custom_footer' => __('In addition (or instead of) footer widget area and bottom area you can also use some pre-made custom footer for your footer area.', 'thegem'),
        'woocommerce_product_categories_select_custom_footer' => __('Select footer template from the list. ', 'thegem'),
        'woocommerce_product_categories_page_preloader' => __('Preloader appears while page is loading. Here you can enable or disable preloader for product categories. ', 'thegem'),
        'woocommerce_product_categories_lazy_loading' => __('Lazy loading animation happens once certain elements / content appear in viewport while vertical scrolling. This setting enables or disables this kind of animations for product categories. ', 'thegem'),
        'woocommerce_product_categories_layout_breadcrumbs' => __('Enable/disable content breadcrumbs on product archive pages.', 'thegem'),

        'woocommerce_product_gallery' => __('Enable/disable product gallery on product page. By selecting "Legacy TheGem" your product gallery will be set to the old product gallery (used in theme versions prior to 5.0). By selecting "Native WooCommerce" your product gallery will be set to the original WooCommerce product gallery. ', 'thegem'),
        'woocommerce_product_gallery_type' => __('Select layout of product gallery. You can choose between horizontal thumbnails bar, vertical thumbnails bar, dots navigation and single image with arrows navigation. ', 'thegem'),
        'woocommerce_product_gallery_column_position' => __('Select the position of the product gallery in relation to the product description.', 'thegem'),
        'woocommerce_product_gallery_show_image' => __('"Click on thumbnail" means, that the main product image will be shown by clicking on product thumbnail in the thumbnails bar. "Hover on thumbnail" means, that the main product image will be shown by hovering the product thumbnail in the thumbnails bar.', 'thegem'),
        'woocommerce_product_gallery_zoom' => __('Enable/disable zoom magnifier on image hover.', 'thegem'),
        'woocommerce_product_gallery_lightbox' => __('Enable/disable lightbox gallery on image click.', 'thegem'),
        'woocommerce_product_gallery_auto_height' => __('By enabling this option, thumbnails bar will automatically move up and down by navigating through main product images in case this main images have different height and aspect ratio. Disabling this option will place the thumbnails bar on the fixed position. ', 'thegem'),
        'woocommerce_product_gallery_labels' => __('Enable/disable displaying of product labels on main product image.', 'thegem'),
        'woocommerce_product_gallery_colors' => __('Set custom colors for gallery\'s arrows and icons.', 'thegem'),
        'woocommerce_product_gallery_retina_ready' => __('Enable/disable retina-ready product thumbnails in the thumbnails bar of the gallery.', 'thegem'),
        'woocommerce_product_gallery_grid_gaps_hide' => __('Enable this setting in case you wish that your product gallery does not have any top and left/right margins.', 'thegem'),
        'woocommerce_product_gallery_grid_columns' => __('Specify number of grid columns.', 'thegem'),
        'woocommerce_product_gallery_grid_gaps' => __('Specify gaps between grid columns.', 'thegem'),
        'woocommerce_product_gallery_grid_top_margin' => __('Specify description column top margin.', 'thegem'),
        'woocommerce_product_gallery_video_autoplay' => __('Enable/disable video autoplay for product pages with grid gallery and video in grid.', 'thegem'),

        'woocommerce_product_description_reviews_tab_source' => __('<p>Select the content source for the description tab on a product page:</p><p><b>- Product Extra Description:</b> description tab will be populated by content added to "Product Extra Description" text area</p><p><b>- Page Builder:</b> description tab will be populated by content created in page builder</p>', 'thegem'),
        'woocommerce_product_description_reviews_layout' => __('Select layout type for description tab & reviews.', 'thegem'),
        'woocommerce_product_description_reviews_position' => __('Select position for description & reviews accordion.', 'thegem'),
        'woocommerce_product_description_reviews_style' => __('Select style for description & reviews tabs.', 'thegem'),
        'woocommerce_product_description_reviews_alignment' => __('Specify alignment of tab titles.', 'thegem'),
        'woocommerce_product_description_reviews_description' => __('Enable/disable description tab.', 'thegem'),
        'woocommerce_product_description_reviews_additional_info' => __('Enable/disable additional info tab.', 'thegem'),
        'woocommerce_product_description_reviews' => __('Enable/disable reviews tab.', 'thegem'),
        'woocommerce_product_description_reviews_one_by_one_backgrounds' => __('Specify the background colors for the tabs in „One by One“ layout', 'thegem'),

        'woocommerce_product_buttons_add_to_cart' => __('Define text and icon for "add to cart" button.', 'thegem'),
        'woocommerce_product_buttons_add_to_wishlist' => __('Select icon for "add to wishlist" button.', 'thegem'),
        'woocommerce_product_buttons_clear_attributes' => __('Define text for "clear selection" phrase shown after selecting product attributes on product page.', 'thegem'),
        'woocommerce_product_page_button_add_to_cart_icon_show' => __('Enable/disable cart icon for "add to cart" button on product page.', 'thegem'),

        'woocommerce_product_elements_prev_next_product' => __('Enable/disable previous/next product navigation on product page.', 'thegem'),
        'woocommerce_product_elements_product_preview_on_hover' => __('Enable/disable on hover product preview in prev/next product navigation.', 'thegem'),
        'woocommerce_product_elements_back_to_shop' => __('Enable/disable "back to shop" button on product page.', 'thegem'),
        'woocommerce_product_elements_back_to_shop_link' => __('Define the link for "back to shop" button.', 'thegem'),
        'woocommerce_product_elements_product_title' => __('Show/hide product title.', 'thegem'),
        'woocommerce_product_elements_attribute_eg_brand' => __('With this option you can show some product attribute (like "brand") below the product title.', 'thegem'),
        'woocommerce_product_elements_reviews_link' => __('Show/hide link to reviews below the product title.', 'thegem'),
        'woocommerce_product_elements_price' => __('Show/hide price on product page.', 'thegem'),
        'woocommerce_product_elements_strikethrough_price' => __('Show/hide strikethrough price on product page.', 'thegem'),
        'woocommerce_product_elements_product_description' => __('Show/hide short product description.', 'thegem'),
        'woocommerce_product_elements_size_guide_image' => __('Select size guide image to be shown on product page.', 'thegem'),
        'woocommerce_product_elements_sku' => __('Show/hide product SKU on product page.', 'thegem'),
        'woocommerce_product_elements_categories' => __('Show/hide product categories on product page.', 'thegem'),
        'woocommerce_product_elements_tags' => __('Show/hide product tages on product page.', 'thegem'),
        'woocommerce_product_elements_share_icons' => __('Show/hide social sharing buttons on product page.', 'thegem'),
        'woocommerce_product_elements_upsell_products' => __('Show/hide upsell products on product page.<a href="https://docs.woocommerce.com/document/related-products-up-sells-and-cross-sells/">How to add upsell products.</a>', 'thegem'),
        'woocommerce_product_elements_upsell_products_title' => __('Define title for upsell product section.', 'thegem'),
        'woocommerce_product_elements_upsell_number_of_items' => __('Select number of items to be shown in upsell products section. To show all upsells use "-1"', 'thegem'),
        'woocommerce_product_elements_upsell_columns' => __('Define number of columns to be shown in upsell products section.', 'thegem'),
        'woocommerce_product_elements_related_products' => __('Show/hide related products on product page.<a href="https://docs.woocommerce.com/document/related-products-up-sells-and-cross-sells/">What are related products.</a>', 'thegem'),
        'woocommerce_product_elements_related_products_title' => __('Define title for related products section.', 'thegem'),
        'woocommerce_product_elements_related_number_of_items' => __('Select number of items to be shown in related products section. To show all related products use "-1"', 'thegem'),
        'woocommerce_product_elements_related_columns' => __('Define number of columns to be shown in related products section.', 'thegem'),

        'woocommerce_product_grid_title_legacy' => __('With this settings you can specify product title typography for classic grid element and TheGem legacy product grids.', 'thegem'),
        'woocommerce_product_categories_title' => __('Specify typography settings for categories in products grid', 'thegem'),
        'woocommerce_product_grid_category_title' => __('Specify typography settings for category title in categories grid.', 'thegem'),
        'woocommerce_product_grid_category_counts' => __('Specify typography settings for product counts in categories grid.', 'thegem'),
        'woocommerce_product_grid_button_general' => __('Here you can specify border width and border radius for all buttons used in products grid', 'thegem'),
        'woocommerce_product_grid_button_add_to_cart' => __('Specify colors for "add to cart" button in products grid', 'thegem'),
        'woocommerce_product_grid_button_select_options' => __('Specify colors for "select options" button & "view cart" button', 'thegem'),
        'woocommerce_product_grid_icon_style' => __('Here you can specify style settings for all icons used in products grid', 'thegem'),
        'woocommerce_product_labels_font_default' => __('Specify typography and color settings for labels like "sale", "new", "out of stock" used in shop', 'thegem'),
        'woocommerce_product_grid_quick_view_colors' => __('Specify color settings for quick view label in products grid', 'thegem'),

        'woocommerce_product_archive_apply_all_existing' => __('Here you can apply shop grid settings made below on all existing product archive pages.', 'thegem'),
        'woocommerce_product_archive_type' => __('Select layout type for the shop grid.', 'thegem'),
        'woocommerce_product_archive_layout_source' => __('<p>TheGem includes flexible <b>built-in settings</b> for shop grid with many configuration options as well as <b>templates builder</b>, allowing you to create product archive templates with page builder. Here you can specify, which type of layout settings to use globally across your product archives. You can also specify the type of layout settings to use for individual product archive pages in page options of this archives separately.</p>', 'thegem'),
        'woocommerce_product_archive_layout_source_po' => __('<p>TheGem includes flexible <b>built-in settings</b> for shop grid with many configuration options (located in <a href="'.get_site_url().'/wp-admin/admin.php?page=thegem-theme-options#/woocommerce/product-layout-archive" target="_blank">Theme Options -> WooCommerce -> Shop Grid</a>) as well as <b>templates builder</b>, allowing you to create product archive templates with page builder. Here you can specify, which type of layout settings to use for this product archive.</p>', 'thegem'),
        'woocommerce_product_archive_builder_template' => __('<p>Select product archives template. You can create new product archives templates in <a href="'.get_site_url().'/wp-admin/edit.php?post_type=thegem_templates&templates_type=product-archive" target="_blank">Templates Builder -> Product Archives</a></p>', 'thegem'),
        'woocommerce_product_archive_content' => __('<p>Specify the content width of the main shop and category pages.<br/><br/> <b>Boxed:</b> the width of the product grid will be limited to the standard content width.<br/><br/> <b>Full Width:</b> the product grid will use the full width of the page.</p>', 'thegem'),
        'woocommerce_product_archive_layout' => __('Select grid layout for the shop grid.', 'thegem'),
        'woocommerce_product_archive_columns' => __('Specify number of columns for the shop grid on different screens. In case of selecting 100% width for desktop, your shop grid will be automatically stretched to the 100% width of the page, sidebar will be disabled and you will get an additional option “100% Width Columns” to specify the number of columns for 100% width grid for screen resolutions greater than 1920px.', 'thegem'),
        'woocommerce_product_archive_columns_100' => __('Specify number of columns for 100% width grid', 'thegem'),
        'woocommerce_product_archive_size' => __('Specify gaps width between products in the shop grid.', 'thegem'),
        'woocommerce_product_archive_image_aspect_ratio' => __('Specify product image aspect ratio for displaying in the shop grid.', 'thegem'),
        'woocommerce_product_archive_preset' => __('TheGem comes with 26 pre-made product presets for the shop grid to accelerate your work. All this presets are customizable. Here you can choose product preset for displaying in the shop grid.', 'thegem'),
        'woocommerce_product_archive_quick_view' => __('Enable/disable quick view.', 'thegem'),
        'woocommerce_product_archive_quick_view_text' => __('Specify text for Quick View label', 'thegem'),
        'woocommerce_product_archive_sorting' => __('Specify default sorting for products displayed in the shop grid.', 'thegem'),
        'woocommerce_product_archive_show_sorting' => __('Show/hide sorting control in the shop grid.', 'thegem'),
        'woocommerce_product_archive_category_description_position' => __('Choose the position of category description.', 'thegem'),
        'woocommerce_product_archive_show_categories' => __('Show/hide categories in a product in the shop grid.', 'thegem'),
        'woocommerce_product_archive_show_title' => __('Show/hide product title in a product in the shop grid.', 'thegem'),
        'woocommerce_product_archive_show_price' => __('Show/hide product price in a product in the shop grid.', 'thegem'),
        'woocommerce_product_archive_show_reviews' => __('Show/hide reviews in a product in the shop grid.', 'thegem'),
        'woocommerce_product_archive_show_add_to_cart' => __('Enable/disable "add to cart" option in a product in the shop grid.', 'thegem'),
        'woocommerce_product_archive_add_to_cart_type' => __('Select type of "add to cart" option.', 'thegem'),
        'woocommerce_product_archive_cart_button_text' => __('Specify text of "add to cart" button.', 'thegem'),
        'woocommerce_product_archive_select_options_button_text' => __('Specify text of "select options" button.', 'thegem'),
        'woocommerce_product_archive_cart_button_show_icon' => __('Enable/disable icons for "add to cart" and "select options" buttons.', 'thegem'),
        'woocommerce_product_archive_show_wishlist' => __('Enable/disable "add to wishlist" option for the shop grid. Please note: YITH Wishlist plugin should be installed.', 'thegem'),
        'woocommerce_product_archive_items_per_page' => __('Specify number of product items to be displayed on one page in the shop grid.', 'thegem'),
        'woocommerce_product_archive_show_pagination' => __('Enable/disable pagination in the shop grid.', 'thegem'),
        'woocommerce_product_archive_pagination_type' => __('Select pagination type. <br/>- Numbers: classic numbered pagination<br/>- Load More Button: additional items will be loaded by clicking on load more button<br/>- Infinite Scroll: additional items will be automatically loaded while scrolling down', 'thegem'),
        'woocommerce_product_archive_more_button_text' => __('Specify text for "load more" button.', 'thegem'),
        'woocommerce_product_archive_more_icon' => __('Select icon for "load more" button.', 'thegem'),
        'woocommerce_product_archive_more_stretch_full_width' => __('Enable/disable fullwidth stretching for "load more" button.', 'thegem'),
        'woocommerce_product_archive_more_show_separator' => __('Show/hide separator in "load more" button.', 'thegem'),
        'woocommerce_product_archive_gallery_labels' => __('Show/hide labels on products in the shop grid.', 'thegem'),
        'woocommerce_product_archive_categories_sidebar' => __('Enable/disable sidebar for product archive pages with the shop grid.', 'thegem'),
        'woocommerce_product_archive_categories_sidebar_style' => __('Choose between left and right sidebar.', 'thegem'),
        'woocommerce_product_archive_categories_sticky_sidebar' => __('Enable in case you wish to make a sidebar sticky while vertical scrolling.', 'thegem'),
        'woocommerce_product_archive_filters_type' => __('TheGem includes two options for adding filters to the shop grid you can choose from. "TheGem Filters" are in-built ajax product filters, which you can specify below. "WooCommerce Sidebar Widgets" is a product filtering based on standard WooCommerce sidebar widgets "Filter products by...", which you can add to your sidebar under "Appearance -> Widgets". Please note: in order to be able to use "WooCommerce Sidebar Widgets" filter type you should enable sidebar for product archive pages in the section "Sidebar" above.', 'thegem'),
        'woocommerce_product_archive_filters_style' => __('Select filters style for the shop grid.<br/>- Horizontal style (available only in TheGem Filters) will display filter controls as dropdowns above the products grid. <br/>- Sidebar will display filters in a sidebar. <br/>- Hidden sidebar will display a button above the shop grid – by clicking on this button a hidden sidebar with filters will appear. ', 'thegem'),
        'woocommerce_product_archive_filter_buttons_hidden_show_text' => __('Specify text for "Show Filters" control in the shop grid ', 'thegem'),
        'woocommerce_product_archive_filters_ajax' => __('Enable/disable ajax filtering for "WooCommerce Sidebar Widgets" filter type.', 'thegem'),
        'woocommerce_product_archive_scroll_to_top' => __('If enabled, the page will automatically scroll to top after selecting some product filters.', 'thegem'),
        'woocommerce_product_archive_remove_attr_counts' => __('Show/hide product counts in filter by attributes.', 'thegem'),
        'woocommerce_product_archive_filter_by_categories' => __('Enable/disable filter by categories.', 'thegem'),
        'woocommerce_product_archive_filter_by_categories_hierarchy' => __('Show/hide categories hierarchy in categories filter.', 'thegem'),
        'woocommerce_product_archive_filter_by_categories_count' => __('Show/hide product counts in categories filter.', 'thegem'),
        'woocommerce_product_archive_filter_by_categories_title' => __('Specify title for the categories filter.', 'thegem'),
        'woocommerce_product_archive_filter_by_categories_order_by' => __('Specify categories sorting in the categories filter.', 'thegem'),
        'woocommerce_product_archive_filter_by_price' => __('Enable/disable filter by price.', 'thegem'),
        'woocommerce_product_archive_filter_by_price_title' => __('Specify title for the filter by price.', 'thegem'),
        'woocommerce_product_archive_filter_by_attribute' => __('Enable/disable filter by attributes.', 'thegem'),
        'woocommerce_product_archive_filter_by_attribute_data' => __('Select attributes for the filter by attributes. You can add multiple attributes by clicking on "Add item" button.', 'thegem'),
        'woocommerce_product_archive_filter_by_attribute_count' => __('Show/hide product counts in the filter by attributes.', 'thegem'),
        'woocommerce_product_archive_filter_by_attribute_hide_empty' => __('If enabled, empty attributes will be hidden in the filter by attributes.', 'thegem'),
        'woocommerce_product_archive_filter_by_status' => __('Enable/disable filter by product status.', 'thegem'),
        'woocommerce_product_archive_filter_by_status_title' => __('Specify title for the filter by attributes.', 'thegem'),
        'woocommerce_product_archive_filter_by_status_sale' => __('Enable/disable filter by "on sale" products.', 'thegem'),
        'woocommerce_product_archive_filter_by_status_sale_text' => __('Specify text for the filter by "on sale" products.', 'thegem'),
        'woocommerce_product_archive_filter_by_status_stock' => __('Enable/disable filter by "in stock" products.', 'thegem'),
        'woocommerce_product_archive_filter_by_status_stock_text' => __('Specify text for the filter by "in stock" products.', 'thegem'),
        'woocommerce_product_archive_filter_by_status_count' => __('Show/hide product counts in the filter by product status.', 'thegem'),
        'woocommerce_product_archive_filter_by_search' => __('Enable/disable product search in the shop grid.', 'thegem'),
        'woocommerce_product_archive_filters_text_labels_all_text' => __('Specify text for "show all" option in the shop grid.', 'thegem'),
        'woocommerce_product_archive_filters_text_labels_clear_text' => __('Specify text for "Clear Filters" button in the shop grid.', 'thegem'),
        'woocommerce_product_archive_filters_text_labels_search_text' => __('Specify placeholder text for product search input.', 'thegem'),
        'woocommerce_product_archive_filter_buttons_sidebar_hidden_show_text' => __('Specify text for the "Show Filters" control in hidden sidebar and responsive filter style.', 'thegem'),
        'woocommerce_product_archive_filter_buttons_hidden_sidebar_title' => __('Specify title for hidden sidebar filter style.', 'thegem'),
        'woocommerce_product_archive_filter_buttons_hidden_filter_by_text' => __('Specify text for "Filter By" placeholder in filter titles.', 'thegem'),
        'woocommerce_product_archive_stay_visible' => __('Specify amount of time for notification bar to stay visible after user action. Notification bar appears if user adds sme product to cart or to wishlist or remove some product from wishlist', 'thegem'),
        'woocommerce_product_archive_added_cart_text' => __('Specify text to appear in the notification bar after some product has been added to cart.', 'thegem'),
        'woocommerce_product_archive_added_wishlist_text' => __('Specify text to appear in the notification bar after some product has been added to wishlist.', 'thegem'),
        'woocommerce_product_archive_removed_wishlist_text' => __('Specify text to appear in the notification bar after some product has been removed from wishlist.', 'thegem'),
        'woocommerce_product_archive_view_cart_button_text' => __('Specify "view cart" button text in the notification bar, which appears if some product has been added to cart.', 'thegem'),
        'woocommerce_product_archive_checkout_button_text' => __('Specify "checkout" button text in the notification bar, which appears if some product has been added to cart.', 'thegem'),
        'woocommerce_product_archive_view_wishlist_button_text' => __('Specify "view wishlist" button text in the notification bar, which appears if some product has been added to wishlist.', 'thegem'),
        'woocommerce_product_archive_not_found_text' => __('Specify text for the case if no products have been found after the filter selection / search.', 'thegem'),
        'woocommerce_product_archive_loading_animation' => __('Enable/disable lazy loading animation for products in the shop grid. ', 'thegem'),
        'woocommerce_product_archive_animation_effect' => __('Select animation effect.', 'thegem'),
        'woocommerce_product_archive_ignore_highlights' => __('In TheGem you can specify some products to be emphasized in the shop grid - they will be displayed double bigger as other products. You can make it by enabling the option "Highlighted Product" in page options of the product. This is a cool way of attracting visitors attention to some product highlights and to make creative grids. By activating “Ignore Highlighted Products” control here products emphasizing will be ignored and all highlighted products will be displayed as normal products. ', 'thegem'),
        'woocommerce_product_archive_skeleton_loader' => __('Enable/disable skeleton preloader for grid loading', 'thegem'),
        'woocommerce_product_archive_featured_only' => __('By enabling this control only featured products will be displayed in the shop grid. All other products will be ignored. You can set a product as “featured” product in product settings.', 'thegem'),
        'woocommerce_product_archive_sale_only' => __('By enabling this control only “on sale” products will be displayed. All other products in the shop grid will be ignored.', 'thegem'),
        'woocommerce_product_archive_social_sharing' => __('Enable/disable social sharing buttons in shop grid.', 'thegem'),
        'woocommerce_product_archive_customize_styles' => __('In this section you can customize the appearance of product items in the shop grid.', 'thegem'),
        'woocommerce_product_archive_image_hover_effect' => __('Select hover effect for product images while hovering on product in grid. "Show next image" hover works only in case you have added more than one image for your product.', 'thegem'),
        'woocommerce_product_archive_image_hover_effect_fallback' => __('In case some product has only one product image, here you can specify which hover effect should be applied in this case.', 'thegem'),
        'woocommerce_product_archive_caption_container_preset' => __('Here you can select between different color presets for caption container. ', 'thegem'),
        'woocommerce_product_archive_caption_container_alignment' => __('Specify caption alignment.', 'thegem'),
        'woocommerce_product_archive_caption_container_background_color' => __('Specify background color for caption container.', 'thegem'),
        'woocommerce_product_archive_caption_container_separator' => __('Enable/disable separator in caption container.', 'thegem'),
        'woocommerce_product_archive_caption_container_separator_width' => __('Specify separator width.', 'thegem'),
        'woocommerce_product_archive_caption_container_separator_color' => __('Specify separator color.', 'thegem'),

        'woocommerce_cart_checkout_select_cart_layout' => __('Select between modern and classic cart layouts.', 'thegem'),
        'woocommerce_cart_checkout_cart_checkout_steps' => __('Enable/disable displaying of checkout steps in cart & checkout.', 'thegem'),
        'woocommerce_cart_checkout_steps_position' => __('Select the position where to display checkout steps.', 'thegem'),
        'woocommerce_cart_checkout_empty_cart_text' => __('Define the text to be displayd in case cart is empty.', 'thegem'),
        'woocommerce_cart_checkout_empty_cart_title' => __('Define title to be displayed in case cart is empty.', 'thegem'),
        'woocommerce_cart_checkout_cross_sell_products' => __('Hide/show cross-sell products in the cart.<a href="https://docs.woocommerce.com/document/related-products-up-sells-and-cross-sells/">How to add upsell products.</a>', 'thegem'),
        'woocommerce_cart_checkout_cross_sells_title' => __('Define title for cross-sell products in the cart.', 'thegem'),
        'woocommerce_cart_checkout_number_of_cross_sells' => __('Specify number of cross-sell products to be displayed in the cart.', 'thegem'),
        'woocommerce_cart_checkout_cross_sells_columns' => __('Define number of columns to be shown in cross-sell products section.', 'thegem'),
        'woocommerce_cart_checkout_extra_content' => __('Here you can add some extra content to the "Thank you" page after the order has been completed.', 'thegem'),
        'woocommerce_cart_checkout_default_content' => __('Disable in case you have added some extra content and don\'t want to show the default "thank you page" content.', 'thegem'),
        'woocommerce_cart_checkout_select_checkout_layout' => __('Select between multi-step and one-page checkout layout.', 'thegem'),
        'woocommerce_cart_checkout_cart_icon' => __('Enable or disable cart icon.', 'thegem'),
        'woocommerce_cart_checkout_position_in_hamburger' => __('Select cart position in hamburger menu types. You can position cart icon in header near hamburger icon or inside the menu.', 'thegem'),
        'woocommerce_cart_checkout_amount_label' => __('Specify what kind of amount should be shown in amount label. Choose between product positions amount or total product amount in cart.', 'thegem'),
        'woocommerce_cart_checkout_amount_label_color' => __('Specify background color for amount label.', 'thegem'),
        'woocommerce_cart_checkout_checkout_table' => __('Specify colors for cart & checkout table.', 'thegem'),
        'woocommerce_cart_checkout_checkout_forms' => __('Specify colors for labels in cart & checkout forms.', 'thegem'),
        'woocommerce_cart_checkout_checkout_steps' => __('Specify colors for checkout steps.', 'thegem'),
        'woocommerce_cart_checkout_wishlist_icon' => __('Enable or disable wishlist icon in default menu header.', 'thegem'),

        'performance_page_speed_image_loading_optimizations' => __('If enabled, all images on a webpage will start loading only by nearing the desktop device viewport. In this way, by loading your webpage, all images below the fold (which are not immediately displayed for user) are physically not loaded. And only by scrolling down the page, as soon as this images appear in above the fold area they are being loaded and displayed.', 'thegem'),
        'performance_page_speed_distance_to_viewport' => __("The distance to a device's viewport in pixel, when images should start loading (i.e. buffer zone).  In order to avoid any unpleasent loading interruptions, there is a special “buffer” zone below the fold, which enables the image loading some pixels before this images appear in above the fold area.", 'thegem'),
        'performance_page_speed_any_caching_plugins_in_use' => __('Enable in case your website uses any of caching plugins like WP Super Cache, W3 Total Cache etc.', 'thegem'),
        'performance_page_speed_font_preload' => __('In some cases Google Pagespeed recommends to use `<link rel=preload>` to prioritize fetching self-hosted fonts that are currently requested later in page load. Preloading such requests can make your pages load faster. If the pagespeed testing of your pages shows such recommendation (check screenshot), enable "Font Preload" option and then the preload of the fonts recommended in pagespeed results.', 'thegem'),
        'performance_page_speed_rocket_autoptimize' => __('Enable caching & minifying on your website by installing & activating WP Rocket & Autoptimize plugin. Optimal settings for both plugins will be applied automatically by default. If needed (but not recommended) you can then change the plugins settings manually in each plugin separately. Both plugins come bundled with TheGem theme. For more details check our documentation. ', 'thegem'),
        'performance_animation_lazy_loading_animations' => __('Enable animations on mobiles. For better performance results on mobiles it is recommended to keep lazy loading animations for mobiles disabled.', 'thegem'),

        'contacts_and_socials_socials_popular_social_networks' => __('Select social networks where you are presented and specify links to your social profiles. This can be optionally shown in top area, footer, sidebars and content elements.', 'thegem'),
        'contacts_and_socials_socials_icon_colors' => __('Specify colors for social icons.', 'thegem'),
        'contacts_and_socials_socials_add_new_social_network' => __('Enable in order to add new social network.', 'thegem'),
        'contacts_and_socials_contacts_top_area' => __('Specify your contact details. This contacts can be displayed in top area of your website (if enabled).', 'thegem'),
        'contacts_and_socials_contacts_widget' => __('Specify your contact details for "Contacts" widget. This widget can be added to page content, footer widget area and sidebars.', 'thegem'),

        'custom_css_and_js_custom_css' => __("Type your custom css here, which you would like to add to theme's css (or overwrite it)", 'thegem'),
        'custom_css_and_js_custom_js_in_website_header' => __("Type your custom javascript here, which you would like to add to theme's js in website header.", 'thegem'),
        'custom_css_and_js_custom_js_in_website_footer' => __("Type your custom javascript here, which you would like to add to theme's js in website footer.", 'thegem'),
        'custom_css_and_js_tracking_code' => __('Insert Google Analytics, Google Tag Manager, Facebook Pixel etc.', 'thegem'),

        'extras_regenerate_css' => __('Styles set in TheGem Theme Options are saved in CSS file. Here you can recreate this CSS file according to the most recent settings set in Theme Options.', 'thegem'),
        'extras_graph_tags' => __('TheGem provides open graph tags in posts/pages automatically, which include title, description, image. In case you wish to use open graph tags from third-party SEO plugins, it is recommended to disable TheGem\'s open graph tags.', 'thegem'),
        'extras_thumbnails_cache' => __('In case you will delete any image thumbnails (portfolio grids, products, galleries etc.) from your hosting, you need to click this button to clear the thumbnails cache in the database in order to be able to regenerate new thumbnails.', 'thegem'),
        'extras_news_post_type' => __('<p>Additional <b>(DEPRECATED)</b> custom post type, similar to blog posts. This post type can be used to manage news on the website separately to your blog and blog posts.</p>', 'thegem'),
        'extras_nivoslider' => __('<p>Additional <b>(DEPRECATED)</b> simple slider, which can be used to insert slideshows into your pages.</p>', 'thegem'),
        'extras_version_rollback' => __('Experiencing some issues with the current TheGem version? Here you can rollback to a previous theme version', 'thegem'),

        'backup_and_import_backup_theme_options' => __('If you would like to experiment with the settings of your theme and don\'t want to loose your previous settings, use the "Backup Settings" - button to backup your current theme options. You can restore these options later using the button "Restore Settings".', 'thegem'),
        'backup_and_import_export_theme_options' => __('In order to apply the theme options settings of this TheGem installation on a different website running TheGem just copy  the settings in the text box. Alternatively you can download a file with the settings, which then can be uploaded on the different differnet website running TheGem.', 'thegem'),
        'backup_and_import_import_theme_options' => __('In order to apply the settings of another TheGem installation used on a different website just copy and paste the settings in the text box and click on "Apply". Alternatively you can import this settings from file you have downloaded on a different TheGem installation.', 'thegem'),

        'reset_all_reset_theme_options' => __('Here you can reset all theme options settings to the default state (reset factory settings). Note: all your current settings will be overwritten.', 'thegem'),

        'p_options_header_general_header' => __('Header includes menu area and top area. Here you can enable or disable header for this page/post. Select "Default Setting" to inherit this setting from theme options.', 'thegem'),
        'p_options_header_source' => __('<p>TheGem includes flexible <b>built-in header</b> with many configuration options as well as <b>header builder</b>, allowing you to create header templates with page builder. Here you can specify, which type of header to use. </p>', 'thegem'),
        'p_options_header_menu' => __('Here you can enable or disable menu for this post/page. Select "Default Setting" to inherit this setting from theme options.', 'thegem'),
        'p_options_header_menu_options' => __('<p>Use "Default Settings" to inherit menu options from theme options. Select "Custom Settings" to customize menu options individually for this page/post.</p><p><b>Menu Transparency:</b> if enabled, menu & header will be put upon your hero / slider / title area with transparent background. You can then control the transparency level using "Opacity" setting.</p><p><b>Use Light Menu & Logo:</b> in case your website has a dark header area, it is recommended to enable this option to show light menu & logo instead of defaults.</p><p><b>Search Icon:</b> show/hide search icon in menu.</p>', 'thegem'),
        'p_options_header_menu_select_menu' => __('You can use a different menu on this page/post by selecting it here.', 'thegem'),
        'p_options_header_top_area_top_area' => __('Enable/disable top area for your post/page. Select "Default Setting" to inherit this setting from theme options.', 'thegem'),
        'p_options_header_top_area_top_area_options' => __('<p>"Use ""Default Settings"" to inherit top area options from theme options. Select ""Custom Settings"" to customize top area options individually for this page/post.</p><p><b>Top Area Transparency:</b> If enabled, top area will be put upon your hero / slider / title area with transparent background. You can then control the transparency level using ""Opacity"" setting.</p>', 'thegem'),

        'p_options_title_area_general_title_area' => __('Title area includes title, excerpt and breadcrumbs. Here you can enable or disable title area for this post/page. Select "Default Setting" to inherit this setting from theme options.', 'thegem'),
        'p_options_title_area_general_title_area_product' => __('Title area includes title, excerpt and breadcrumbs. Here you can enable or disable title area for this post/page. If disabled, you can additionally enable/disable menu & header separator. Select "Default Setting" to inherit this setting from theme options.', 'thegem'),
        'p_options_title_area_general_type_title_area' => __('<p><b>Regular Title:</b> you can setup the layout & style of title area using the settings below.</p><p><b>Title Template:</b> you can select to use title area template created in Templates Builder.</p>', 'thegem'),
        'p_options_title_area_general_breadcrumbs' => __('Enable or disable breadcrumbs for this post/page.', 'thegem'),
        'p_options_title_area_general_settings' => __('If enabled, you can make page/post own individual style and backgrounds settings below, which then can be embeded in custom titles dynamically.', 'thegem'),
        'p_options_title_area_title_excerpt_use_rich_content' => __('Enable this option in case you wish to replace regular page/post title with title created in visual editor. Here you can use different title format presets as well as html formatting.', 'thegem'),
        'p_options_title_area_title_excerpt_excerpt' => __('Excerpt is a post/page description (or subtitle). Here you can enter the excerpt for your post/page.', 'thegem'),
        'p_options_title_area_style_alignment_content_alignment' => __('Specify the alignment of content elements (title, excerpt etc) inside title area.', 'thegem'),
        'p_options_title_area_style_alignment_paddings' => __('Specify the title area paddings.', 'thegem'),
        'p_options_title_area_style_alignment_title_top_margin' => __('Specify top margin for post/page title. In this way you can control spacing between title and icon or title and top of the title area.', 'thegem'),
        'p_options_title_area_style_alignment_title_max_width' => __('Max. width means how wide should be the row with title text.', 'thegem'),
        'p_options_title_area_style_alignment_excerpt_top_margin' => __('Set up top margin for post/page excerpt. In this way you can control spacing between excerpt and title.', 'thegem'),
        'p_options_title_area_style_alignment_excerpt_max_width' => __('Max. width means how wide should be the row with excerpt text.', 'thegem'),
        'p_options_title_area_style_alignment_xlarge_title' => __('Extra large size preset for a post/page title.', 'thegem'),
        'p_options_title_area_style_alignment_title_color' => __('Font color of a post/page title.', 'thegem'),
        'p_options_title_area_style_alignment_excerpt_color' => __('Font color of a post/page excerpt.', 'thegem'),
        'p_options_title_area_background_type' => __('Specify the background type and select the background for title area.', 'thegem'),
        'p_options_title_area_background_parallax' => __('Enable or disable parallax effect for title area.', 'thegem'),
        'p_options_title_area_icon' => __('Here you can select icon to be displayed in title area.', 'thegem'),
        'p_options_title_area_icon_color_split' => __('You can use dual color split effect in the selected icon.', 'thegem'),
        'p_options_title_area_icon_colors' => __('Specify icon colors.', 'thegem'),
        'p_options_title_area_icon_shape' => __('Here you can select different shapes for your icon.', 'thegem'),
        'p_options_title_area_icon_size' => __('Specify icon size.', 'thegem'),

        'p_options_sidebar_content_area_options' => __('<p><b>Default Settings:</b> inherit content area settings from theme options.</p><p><b>Custom Settings:</b> make individual content area settings for this page/post.</p>', 'thegem'),
        'p_options_sidebar_content_background_type' => __('Specify the background type and select the background for main content area.', 'thegem'),
        'p_options_sidebar_content_top_padding' => __('Specify top padding for main content area. It is a spacing between header and main content. If title area is enabled, it is a spacing between title area and main content.', 'thegem'),
        'p_options_sidebar_content_bottom_padding' => __('Specify bottom padding for main content area. It is a spacing between main content and footer area.', 'thegem'),
        'p_options_sidebar_page_sidebar' => __('Enable or disable post/page sidebar. Select "Default Setting" to inherit this setting from theme options.', 'thegem'),
        'p_options_sidebar_page_sidebar_style' => __('Specify the sidebar position.', 'thegem'),
        'p_options_sidebar_page_sticky_sidebar' => __('Here you can set the sidebar to be sticky while vertical scrolling.', 'thegem'),

        'p_options_footer_general_footer' => __('Footer may include post/page bottom area (copyright area), footer widget area and custom footer area. Here you can enable or disable footer for this post/page. Select "Default Setting" to inherit this setting from theme options.', 'thegem'),
        'p_options_footer_general_parallax' => __('Enable or disable parallax effect for post/page footer.', 'thegem'),
        'p_options_footer_widget_area' => __('Footer widget area is an area below the main body where you can use different sidebar widgets. Select "Default Setting" to inherit this setting from theme options.', 'thegem'),
        'p_options_footer_bottom_area' => __('Bottom area is also referenced as a copyright area of the website. Here you can enable or disable this area for this post/page. Select "Default Setting" to inherit this setting from theme options.', 'thegem'),
        'p_options_footer_custom_footer' => __('In addition (or instead of) footer widget area and bottom area you can also use footer template created in Templates Builder. Select "Default Setting" to inherit this setting from theme options.', 'thegem'),
        'p_options_footer_select_custom_footer' => __('Select footer template from the list. ', 'thegem'),

        'p_options_page_as_onepager_1' => __('If enabled, your page can be set as onepager. Check details in this video tutorial ', 'thegem'),
        'p_options_page_as_onepager_2' => __('https://youtu.be/YUut8yA7rk8 ', 'thegem'),
        'p_options_page_as_onepager_3' => __('and in documentation here ', 'thegem'),
        'p_options_page_as_onepager_4' => __('https://codex-themes.com/thegem/documentation/#one-page-website.', 'thegem'),
        'p_options_page_as_fullpage_scroller_1' => __('If enabled, your page can be set as fullpage vertical scroller. Check details in this video tutorial ', 'thegem'),
        'p_options_page_as_fullpage_scroller_2' => __('https://youtu.be/crxf1GCUuhs ', 'thegem'),
        'p_options_page_as_fullpage_scroller_3' => __('and in documentation here ', 'thegem'),
        'p_options_page_as_fullpage_scroller_4' => __('https://codex-themes.com/thegem/documentation/#vertical-slider.', 'thegem'),

        'p_options_extras_page_preloader' => __('Preloader appears while page is loading. Here you can enable or disable page preloader for your post/page. Select "Default Setting" to inherit this setting from theme options.', 'thegem'),
        'p_options_extras_lazy_loading' => __('Lazy loading animation happens once certain post/page  elements/content appear in viewport while vertical scrolling. This setting enables or disables this kind of animations for this page/post.', 'thegem'),
        'p_options_extras_redirect_to_subpage' => __('If enabled, this post/page will be used as automatic redirect to the first subpage. It can be useful option for menu / navigation.', 'thegem'),

        'p_options_post_format' => __('<p>Select post format. Post formats help to define visual representation of a post. Depending on the chosen format post will get corresponding featured content format, which can be optionally displayed on the top of a post as well as in blog lists/grids.</p><p><b>Standard</b> - The default post format.</p><p><b>Image</b> - An image, set in "Featured Image".</p><p><b>Video</b> - A post containing video.</p><p><b>Audio</b> - An audio file.</p><p><b>Quote</b> - A quotation.</p><p><b>Gallery</b> - A gallery of images.</p>', 'thegem'),
        'p_options_post_featured_post' => __('TheGem elements include an element "Featured posts slider" for displaying selected posts as a slider. Enable this setting in case you wish to activate this post to be used in featured posts slider.', 'thegem'),
        'p_options_post_featured_content' => __('Show or hide featured content inside the post. Select "Default Setting" to inherit this setting from theme options.', 'thegem'),
        'p_options_post_post_elements' => __('Show or hide different post elements. Select "Default Setting" to inherit this setting from theme options. Select "Custom Settings" to customize individually for this post.', 'thegem'),
        'p_options_post_highlighted_post' => __('TheGem elements include extended blog grid for displaying blog posts. Activate this setting in case you wish to highlight this post in extended blog grid.', 'thegem'),
        'p_options_post_highlight_type' => __('Highlighted post takes a double size of a normal post in a grid. Here you can select the type of such double sized post in a grid.', 'thegem'),
        'p_options_post_highlight_style' => __('This setting works only if the caption position in extended blog grid is set to be on image. By default highlighted post is presented as double sized post in extended grid. By selecting "Alternative" style  your highlighted post will get an additional fancy look. ', 'thegem'),
        'p_options_post_highlight_alternative_colors' => __('Specify the background and text colors for post captions in alternative highlight style.', 'thegem'),
        'p_options_product_highlighted' => __('TheGem elements include product grid for displaying products on page. Activate this setting in case you wish to highlight this product in product grid.', 'thegem'),
        'p_options_product_highlight_type' => __('Highlighted product takes a double size of a normal product in a grid. Here you can select the type of such double sized product in a grid.', 'thegem'),
        'p_options_product_hover_with_alternative_product' => __('Here you can enable or disable mouseover effect for product catalog which shows next product image, specified in product gallery', 'thegem'),
        'p_options_product_size_guide_image' => __('Specify size guide for this product page. By default the size guide set in theme options is used. You can set a different size guide images by choosing "Custom Size Guide" or disable it.', 'thegem'),
        'p_options_product_layout_settings' => __('<p><b>Default Settings:</b> inherit product layout settings from theme options.<br/><b>Custom Settings:</b> make individual product layout settings for this product.</p>', 'thegem'),

        'p_options_portfolio_item_fullwidth_layout' => __('If enabled, portfolio page will get 100% width layout.', 'thegem'),
        'p_options_portfolio_item_page_elements' => __('Show or hide different portfolio page elements. Select "Default Setting" to inherit this setting from theme options. Select "Custom Settings" to customize individually for this portfolio page.', 'thegem'),
        'p_options_portfolio_item_back_to_overview' => __('Specify the URL of the page with portfolio list / portfolio grid for the "back to overview" icon on portfolio page.', 'thegem'),
        'p_options_portfolio_item_hover_options' => __('<p>Portfolio item can have different hover icons when displaying in portfolio list/grid. Clicking on this icons leads to different actions. Here you can specify, which hover icons with which settings should be activated. You can add multiple icons by clicking on "+".</p><p><b>Portfolio Page</b> - link to this portfolio page.</p><p><b>Internal Link</b> - link to any other page of your website.</p><p><b>External Link</b> - link to any other external page.</p><p><b>Lightbox Image</b> - featured image will be shown in a lightbox.</p><p><b>YouTube Video</b> - YouTube video will open in a lightbox.</p><p><b>Vimeo Video</b> - Vimeo video will open in a lightbox.</p><p><b>Self-Hosted Video</b> - self-hosted video will open in a lightbox.</p>', 'thegem'),
        'p_options_portfolio_item_link_target' => __('Specify link to another page or video ID (for YouTube or Vimeo).', 'thegem'),
        'p_options_portfolio_item_show_as_highlight' => __('Activate this setting in case you wish to highlight this portfolio item in portfolio grid.', 'thegem'),
        'p_options_portfolio_item_highlight_type' => __('Highlighted portfolio item takes a double size of a normal item in a grid. Here you can select the type of such double sized item in a grid. ', 'thegem'),
        'p_options_portfolio_item_alternative_title' => __('Alternative title of portfolio item to show in portfolio list / grid. This could be useful if your portfolio item has a very long title, which doesn’t suit in to the item box in portolio list / grid.', 'thegem'),
        'p_options_portfolio_item_preview_button' => __('Activate in case you wish to add "project preview" button on your portfolio page.', 'thegem'),
        'p_options_portfolio_item_preview_button_text' => __('Specify text for project preview button.', 'thegem'),
        'p_options_portfolio_item_preview_button_link' => __('Specify link for project preview button.', 'thegem'),
    ),
    'general' => array(
        'yes' => __('Yes', 'thegem'),
        'no' => __('No', 'thegem'),
        'or' => __('or', 'thegem'),
        'connected' => __('Connected', 'thegem'),
        'not_connected' => __('Not Connected', 'thegem'),
        'registered' => __('Registered', 'thegem'),
        'not_registered' => __('Not Registered', 'thegem'),
        'installed' => __('Installed', 'thegem'),
        'not_installed' => __('Not Installed', 'thegem'),
        'version' => __('Version', 'thegem'),
        'announcement' => __('Announcement', 'thegem'),
        'bug_fixes' => __('Bug fixes', 'thegem'),
        'updates' => __('Updates', 'thegem'),
        'new_features' => __('New features', 'thegem'),
        'saved_changes' => __('All Your Changes Are Successfully Saved', 'thegem'),
        'choose_image' => __('Choose Image', 'thegem'),
        'choose_preloader' => __('Choose Preloader', 'thegem'),
        'choose_favicon' => __('Choose Favicon', 'thegem'),
        'selected' => __('Selected', 'thegem'),
        'enabled' => __('Enabled', 'thegem'),
        'disabled' => __('Disabled', 'thegem'),
        'select_image_popup_title' => __('Select Image', 'thegem'),
        'select_image_popup_button' => __('Use Image', 'thegem'),
        'save_layout' => __('Save layout', 'thegem'),
        'style' => __('Style', 'thegem'),
        'custom_style' => __('Custom Style', 'thegem'),
        'color' => __('Color', 'thegem'),
        'gradient' => __('Gradient', 'thegem'),
        'image' => __('Image', 'thegem'),
        'pattern' => __('Pattern', 'thegem'),
        'fullwidth' => __('Fullwidth', 'thegem'),
        'boxed' => __('Boxed', 'thegem'),
        'frame' => __('Frame', 'thegem'),
        'body_Frame' => __('Body Frame', 'thegem'),
        'default' => __('Default', 'thegem'),
        'default_settings' => __('Default Settings', 'thegem'),
        'default_menu' => __('Default Menu', 'thegem'),
        'alternative' => __('Alternative', 'thegem'),
        'gif' => __('GIF', 'thegem'),
        'svg' => __('SVG', 'thegem'),
        'css' => __('CSS', 'thegem'),
        'width' => __('Width', 'thegem'),
        'height' => __('Height', 'thegem'),
        'preview' => __('Preview', 'thegem'),
        'video' => __('Video', 'thegem'),
        'left' => __('Left', 'thegem'),
        'right' => __('Right', 'thegem'),
        'justify' => __('Justify', 'thegem'),
        'vertical' => __('Vertical', 'thegem'),
        'center' => __('Center', 'thegem'),
        'top' => __('Top', 'thegem'),
        'bottom' => __('Bottom', 'thegem'),
        'split_vertical' => __('Split Vertical', 'thegem'),
        'split' => __('Split', 'thegem'),
        'default_title' => __('Regular Title', 'thegem'),
        'custom_title' => __('Title Template', 'thegem'),
        'select' => __('Select', 'thegem'),
        'select_video' => __('Select Video', 'thegem'),
        'select_audio' => __('Select Audio', 'thegem'),
        'use_video' => __('Use Video', 'thegem'),
        'use_audio' => __('Use Audio', 'thegem'),
        'flat' => __('Flat', 'thegem'),
        'outline' => __('Outline', 'thegem'),
        'tiny' => __('Tiny', 'thegem'),
        'thin' => __('Thin', 'thegem'),
        'small' => __('Small', 'thegem'),
        'medium' => __('Medium', 'thegem'),
        'large' => __('Large', 'thegem'),
        'x_large' => __('XLarge', 'thegem'),
        'giant' => __('Giant', 'thegem'),
        'normal' => __('Normal', 'thegem'),
        'deprecated' => __('Deprecated', 'thegem'),
        'background' => __('Background', 'thegem'),
        'show' => __('Show', 'thegem'),
        'hide' => __('Hide', 'thegem'),
        'slider_revo' => __('Revolution Slider', 'thegem'),
        'slider_nivo' => __('Nivo Slider', 'thegem'),
        'slider_layer' => __('Layer Slider', 'thegem'),
        'portfolio_page' => __('Portfolio Page', 'thegem'),
        'internal_link' => __('Internal Link', 'thegem'),
        'external_link' => __('External Link', 'thegem'),
        'fullsize_image' => __('Full-Size Image', 'thegem'),
        'lightbox_image' => __('Lightbox Image', 'thegem'),
        'youtube' => __('YouTube Video', 'thegem'),
        'vimeo' => __('Vimeo Video', 'thegem'),
        'selfhosted' => __('Self-Hosted Video', 'thegem'),
        'squared' => __('Squared', 'thegem'),
        'horizontal' => __('Horizontal', 'thegem'),
        'desktop' => __('Desktop', 'thegem'),
        'tablet' => __('Tablet', 'thegem'),
        'mobile' => __('Mobile', 'thegem'),
        'slider' => __('Slider', 'thegem'),
        'circle' => __('Circle', 'thegem'),
        'self' => __('Self', 'thegem'),
        'blank' => __('Blank', 'thegem'),
        'square' => __('Square', 'thegem'),
        'rhombus' => __('Rhombus', 'thegem'),
        'hexagon' => __('Hexagon', 'thegem'),
        'audio' => __('Audio', 'thegem'),
        'quote' => __('Quote', 'thegem'),
        'gallery' => __('Gallery', 'thegem'),
        'standard' => __('Standard', 'thegem'),
        'none' => __('None', 'thegem'),
        'basic' => __('Basic', 'thegem'),
        'advanced' => __('Advanced', 'thegem'),
        'outline_dt' => __('Outline dots', 'thegem'),
        'solid_dt' => __('Solid dots', 'thegem'),
        'solid_small_dt' => __('Solid dots (small)', 'thegem'),
        'lines_dt' => __('Lines', 'thegem'),
        'outlined_active_dt' => __('Outlined active dots', 'thegem'),
        'screenshot' => __('Screenshot', 'thegem'),
        'parallax' => __('Parallax', 'thegem'),
        'kenburns' => __('Ken Burns', 'thegem'),
        'fixed_background' => __('Fixed Background', 'thegem'),
        'custom_settings' => __('Custom Settings', 'thegem'),
        'zoom_in' => __('Zoom In', 'thegem'),
        'zoom_out' => __('Zoom Out', 'thegem'),
        'same_as_page_preloader' => __('Same as page preloader', 'thegem'),
        'select_style_preloader' => __('Select style', 'thegem'),
        'learn_more' => __('Learn more', 'thegem'),
        'caption_below' => __('Caption Below', 'thegem'),
        'caption_on_image' => __('Caption on Image', 'thegem'),
        'caption_on_hover' => __('Caption on Hover', 'thegem'),
        'border_width' => __('Border Width', 'thegem'),
        'border_radius' => __('Border Radius', 'thegem'),
        'on' => __('On', 'thegem'),
        'off' => __('Off', 'thegem'),
        'target_self' => __('Self', 'thegem'),
        'target_blank' => __('Blank', 'thegem'),
    ),
    'topPanel' => array(
        'title' => __('Theme Options', 'thegem'),
        'search' => __('Search for Option...', 'thegem'),
        'preset' => __('Select Saved Preset', 'thegem'),
    ),
    'menu' => array(
        'general' => __('General', 'thegem'),
        'header' => __('Header', 'thegem'),
        'general_theme-layout' => __('Theme Layout', 'thegem'),
        'general_logo-and-identity' => __('Logo & Identity', 'thegem'),
        'menu-and-header' => __('Menu & Header', 'thegem'),
        'menu-and-header_layout' => __('Layout', 'thegem'),
        'menu-and-header_typography' => __('Typography', 'thegem'),
        'menu-and-header_colors' => __('Colors', 'thegem'),
        'title-area' => __('Title Area', 'thegem'),
        'footer' => __('Footer', 'thegem'),
        'footer_layout' => __('Layout', 'thegem'),
        'footer_colors' => __('Colors', 'thegem'),
        'single-pages' => __('Single Pages', 'thegem'),
        'single-pages_post' => __('Post', 'thegem'),
        'single-pages_page' => __('Page', 'thegem'),
        'single-pages_portfolio' => __('Portfolio Page', 'thegem'),
        'single-pages_coming-soon-and-404' => __('404 Page', 'thegem'),
        'single-pages_product-page' => __('Product Page', 'thegem'),
        'archive-pages' => __('Archive Pages', 'thegem'),
        'archive-pages_blog' => __('Blog', 'thegem'),
        'archive-pages_shop' => __('Shop', 'thegem'),
        'archive-pages_search' => __('Search', 'thegem'),
        'archive-pages_product-categories' => __('Product Categories', 'thegem'),
        'posttypes' => __('TheGem Posttypes', 'thegem'),
        'posttypes_quickfinders' => __('Quickfinders', 'thegem'),
        'posttypes_galleries' => __('Galleries', 'thegem'),
        'posttypes_portfolio-grids' => __('Portfolio Grids', 'thegem'),
        'posttypes_testimonials' => __('Testimonials', 'thegem'),
        'builder-elements' => __('Builder Elements', 'thegem'),
        'colors' => __('Colors', 'thegem'),
        'colors_elements' => __('Elements', 'thegem'),
        'colors_icons' => __('Icons', 'thegem'),
        'colors_pagination' => __('Pagination', 'thegem'),
        'colors_forms' => __('Forms', 'thegem'),
        'colors_hovers' => __('Hovers', 'thegem'),
        'typography' => __('Typography', 'thegem'),
        'typography_headings-and-body' => __('Headings & Body', 'thegem'),
        'typography_elements' => __('Elements', 'thegem'),
        'typography_self-hosted-fonts' => __('Self Hosted Fonts', 'thegem'),
        'woocommerce' => __('WooCommerce', 'thegem'),
        'woocommerce_general' => __('General', 'thegem'),
        'woocommerce_product' => __('Product', 'thegem'),
        'woocommerce_product-styles' => __('Elements Styles', 'thegem'),
        'woocommerce_product-page' => __('Product Page', 'thegem'),
        'woocommerce_product-layout' => __('Product', 'thegem'),
        'woocommerce_product-gallery' => __('Product Gallery', 'thegem'),
        'woocommerce_product-layout-archive' => __('Shop Grid', 'thegem'),
        'woocommerce_product-categories' => __('Product Categories', 'thegem'),
        'woocommerce_cart-and-checkout' => __('Cart & Checkout', 'thegem'),
        'woocommerce_extra-options' => __('Extra Options', 'thegem'),
        'seo' => __('Seo', 'thegem'),
        'performance' => __('Performance', 'thegem'),
        'performance_page-speed' => __('PageSpeed', 'thegem'),
        'performance_animations' => __('Animations', 'thegem'),
        'contacts-and-socials' => __('Contacts & Socials', 'thegem'),
        'contacts-and-socials_socials' => __('Socials', 'thegem'),
        'contacts-and-socials_contacts' => __('Contacts', 'thegem'),
        'custom-css-js' => __('Custom CSS & JS', 'thegem'),
        'custom-css-js_custom-css' => __('Custom CSS', 'thegem'),
        'custom-css-js_custom-js' => __('Custom JS', 'thegem'),
        'custom-css-js_tracking-code' => __('Tracking Code', 'thegem'),
        'extras' => __('Extras', 'thegem'),
        'backup' => __('Backup & Import', 'thegem'),
        'reset' => __('Reset All', 'thegem'),
        'sidebar' => __('Sidebar', 'thegem'),
        'content-and-sidebar' => __('Content & Sidebar', 'thegem'),
        'onepager-and-scrollers' => __('Onepager & Scrollers', 'thegem'),
        'layout' => __('Layout', 'thegem'),
        'additional-settings' => __('Additional Settings', 'thegem'),
        'post-settings' => __('Post Settings', 'thegem'),
        'portfolio-item-settings' => __('Portfolio Item Settings', 'thegem'),
        'product-settings' => __('Product Settings', 'thegem'),
        'product-layout' => __('Product Layout', 'thegem'),
        'product-gallery' => __('Product Gallery', 'thegem'),
        'product-grid-list-settings' => __('Grid/List Settings', 'thegem'),
        'thegem-dashboard-system-status' => __('System Status', 'thegem'),
        'thegem-dashboard-welcome' => __('Welcome', 'thegem'),
        'install-required-plugins' => __('Plugins', 'thegem'),
        'thegem-dashboard-changelog' => __('Changelog', 'thegem'),
        'thegem-importer' => __('Demo Import', 'thegem'),
        'thegem-dashboard-importer' => __('Demo Import', 'thegem'),
        'thegem-dashboard-manual-and-support' => __('Manual & support', 'thegem'),
    ),
    'apply' => array (
        'apply_now' =>__('Apply Now', 'thegem'),
        'apply_failed' => __('Failed to apply settings', 'thegem'),
        'title' =>__('Apply Settings Confirmation', 'thegem'),
        'confirm_default' => __('By proceeding, global settings set here in theme options will be automatically applied on all existing pages. Are you sure you want to proceed?', 'thegem'),
        'confirm_post' => __('By proceeding, global settings set here in theme options will be automatically applied on all existing posts. Are you sure you want to proceed?', 'thegem'),
        'confirm_portfolio' => __('By proceeding, global settings set here in theme options will be automatically applied on all existing TheGem portfolio pages. Are you sure you want to proceed?', 'thegem'),
        'confirm_blog' => __('By proceeding, global settings set here in theme options will be automatically applied on all existing blog categories. Are you sure you want to proceed?', 'thegem'),
        'confirm_product' => __('By proceeding, global settings set here in theme options will be automatically applied on all existing product pages. Are you sure you want to proceed?', 'thegem'),
        'confirm_product_layout' => __('By proceeding, global settings set here in theme options will be automatically applied on all existing product pages. Are you sure you want to proceed?', 'thegem'),
        'confirm_product_categories' => __('By proceeding, global settings set here in theme options will be automatically applied on all existing product categories. Are you sure you want to proceed?', 'thegem'),
    ),
    'extras' => array(
        'purge_success' => __('Thumbnails cache successfully purged', 'thegem'),
        'purge_failed' => __('Thumbnails cache purging failed', 'thegem'),
        'regenerate_css_success' => __('CSS file has been successfully regenerated.', 'thegem'),
        'regenerate_css_failed' => __('Regenerating CSS failed', 'thegem'),
        'regenerate_success' => __('Success', 'thegem'),
    ),
    'colorpicker' => array(
        'undo' => __('Undo', 'thegem')
    ),
    'panel' => array(
        'font_preload' => __('Font Preload'),
        'font_preload_icons' => __('Icon Fonts'),
        'font_preload_fonts' => __('Self Hosted Fonts'),
        'portfolio_excerpt' => __('Short Description/Excerpt'),
        'post_excerpt' => __('Short Description/Excerpt'),
        'layout' => __('Layout', 'thegem'),
        'layout_type' => __('Layout Type', 'thegem'),
        'layout_style' => __('Layout Style', 'thegem'),
        'layout_style_layout' => __('Layout', 'thegem'),
        'layout_style_body_frame' => __('Body Frame', 'thegem'),
        'layout_backgrounds' => __('Layout Background', 'thegem'),
        'layout_backgrounds_body_frame' => __('Layout Background Type', 'thegem'),
        'layout_header' => __('Header', 'thegem'),
        'header_source' => __('Header Source', 'thegem'),
        'header_builder' => __('Header Builder', 'thegem'),
        'header_builder_template' => __('Header Builder Template', 'thegem'),
        'header_builder_sticky' => __('Sticky Header', 'thegem'),
        'header_builder_menu' => __('Menu Style (Test)', 'thegem'),
        'header_builder_menu_res' => __('Mobile Menu Layout', 'thegem'),
        'header_builder_overlap' => __('Header Overlap', 'thegem'),
        'layout_menu_header' => __('Menu & Header Layout', 'thegem'),
        'menu_and_header' => __('Menu & Header', 'thegem'),
        'body_background' => __('Content Background', 'thegem'),
        'body_background_type' => __('Content Background Type', 'thegem'),
        'main_content_area' => __('Main Content Area', 'thegem'),
        'top_padding' => __('Top Padding', 'thegem'),
        'top_padding_woo' => __('Top Padding (WooCommerce)', 'thegem'),
        'bottom_padding' => __('Bottom Padding', 'thegem'),
        'smooth_scroll' => __('Smooth Scroll', 'thegem'),
        'scroll_to_top' => __('«Scroll to Top» Button', 'thegem'),
        'scroll_to_top_button_style' => __('Button Style', 'thegem'),
        'scroll_to_top_button_colors' => __('Button Colors', 'thegem'),
        'preloader' => __('Preloaders', 'thegem'),
        'preloader_page' => __('Page Preloader', 'thegem'),
        'preloader_content' => __('Content Elements Preloader', 'thegem'),
        'preloader_style' => __('Preloader Style', 'thegem'),
        'preloader_format' => __('Choose Preloader Format', 'thegem'),
        'preloader_color' => __('Preloader Colors', 'thegem'),
        'preloader_content_color' => __('Content Elements Preloader Colors', 'thegem'),
        'preloader_page_color' => __('Page Preloader Colors', 'thegem'),
        'preloader_enabled' => __('Page Preloader', 'thegem'),
        'logo' => __('Logo', 'thegem'),
        'logo_dark' => __('Dark Logo', 'thegem'),
        'logo_light' => __('Light Logo', 'thegem'),
        'logo_desktop' => __('Desktop Logo', 'thegem'),
        'logo_desktop_light' => __('Desktop Logo (Light)', 'thegem'),
        'logo_mobile' => __('Mobile & Sticky Menu Logo', 'thegem'),
        'logo_mobile_light' => __('Mobile Logo (Light)', 'thegem'),
        'favicon' => __('Favicon', 'thegem'),
        'options' => __('Options', 'thegem'),
        'options_additional' => __('Additional Options', 'thegem'),
        'options_sticky_header' => __('Sticky Header', 'thegem'),
        'options_sticky_menu' => __('Sticky Menu', 'thegem'),
        'sticky_header_mobile_enabled' => __('Enabled', 'thegem'),
        'sticky_header_mobile_hide_on_scroll' => __('Hide On Scroll', 'thegem'),
        'sticky_header_mobile_disabled' => __('Disabled', 'thegem'),
        'top_area' => __('Top Area', 'thegem'),
        'top_area_layout' => __('Top Area Layout', 'thegem'),
        'top_area_options' => __('Top Area Options', 'thegem'),
        'top_area_sticky' => __('Sticky Top Area', 'thegem'),
        'top_area_button' => __('Top Area Button', 'thegem'),
        'top_area_button_style' => __('Button Style', 'thegem'),
        'top_area_button_colors' => __('Button Colors', 'thegem'),
        'top_area_font' => __('Font', 'thegem'),
        'top_area_font_colors' => __('Font Colors', 'thegem'),
        'top_area_background' => __('Background for Top Area', 'thegem'),
        'top_area_background_type' => __('Top Area Background Type', 'thegem'),
        'top_area_colors' => __('Top Area Colors', 'thegem'),
        'menu' => __('Menu', 'thegem'),
        'menu_options' => __('Menu Options', 'thegem'),
        'main_menu' => __('Main Menu', 'thegem'),
        'main_menu_font' => __('Font', 'thegem'),
        'main_menu_font_color_level1' => __('Level 1 Font Color', 'thegem'),
        'caching_minifying' => __('Caching & Minifying', 'thegem'),
        'rocket_autoptimize' => __('WP Rocket & Autoptimize', 'thegem'),
        'submenu' => __('Submenu', 'thegem'),
        'submenu_font' => __('Font', 'thegem'),
        'submenu_font_color_level2' => __('Level 2 Font Colors', 'thegem'),
        'submenu_font_color_level3' => __('Level 3+ Font Colors', 'thegem'),
        'overlay_menu' => __('Overlay Menu', 'thegem'),
        'overlay_menu_colors' => __('Overlay Menu Color', 'thegem'),
        'overlay_menu_font' => __('Font', 'thegem'),
        'overlay_menu_font_colors' => __('Font Colors', 'thegem'),
        'menu_header' => __('Menu & Header', 'thegem'),
        'menu_header_background' => __('Main Menu & Header Area Background Type', 'thegem'),
        'menu_header_background_container' => __('Header Container Background Type', 'thegem'),
        'menu_header_area_background' => __('Header Area Background Type', 'thegem'),
        'menu_header_navigation_background' => __('Navigation Area Background Type', 'thegem'),
        'menu_header_vertical_navigation_background' => __('Main Menu Area Background Type', 'thegem'),
        'menu_header_vertical_mobile_background' => __('Header Area Background Type (Responsive Mode)', 'thegem'),
        'menu_header_level1_colors' => __('Level 1 Colors', 'thegem'),
        'menu_header_level2_colors' => __('Level 2 Colors', 'thegem'),
        'menu_header_level3_colors' => __('Level 3+ Colors', 'thegem'),
        'menu_header_border_color' => __('Border Color', 'thegem'),
        'submenu_highlighter_color' => __('Submenu Pointer', 'thegem'),
        'backgrounds' => __('Backgrounds', 'thegem'),
        'background_effect' => __('Background Effect', 'thegem'),
        'hamburger' => __('Hamburger', 'thegem'),
        'hamburger_menu' => __('Hamburger Menu', 'thegem'),
        'hamburger_colors' => __('Hamburger Colors', 'thegem'),
        'hamburger_icon_color' => __('Hamburger Icon Color', 'thegem'),
        'mega_menu' => __('Mega Menu', 'thegem'),
        'mega_menu_colors' => __('Mega Menu Colors', 'thegem'),
        'title_area' => __('Title Area', 'thegem'),
        'title_area_woo' => __('Title Area (WooCommerce)', 'thegem'),
        'title_area_general' => __('General', 'thegem'),
        'title_area_type' => __('Type of Title Area', 'thegem'),
        'content_area' => __('Content Area', 'thegem'),
        'breadcrumbs' => __('Breadcrumbs', 'thegem'),
        'breadcrumbs_settings' => __('Breadcrumbs Settings', 'thegem'),
        'breadcrumbs_alignment' => __('Breadcrumbs Alignment', 'thegem'),
        'style_alignment' => __('Style & Alignment', 'thegem'),
        'style_alignment_fullheight' => __('Fullheight', 'thegem'),
        'style_alignment_fullwidth' => __('100% Width', 'thegem'),
        'style_alignment_content_alignment' => __('Content Alignment', 'thegem'),
        'style_alignment_padding' => __('Paddings', 'thegem'),
        'style_alignment_xlarge' => __('XLarge Title', 'thegem'),
        'style_alignment_title_color' => __('Title Text Color', 'thegem'),
        'style_alignment_excerpt_color' => __('Excerpt Text Color', 'thegem'),
        'background' => __('Background', 'thegem'),
        'background_type' => __('Background Type', 'thegem'),
        'background_parallax' => __('Parallax Background', 'thegem'),
        'general' => __('General', 'thegem'),
        'page_sidebar' => __('Page Sidebar', 'thegem'),
        'footer' => __('Footer', 'thegem'),
        'footer_widget' => __('Footer Widget Area', 'thegem'),
        'footer_widget_woocommerce' => __('WooCommerce Bottom Area', 'thegem'),
        'footer_width' => __('100% Footer Width', 'thegem'),
        'parallax' => __('Parallax', 'thegem'),
        'top_margin' => __('Top Margin', 'thegem'),
        'bottom_margin' => __('Bottom Margin', 'thegem'),
        'header_bottom_margin' => __('Header Bottom Margin', 'thegem'),
        'grid_type' => __('Grid Type', 'thegem'),
        'padding' => __('Padding', 'thegem'),
        'bottom_area' => __('Bottom Area', 'thegem'),
        'bottom_area_text' => __('Text For Bottom Area', 'thegem'),
        'custom_footer' => __('Footer Template', 'thegem'),
        'custom_footer_select' => __('Select Footer Template', 'thegem'),
        'font' => __('Font', 'thegem'),
        'font_h1' => __('H1 Font', 'thegem'),
        'font_h2' => __('H2 Font', 'thegem'),
        'font_h3' => __('H3 Font', 'thegem'),
        'font_h4' => __('H4 Font', 'thegem'),
        'font_h5' => __('H5 Font', 'thegem'),
        'font_h6' => __('H6 Font', 'thegem'),
        'font_body' => __('Body Font', 'thegem'),
        'font_excerpt' => __('Excerpt Font', 'thegem'),
        'font_styled_subtitle' => __('Styled Subtitle Font', 'thegem'),
        'font_xlarge' => __('XLarge Title Font', 'thegem'),
        'font_light' => __('Thin Title Font', 'thegem'),
        'font_colors' => __('Font Colors', 'thegem'),
        'additional_colors' => __('Additional Colors', 'thegem'),
        'global_defaults' => __('Global Defaults', 'thegem'),
        'elements_background' => __('Elements Background', 'thegem'),
        'elements_background_default' => __('Elements Background Defaults', 'thegem'),
        'elements_colors' => __('Elements Colors', 'thegem'),
        'divider' => __('Divider', 'thegem'),
        'divider_defaults' => __('Divider Defaults', 'thegem'),
        'links' => __('Links', 'thegem'),
        'links_defaults' => __('Links Color Defaults', 'thegem'),
        'buttons' => __('Buttons', 'thegem'),
        'buttons_flat' => __('Flat Button Defaults', 'thegem'),
        'buttons_outline' => __('Outline Button Defaults', 'thegem'),
        'widgets_sidebar' => __('Sidebar Widgets', 'thegem'),
        'widgets_title' => __('Widget Title Colors', 'thegem'),
        'widgets_link' => __('Widget Links Defaults', 'thegem'),
        'bullets' => __('Bullets', 'thegem'),
        'galleries' => __('Galleries', 'thegem'),
        'bullets_icon' => __('Bullets Icon Defaults', 'thegem'),
        'blockquotes' => __('Blockquote Icon', 'thegem'),
        'blockquotes_testimonials' => __('In Testimonials', 'thegem'),
        'blockquotes_quoted' => __('In Quoted Text', 'thegem'),
        'date_filter' => __('Date', 'thegem'),
        'date_filter_team' => __('Date & Team Subtitle Defaults', 'thegem'),
        'icons_color' => __('Icon Colors', 'thegem'),
        'icons_color_content' => __('Content Icons Defaults', 'thegem'),
        'icons_color_system' => __('System Icons Defaults', 'thegem'),
        'icons_color_socials' => __('Social Icons Defaults', 'thegem'),
        'icons_color_sharing' => __('Sharing Icons Defaults', 'thegem'),
        'icons_color_elements' => __('Elements Border Defaults', 'thegem'),
        'icons_color_in_portfolio_gallery' => __('Icons In Portfolio & Gallery Hovers', 'thegem'),
        'pagination_color' => __('Pagination Colors', 'thegem'),
        'pagination_color_numeric' => __('Numbers Pagination Defaults', 'thegem'),
        'pagination_color_dots' => __('Dots Pagination Defaults', 'thegem'),
        'contact_forms' => __('Contact Forms', 'thegem'),
        'contact_forms_light' => __('Light Style', 'thegem'),
        'contact_forms_dark' => __('Dark Style', 'thegem'),
        'newsletter_forms' => __('Newsletter Forms', 'thegem'),
        'newsletter_forms_content' => __('In Content', 'thegem'),
        'newsletter_forms_sidebar' => __('In Sidebars', 'thegem'),
        'newsletter_forms_footer' => __('In Footer', 'thegem'),
        'content_forms' => __('Comments & Content Forms', 'thegem'),
        'default_input' => __('Input Defaults', 'thegem'),
        'default_button' => __('Button Defaults', 'thegem'),
        'default_hover' => __('Hover Defaults', 'thegem'),
        'default_hover_color' => __('Hover Colors Defaults', 'thegem'),
        'default_font' => __('Font Defaults', 'thegem'),
        'default_h1_font' => __('H1 Font Defaults', 'thegem'),
        'default_h2_font' => __('H2 Font Defaults', 'thegem'),
        'default_h3_font' => __('H3 Font Defaults', 'thegem'),
        'default_h4_font' => __('H4 Font Defaults', 'thegem'),
        'default_h5_font' => __('H5 Font Defaults', 'thegem'),
        'default_h6_font' => __('H6 Font Defaults', 'thegem'),
        'default_font_body' => __('Body Font Defaults', 'thegem'),
        'default_font_excerpt' => __('Excerpt Font Defaults', 'thegem'),
        'default_font_styled_subtitle' => __('Styled Subtitle Font Defaults', 'thegem'),
        'default_font_xlarge' => __('XLarge Title Font Defaults', 'thegem'),
        'default_font_light' => __('Thin Title Font Defaults', 'thegem'),
        'default_font_regular' => __('Regular Font Defaults', 'thegem'),
        'default_font_thin' => __('Thin Font Defaults', 'thegem'),
        'default_font_bold_title' => __('Title Font (Bold Style) Defaults', 'thegem'),
        'default_font_thin_title' => __('Title Font (Thin Style) Defaults', 'thegem'),
        'default_font_counter' => __('Counter Numbers Font Defaults', 'thegem'),
        'default_font_counter_thin' => __('Counter Numbers (Thin) Font Defaults', 'thegem'),
        'default_font_widget' => __('Widget Title Font Defaults', 'thegem'),
        'default_color' => __('Color Defaults', 'thegem'),
        'default_h1_color' => __('H1 Color Defaults', 'thegem'),
        'default_h2_color' => __('H2 Color Defaults', 'thegem'),
        'default_h3_color' => __('H3 Color Defaults', 'thegem'),
        'default_h4_color' => __('H4 Color Defaults', 'thegem'),
        'default_h5_color' => __('H5 Color Defaults', 'thegem'),
        'default_h6_color' => __('H6 Color Defaults', 'thegem'),
        'default_color_body' => __('Body Color Defaults', 'thegem'),
        'default_color_excerpt' => __('Excerpt Color Defaults', 'thegem'),
        'default_color_styled_subtitle' => __('Styled Subtitle Color Defaults', 'thegem'),
        'default_color_widget' => __('Widget Title Color Defaults', 'thegem'),
        'default_description_font' => __('Description Font Defaults', 'thegem'),
        'default_title_text_color' => __('Title Text Color Defaults', 'thegem'),
        'default_description_text_color' => __('Description Text Color Defaults', 'thegem'),
        'default_gallery_title_font' => __('Gallery Title Font (Regular) Defaults', 'thegem'),
        'default_gallery_title_font_bold' => __('Gallery Title Font (Bold Style)', 'thegem'),
        'label' => __('Label', 'thegem'),
        'description' => __('Description', 'thegem'),
        'description_gallery' => __('Gallery Description Font', 'thegem'),
        'overlay' => __('Overlay', 'thegem'),
        'tabs_accordions' => __('Tabs & Accordions', 'thegem'),
        'counters' => __('Counters', 'thegem'),
        'sidebar_widgets' => __('Sidebar Widgets', 'thegem'),
        'general_settings' => __('General Settings', 'thegem'),
        'catalog_mode' => __('Catalog Mode', 'thegem'),
        'quick_view' => __('Quick View', 'thegem'),
        'product_list_pagination' => __('Product List Pagination', 'thegem'),
        'product_title_font' => __('Product Title Font', 'thegem'),
        'product_price_font' => __('Product Price Font', 'thegem'),
        'product_labels_font' => __('Product Labels Font', 'thegem'),
        'product_labels_font_default' => __('Labels Font Defaults', 'thegem'),
        'product_categories_font' => __('Product Categories Font', 'thegem'),
        'product_listings_grids' => __('Listings & Grids', 'thegem'),
        'product_categories' => __('Product Categories', 'thegem'),
        'product_amount_color' => __('Product Amount Color', 'thegem'),
        'product_separator_color' => __('Product Separator Color', 'thegem'),
        'product_image' => __('Product Image', 'thegem'),
        'product_page' => __('Product Page', 'thegem'),
        'typography' => __('Typography', 'thegem'),
        'listings_and_grids' => __('Listings & Grids', 'thegem'),
        'product_grids' => __('Product Grids', 'thegem'),
        'product_grids_legacy' => __('Classic Grid & TheGem Legacy Settings', 'thegem'),
        'product_grids_on_image' => __('Products Grid', 'thegem'),
        'product_grids_title' => __('Product Title In Products Grid', 'thegem'),
        'product_page_title' => __('Product Title On Product Page', 'thegem'),
        'product_sidebar_title' => __('Product Title In Sidebar Widgets', 'thegem'),
        'product_cart_title' => __('Product Title In Cart', 'thegem'),
        'product_categories_title' => __('Categories In Products Grid', 'thegem'),
        'product_grids_price_title' => __('Price In Products Grid', 'thegem'),
        'product_page_price_title' => __('Price On Product Page', 'thegem'),
        'product_sidebar_price_title' => __('Price In Sidebar Widgets', 'thegem'),
        'product_cart_price_title' => __('Price In Cart', 'thegem'),
        'widget' => __('Widget', 'thegem'),
        'cart' => __('Cart', 'thegem'),
        'cart_layout' => __('Cart', 'thegem'),
        'cart_layout_select' => __('Select Cart Layout', 'thegem'),
        'cart_empty_title' => __('Empty Cart Title', 'thegem'),
        'cart_empty_text' => __('Empty Cart Text', 'thegem'),
        'cart_icon' => __('Cart Icon', 'thegem'),
        'wishlist_icon' => __('Wishlist Icon', 'thegem'),
        'cart_checkout_table' => __('Cart & Сheckout Table', 'thegem'),
        'cart_checkout_forms' => __('Cart & Checkout Forms', 'thegem'),
        'cart_checkout_steps' => __('Checkout Steps', 'thegem'),
        'cart_checkout_steps_position' => __('Checkout Steps Position', 'thegem'),
        'cart_cross_sell' => __('Cross-Sell Products', 'thegem'),
        'cart_cross_sell_title' => __('Cross-Sells Title', 'thegem'),
        'cart_cross_sell_items' => __('Number of Cross-Sells (-1 for all)', 'thegem'),
        'cart_cross_sell_columns' => __('Cross-Sells Columns', 'thegem'),
        'cart_cross_sell_columns_100' => __('Cross-Sells 100% Width', 'thegem'),
        'size_guide' => __('Size Guide', 'thegem'),
        'size_guide_image' => __('Size Guide Image', 'thegem'),
        'custom_image_settings' => __('Custom Image Sizes', 'thegem'),
        'checkout_layout' => __('Checkout', 'thegem'),
        'checkout_layout_select' => __('Select Checkout Layout', 'thegem'),
        'checkout_complete' => __('Order Complete', 'thegem'),
        'checkout_thank_you_extra' => __('Extra content for “Thank you page”', 'thegem'),
        'checkout_thank_you_default' => __('Default “Thank you page” content', 'thegem'),
        'hamburger_position' => __('Position in Hamburger Menu Types', 'thegem'),
        'amount_label' => __('Amount Label', 'thegem'),
        'amount_label_color' => __('Amount Label Color', 'thegem'),
        'colors' => __('Colors', 'thegem'),
        'page_speed' => __('Page Speed Optimizations', 'thegem'),
        'page_speed_image_load' => __('Image Loading', 'thegem'),
        'caching_minifying' => __('Caching & Minifying', 'thegem'),
        'rocket_autoptimize' => __('WP Rocket & Autoptimize', 'thegem'),
        'image_optimizations' => __('Image Loading Optimizations', 'thegem'),
        'distance_to_viewport' => __('Distance To Viewport To Start Loading', 'thegem'),
        'any_caching_plugins' => __('Any Сaching Plugins In Use?', 'thegem'),
        'lazy_load' => __('Lazy Loading', 'thegem'),
        'lazy_loading' => __('Lazy Loading Animations', 'thegem'),
        'lazy_loading_mobile' => __('Lazy Loading Animations On Mobiles', 'thegem'),
        'custom_css_editor' => __('Custom CSS Editor', 'thegem'),
        'custom_css' => __('Custom CSS', 'thegem'),
        'custom_js_editor' => __('Custom JS Editor', 'thegem'),
        'custom_js_header' => __('JS in Website Header', 'thegem'),
        'custom_js_footer' => __('JS in Website Footer', 'thegem'),
        'tracking_code' => __('Analytics, Remarketing & Co.', 'thegem'),
        'tracking_code_socials' => __('Tracking Code (Google Analytics, Facebook Pixel, Remarketing etc.)', 'thegem'),
        'extra_options' => __('Extra Options', 'thegem'),
        'regenerate_css' => __('Regenerate CSS', 'thegem'),
        'open_graph_tags' => __('TheGem\'s Open Graph Tags', 'thegem'),
        'thumbnails_cache' => __('Thumbnails Cache', 'thegem'),
        'news_post_type' => __('«News» post type', 'thegem'),
        'nivoslider' => __('NivoSlider', 'thegem'),
        'backup' => __('Backup', 'thegem'),
        'export' => __('Export', 'thegem'),
        'import' => __('Import', 'thegem'),
        'reset' => __('Reset to Defaults', 'thegem'),
        'to_backup' => __('Backup Theme Options', 'thegem'),
        'to_export' => __('Export Theme Options', 'thegem'),
        'to_import' => __('Import Theme Options', 'thegem'),
        'to_reset' => __('Reset Theme Options', 'thegem'),
        'social_networks' => __('Social Networks', 'thegem'),
        'social_networks_popular' => __('Popular Social Networks', 'thegem'),
        'social_icon_colors' => __('Social Icon Colors', 'thegem'),
        'add_new_social' => __('Add New Social', 'thegem'),
        'add_new_social_network' => __('Add New Social Network', 'thegem'),
        'contact_details' => __('Contact Details', 'thegem'),
        'contact_top_area' => __('Contacts in Top Area', 'thegem'),
        'contact_widget' => __('Contacts widget', 'thegem'),
        'contacts' => __('Contacts', 'thegem'),
        'global_settings' => __('Global Settings', 'thegem'),
        'global_settings_apply_post' => __('Global Settings for All Posts', 'thegem'),
        'global_settings_apply_page' => __('Global Settings for All Pages', 'thegem'),
        'global_settings_apply_portfolio' => __('Global Settings for All Portfolios', 'thegem'),
        'global_settings_apply_blog_categories' => __('Global Settings for All Blog Archive Pages', 'thegem'),
        'global_settings_apply_product' => __('Global Settings for All Products', 'thegem'),
        'global_settings_apply_product_categories' => __('Global Settings for All Product Categories', 'thegem'),
        'apply_all_existing_post_page' => __('Apply on All Existing Posts/Pages', 'thegem'),
        'apply_all_existing_post' => __('Apply on All Existing Posts', 'thegem'),
        'apply_all_existing_page' => __('Apply on All Existing Pages', 'thegem'),
        'apply_all_existing_portfolio' => __('Apply on All Existing Portfolio Pages', 'thegem'),
        'apply_all_existing_blog_categories' => __('Apply on All Existing Blog Categories', 'thegem'),
        'apply_all_existing_product' => __('Apply on All Existing Products', 'thegem'),
        'apply_all_existing_product_categories' => __('Apply on All Existing Product Categories', 'thegem'),
        'apply_all_existing_product_archives' => __('Apply on All Existing Product Archives', 'thegem'),
        '404_page' => __('404 Page', 'thegem'),
        '404_page_custom' => __('Custom 404 Page', 'thegem'),
        'appearance' => __('Appearance', 'thegem'),
        'appearance_post' => __('Post Appearance', 'thegem'),
        'appearance_portfolio' => __('Portfolio Item Appearance', 'thegem'),
        'appearance_grid_list' => __('Appearance in Extended Grid', 'thegem'),
        'appearance_grid' => __('Grid Appearance', 'thegem'),
        'featured_content' => __('Featured Content', 'thegem'),
        'post_elements' => __('Post Elements', 'thegem'),
        'excerpt_length' => __('Excerpt Length', 'thegem'),
        'header' => __('Header', 'thegem'),
        'sidebar' => __('Sidebar', 'thegem'),
        'content_and_sidebar' => __('Content & Sidebar', 'thegem'),
        'sidebar_style' => __('Sidebar Style', 'thegem'),
        'sidebar_sticky' => __('Sticky Sidebar', 'thegem'),
        'widgets' => __('Widgets', 'thegem'),
        'customize_sidebar_widgets' => __('Customize Sidebar Widgets', 'thegem'),
        'widgets_in_sidebar' => __('Widgets In Sidebar', 'thegem'),
        'extras' => __('Extras', 'thegem'),
        'redirect' => __('Redirect', 'thegem'),
        'redirect_subpage' => __('Automatic Redirect To Subpage', 'thegem'),
        'portfolio_page_elements' => __('Portfolio Page Elements', 'thegem'),
        'back_to_overview' => __('Back to Overview URL', 'thegem'),
        'portfolio_parent_page' => __('Parent Page for Portfolio Items', 'thegem'),
        'rewrite_slug' => __('Rewrite Slug', 'thegem'),
        'hover_options' => __('Hover Icon', 'thegem'),
        'link_target' => __('Link Target', 'thegem'),
        'show_as_highlight' => __('Show as Highlight', 'thegem'),
        'highlight_type' => __('Highlight Type', 'thegem'),
        'hover_with_alternative_product' => __('Hover with alternative product image', 'thegem'),
        'overview_title' => __('Alternative Title', 'thegem'),
        'overview_summary' => __('Overview Summary', 'thegem'),
        'preview_button' => __('Project Preview Button', 'thegem'),
        'preview_button_link' => __('Project Preview Button Link', 'thegem'),
        'preview_button_text' => __('Project Preview Button Text', 'thegem'),
        'gallery_slider_arrows' => __('Gallery Slider Arrows', 'thegem'),
        'lightbox_colors' => __('Lightbox Colors', 'thegem'),
        'portfolio_title_font' => __('Portfolio Title Font in Grids', 'thegem'),
        'portfolio_title_color' => __('Portfolio Title Color in Grids', 'thegem'),
        'portfolio_description_font' => __('Portfolio Description Font in Grids', 'thegem'),
        'portfolio_description_color' => __('Portfolio Description Color in Grids', 'thegem'),
        'portfolio_slider_arrows' => __('Portfolio Slider Arrows', 'thegem'),
        'filter_buttons' => __('Filter Buttons in Grids', 'thegem'),
        'sorting_controls' => __('Sorting Controls in Grids', 'thegem'),
        'date_and_sets' => __('Date in Grids', 'thegem'),
        'separator' => __('Separator in Grids', 'thegem'),
        'testimonial_quoted_text' => __('Quoted Text Font', 'thegem'),
        'testimonial_name_text' => __('Name Text Font', 'thegem'),
        'testimonial_position_text' => __('Position Text Font', 'thegem'),
        'testimonial_company_text' => __('Company Text Font', 'thegem'),
        'testimonials_arrows' => __('Testimonials Slider Arrows', 'thegem'),
        'title_and_excerpt' => __('Title & Excerpt', 'thegem'),
        'style_and_alignment' => __('Style & Alignment', 'thegem'),
        'icon' => __('Icon', 'thegem'),
        'footer_widget_area' => __('Footer Widget Area', 'thegem'),
        'onepager' => __('Onepager', 'thegem'),
        'fullpage_scroller' => __('Fullpage Scroller', 'thegem'),
        'style' => __('Style', 'thegem'),
        'post_format' => __('Post Format', 'thegem'),
        'post_appearance' => __('Post Appearance', 'thegem'),
        'item_appearance' => __('Item Appearance', 'thegem'),
        'header_transparency' => __('Header Transparency', 'thegem'),
        'header_opacity' => __('Header Opacity', 'thegem'),
        'use_light_menu_and_logo' => __('Use Light Menu & Logo', 'thegem'),
        'top_area_transparency' => __('Top Area Transparency', 'thegem'),
        'top_area_opacity' => __('Top Area Opacity', 'thegem'),
        'styled_elements' => __('Styled Elements', 'thegem'),
        'thegem_elements' => __('TheGem Elements', 'thegem'),
        'menu_select' => __('Select Menu', 'thegem'),
        'use_page_native_title' => __('Use Page Native Title', 'thegem'),
        'use_rich_content_title' => __('Use rich content title / HTML formatting', 'thegem'),
        'excerpt' => __('Excerpt', 'thegem'),
        'icon_shape' => __('Icon Shape', 'thegem'),
        'icon_size' => __('Icon Size', 'thegem'),
        'title_top_margin' => __('Title Top Margin', 'thegem'),
        'title_max_width' => __('Title Max Width', 'thegem'),
        'excerpt_top_margin' => __('Excerpt Top Margin', 'thegem'),
        'excerpt_max_width' => __('Excerpt Max Width', 'thegem'),
        'page_as_onepager' => __('Page as Onepager', 'thegem'),
        'page_as_fullpage' => __('Page as Fullpage Scroller', 'thegem'),
        'type' => __('Type', 'thegem'),
        'enable_scroll_mobile' => __('Enable Normal Scroll On Mobiles', 'thegem'),
        'fullpage_disabled_dots' => __('Navigation Dots', 'thegem'),
        'fullpage_style_dots' => __('Style For Navigation Dots', 'thegem'),
        'fullpage_disabled_tooltips_dots' => __('Tooltips For Navigation Dots', 'thegem'),
        'fullpage_fixed_background' => __('Fixed Backgrounds', 'thegem'),
        'fullpage_enable_continuous' => __('Continuous Scrolling', 'thegem'),
        'fullpage_disabled_mobile' => __('Normal Scroll On Mobiles', 'thegem'),
        'fullpage_scroll_effect' => __('Scroll Effect', 'thegem'),
        'redirect_to_subpage' => __('Redirect To Subpage', 'thegem'),
        'page_paddings' => __('Page Paddings', 'thegem'),
        'background_type_frame' => __('Background Type for Body Frame', 'thegem'),
        'featured_post' => __('Featured Post', 'thegem'),
        'highlighted_post' => __('Highlighted Post', 'thegem'),
        'highlight_style' => __('Highlight Style', 'thegem'),
        'highlighted_product' => __('Highlighted Product', 'thegem'),
        'highlight_alternative_colors' => __('Alternative Highlight Style Colors', 'thegem'),
        'format' => __('Format', 'thegem'),
        'color_split' => __('Color Split', 'thegem'),
        'theme' => __('Theme', 'thegem'),
        'permissions' => __('Permissions', 'thegem'),
        'server_environment' => __('Server Environment', 'thegem'),
        'wordpress_environment' => __('Wordpress Environment', 'thegem'),
        'theme_version' => __('Theme version', 'thegem'),
        'registration' => __('Registration', 'thegem'),
        'page_builder' => __('Page Builder', 'thegem'),
        'use_page_settings' => __('Dynamic Settings', 'thegem'),
        'form_background' => __('Form Background', 'thegem'),
        'custom_settings' => __('Custom Settings', 'thegem'),
        'custom_settings_search_page' => __('Custom Settings for Search Page', 'thegem'),
        'social_network' => __('Social Network', 'thegem'),
        'xlarge_title' => __('XLarge Title', 'thegem'),
        'frame' => __('Frame', 'thegem'),
        'width_page_layout' => __('100% Width Page Layout', 'thegem'),
        'additional' => __('Additional', 'thegem'),
        'additional_colors_default' => __('Additional Colors Defaults', 'thegem'),
        'content_area_options' => __('Content Area Options', 'thegem'),
        'use_light_logo' => __('Use Light Logo', 'thegem'),
        'stylesheets_writable' => __('Stylesheets writable', 'thegem'),
        'uploads_folder_writable' => __('Uploads folder writable', 'thegem'),
        'api_server_connection' => __('API Server connection', 'thegem'),
        'php_version' => __('PHP Version', 'thegem'),
        'php_memory_limit' => __('PHP Memory Limit', 'thegem'),
        'php_time_limit' => __('PHP Time Limit', 'thegem'),
        'php_max_input_vars' => __('PHP Max Input Vars', 'thegem'),
        'php_post_max_size' => __('PHP Post Max Size', 'thegem'),
        'php_upload_limit' => __('PHP Upload Limit', 'thegem'),
        'connection_time_limit' => __('Connection time limit', 'thegem'),
        'wp_version' => __('WP Version', 'thegem'),
        'wp_filesystem' => __('WP File System', 'thegem'),
        'language' => __('Language', 'thegem'),
        'social_sharing' => __('Social Sharing', 'thegem'),
        'social_sharing_button' => __('Social Sharing Button', 'thegem'),
        'page_options_for_custom_post_types' => __('Page Options for Custom Post Types', 'thegem'),
        'version_control' => __('Version Control', 'thegem'),
        'version_rollback' => __('Rollback to Previous Theme Version', 'thegem'),
        'product_caption' => __('Product Caption', 'thegem'),
        'pagination' => __('Pagination', 'thegem'),
        'labels' => __('Labels', 'thegem'),
        'filters' => __('Filters', 'thegem'),
        'ajax_notifications' => __('AJAX Notifications', 'thegem'),
        'notification' => __('Notification', 'thegem'),
        'additional_options' => __('Additional Options', 'thegem'),
        'product_gallery' => __('Product Gallery', 'thegem'),
        'product_gallery_style' => __('Layout & Style', 'thegem'),
        'product_gallery_type' => __('Gallery Type', 'thegem'),
        'product_gallery_column_position' => __('Gallery Column Position', 'thegem'),
        'product_gallery_column_width' => __('Gallery Columns Width', 'thegem'),
        'product_gallery_show_image' => __('Show Main Image', 'thegem'),
        'product_gallery_zoom' => __('Zoom Magnifier', 'thegem'),
        'product_gallery_lightbox' => __('Lightbox Gallery', 'thegem'),
        'product_gallery_labels' => __('Show Labels', 'thegem'),
        'product_gallery_auto_height' => __('Gallery Auto Height', 'thegem'),
        'product_gallery_colors' => __('Colors', 'thegem'),
        'product_gallery_grid_columns' => __('Columns', 'thegem'),
        'product_gallery_grid_gaps' => __('Gaps', 'thegem'),
        'product_gallery_grid_gaps_hide' => __('Disable Margins', 'thegem'),
        'product_gallery_grid_top_margin' => __('Description Column Top Margin', 'thegem'),
        'product_gallery_video_autoplay' => __('Video Autoplay', 'thegem'),
        'product_layout_settings' => __('Product Layout Settings', 'thegem'),
        'product_gallery_retina_ready' => __('Retina-ready thumbnails', 'thegem'),
        'product_archive_layout' => __('Grid Layout', 'thegem'),
        'product_archive_content_width' => __('Content Width', 'thegem'),
        'product_archive_columns' => __('Columns', 'thegem'),
        'product_archive_columns_100' => __('100% Width Columns', 'thegem'),
        'product_archive_size' => __('Gaps', 'thegem'),
        'product_archive_image_aspect_ratio' => __('Image Aspect Ratio', 'thegem'),
        'product_archive_preset' => __('Product Preset', 'thegem'),
        'product_archive_quick_view' => __('Quick View', 'thegem'),
        'product_archive_quick_view_text' => __('Quick View Text', 'thegem'),
        'product_archive_sorting' => __('Default Sorting', 'thegem'),
        'product_archive_show_sorting' => __('Sorting Control on Frontend', 'thegem'),
        'product_archive_category_description_position' => __('Category Description Position', 'thegem'),
        'product_archive_caption_elements' => __('Caption Elements', 'thegem'),
        'product_archive_add_to_cart' => __('Add To Cart', 'thegem'),
        'product_archive_add_to_wishlist' => __('Add To Wishlist', 'thegem'),
        'product_archive_show_categories' => __('Categories', 'thegem'),
        'product_archive_show_title' => __('Product Title', 'thegem'),
        'product_archive_show_price' => __('Product Price', 'thegem'),
        'product_archive_show_reviews' => __('Reviews', 'thegem'),
        'product_archive_show_add_to_cart' => __('Add to Cart', 'thegem'),
        'product_archive_add_to_cart_type' => __('Type', 'thegem'),
        'product_archive_cart_button_show_icon' => __('Show Icon', 'thegem'),
        'product_archive_cart_button_text' => __('Button Text', 'thegem'),
        'product_archive_cart_icon' => __('Cart Icon', 'thegem'),
        'product_archive_select_options_button_text' => __('Select Options Text', 'thegem'),
        'product_archive_select_options_icon' => __('Select Options Icon', 'thegem'),
        'product_archive_show_wishlist' => __('Add To Wishlist', 'thegem'),
        'product_archive_add_wishlist_icon' => __('Add to Wishlist Icon', 'thegem'),
        'product_archive_added_wishlist_icon' => __('Added to Wishlist Icon', 'thegem'),
        'product_archive_items_per_page' => __('Items Per Page', 'thegem'),
        'product_archive_show_pagination' => __('Pagination', 'thegem'),
        'product_archive_pagination_type' => __('Pagination Type', 'thegem'),
        'product_archive_more_button_text' => __('Button Text', 'thegem'),
        'product_archive_more_icon' => __('Icon', 'thegem'),
        'product_archive_more_stretch_full_width' => __('Stretch to Full Width', 'thegem'),
        'product_archive_more_show_separator' => __('Separator', 'thegem'),
        'product_archive_filter_by_attributes' => __('Filter By Attributes', 'thegem'),
        'product_archive_filter_by_attributes_select' => __('Select Attributes', 'thegem'),
        'product_archive_filter_by_product_status' => __('Filter By Product Status', 'thegem'),
        'product_archive_product_search' => __('Product Search', 'thegem'),
        'product_archive_text_labels' => __('Text Labels', 'thegem'),
        'product_archive_filters_type' => __('Filters Type', 'thegem'),
        'product_archive_filters_ajax' => __('Ajax Filtering', 'thegem'),
        'product_archive_scroll_to_top' => __('Scroll To Top', 'thegem'),
        'product_archive_remove_attr_counts' => __('Remove Attributes Counts', 'thegem'),
        'product_archive_filters_style' => __('Filters Style', 'thegem'),
        'product_archive_filter_by_categories' => __('Filter by Categories', 'thegem'),
        'product_archive_filter_by_categories_hierarchy' => __('Hierarchy', 'thegem'),
        'product_archive_filter_by_categories_count' => __('Product Counts', 'thegem'),
        'product_archive_filter_by_categories_title' => __('Title', 'thegem'),
        'product_archive_filter_by_categories_order_by' => __('Order By', 'thegem'),
        'product_archive_filter_by_price' => __('Filter by Price', 'thegem'),
        'product_archive_filter_by_price_title' => __('Filter by Price Title', 'thegem'),
        'product_archive_filter_by_attribute' => __('Filter by Attribute', 'thegem'),
        'product_archive_filter_by_attribute_count' => __('Product Counts', 'thegem'),
        'product_archive_filter_by_attribute_hide_empty' => __('Hide Empty', 'thegem'),
        'product_archive_filter_by_status' => __('Filter by Product Status', 'thegem'),
        'product_archive_filter_by_status_title' => __('Title', 'thegem'),
        'product_archive_filter_by_status_sale' => __('On Sale', 'thegem'),
        'product_archive_filter_by_status_sale_text' => __('“On Sale” Text', 'thegem'),
        'product_archive_filter_by_status_stock' => __('In Stock', 'thegem'),
        'product_archive_filter_by_status_stock_text' => __('“In Stock” Text', 'thegem'),
        'product_archive_filter_by_status_count' => __('Status Counts', 'thegem'),
        'product_archive_filter_by_search' => __('Product Search', 'thegem'),
        'product_archive_filters_text_labels_all_text' => __('“Show All” Text', 'thegem'),
        'product_archive_filters_text_labels_clear_text' => __('“Clear Filters” Text', 'thegem'),
        'product_archive_filters_text_labels_search_text' => __('“Search by Product” Text', 'thegem'),
        'product_archive_filter_buttons_hidden_show_text' => __('“Show Filters” Text', 'thegem'),
        'product_archive_filter_buttons_hidden_sidebar_title' => __('Sidebar Title', 'thegem'),
        'product_archive_filter_buttons_hidden_filter_by_text' => __('“Filter By” Text', 'thegem'),
        'product_archive_added_cart_text' => __('“Added to Cart” Text', 'thegem'),
        'product_archive_added_wishlist_text' => __('“Added to Wishlist” Text', 'thegem'),
        'product_archive_removed_wishlist_text' => __('“Removed from Wishlist” Text', 'thegem'),
        'product_archive_view_cart_button_text' => __('“View Cart” Button Text', 'thegem'),
        'product_archive_checkout_button_text' => __('“Checkout” Button Text', 'thegem'),
        'product_archive_view_wishlist_button_text' => __('“View Wishlist” Button Text', 'thegem'),
        'product_archive_not_found_text' => __('“No Products Found” Button Text', 'thegem'),
        'product_archive_loading_animation' => __('Lazy Loading Animation', 'thegem'),
        'product_archive_animation_effect' => __('Animation Effect', 'thegem'),
        'product_archive_ignore_highlights' => __('Ignore Highlighted Products', 'thegem'),
        'product_archive_skeleton_loader' => __('Skeleton Preloader on grid loading', 'thegem'),
        'product_archive_featured_only' => __('Show only “Featured” Products', 'thegem'),
        'product_archive_sale_only' => __('Show only “On Sale” Products', 'thegem'),
        'product_archive_social_sharing' => __('Social Sharing', 'thegem'),
        'product_archive_customize_styles' => __('Customize styles', 'thegem'),
        'product_archive_hover_effect' => __('Hover Effect', 'thegem'),
        'product_archive_caption_container' => __('Caption Container', 'thegem'),
        'product_archive_typography' => __('Typography', 'thegem'),
        'product_archive_icons' => __('Icons', 'thegem'),
        'product_archive_buttons' => __('Buttons', 'thegem'),
        'product_archive_filters_sorting_search' => __('Filters, Sorting, Search', 'thegem'),
        'product_archive_notification' => __('Notification', 'thegem'),
        'product_archive_image_hover_effect_image' => __('Hover Effect', 'thegem'),
        'product_archive_image_hover_effect_fallback' => __('Fallback Hover', 'thegem'),
        'product_archive_caption_container_preset' => __('Preset', 'thegem'),
        'product_archive_caption_container_alignment' => __('Content Alignment', 'thegem'),
        'product_archive_caption_container_background_color' => __('Caption Background Color', 'thegem'),
        'product_archive_caption_container_background' => __('Background Color', 'thegem'),
        'product_archive_caption_container_separator' => __('Separator', 'thegem'),
        'product_archive_caption_container_separator_width' => __('Separator Width', 'thegem'),
        'product_archive_caption_container_separator_color' => __('Separator Color', 'thegem'),
        'product_archive_caption_container_preset_hover' => __('Preset', 'thegem'),
        'product_archive_caption_container_size' => __('Container Height', 'thegem'),
        'product_archive_icons_color' => __('Icons Color', 'thegem'),
        'product_archive_icons_color_background' => __('Icons Background Color', 'thegem'),
        'product_archive_icons_color_border' => __('Icons Border Color', 'thegem'),
        'product_archive_button_border_width' => __('Border Width', 'thegem'),
        'product_archive_button_border_radius' => __('Border Radius', 'thegem'),
        'product_archive_button_icon_alignment' => __('Icon Alignment', 'thegem'),
        'product_archive_button_add_to_cart_colors' => __('"Add to Cart" Button Colors', 'thegem'),
        'product_archive_button_select_options_colors' => __('"Select Options" Button Colors', 'thegem'),
        'product_archive_filters_controls' => __('Controls', 'thegem'),
        'product_archive_filters_text_colors' => __('Text Colors', 'thegem'),
        'product_archive_filters_counts_colors' => __('Counts Colors', 'thegem'),
        'product_archive_filters_selected' => __('Selected Filters', 'thegem'),
        'product_archive_filters_sidebar_separator' => __('Sidebar Separator', 'thegem'),
        'product_archive_filters_sidebar_hidden' => __('Hidden Sidebar', 'thegem'),
        'product_archive_filters_sidebar_title_color' => __('Sidebar Title Color', 'thegem'),
        'product_archive_filters_filter_by_color' => __('"Filter by" Color:', 'thegem'),
        'product_archive_sorting_dropdown' => __('Dropdown', 'thegem'),
        'product_archive_search_icon_colors' => __('Search Icon Colors', 'thegem'),
        'product_archive_search_input' => __('Search Input', 'thegem'),
        'product_archive_notice_stay_visible' => __('Stay visible, ms', 'thegem'),
        'product_archive_notice_colors' => __('Notification Colors', 'thegem'),
        'product_archive_notice_buttons_colors' => __('Notification Buttons Colors', 'thegem'),
        'product_archive_quick_view_colors' => __('Quick View Colors', 'thegem'),
        'product_title_styles' => __('Product Title', 'thegem'),
        'product_categories_styles' => __('Product Categories', 'thegem'),
        'product_price_styles' => __('Product Price', 'thegem'),
        'product_buttons_styles' => __('Buttons', 'thegem'),
        'product_icons_styles' => __('Icons', 'thegem'),
        'product_labels_styles' => __('Labels', 'thegem'),
        'product_additional_colors' => __('Additional Colors', 'thegem'),
        'product_grid_styles' => __('Products Grid', 'thegem'),
        'product_grid_category_styles' => __('Product Categories Grid', 'thegem'),
        'product_grid_category_title' => __('Category Title', 'thegem'),
        'product_grid_category_counts' => __('Product Counts', 'thegem'),
        'product_sidebar' => __('Sidebar', 'thegem'),
        'product_sidebar_widgets' => __('Sidebar Widgets', 'thegem'),
        'product_cart_checkout' => __('Cart & Checkout', 'thegem'),
        'product_labels_style' => __('Labels Style', 'thegem'),
        'product_label_new' => __('"New" Label', 'thegem'),
        'product_label_sale' => __('"Sale" Label', 'thegem'),
        'product_label_out_of_stock' => __('"Out of stock" Label', 'thegem'),
        'product_grid_button_general' => __('General', 'thegem'),
        'product_grid_button_add_to_cart' => __('Add to Cart Button', 'thegem'),
        'product_grid_button_select_options' => __('Select Options Button, View Cart Button', 'thegem'),
        'product_grid_icon_style' => __('Icon Style', 'thegem'),
        'product_grid_separator' => __('Separator', 'thegem'),
        'product_grid_quick_view_colors' => __('Quick View (Caption Below Image) ', 'thegem'),
        'product_layout_source' => __('Layout Source', 'thegem'),
        'product_builder' => __('Product Builder', 'thegem'),
        'product_builder_template' => __('Select Single Product Template', 'thegem'),
        'product_builder_preview_product' => __('Preview Product for Templates Builder', 'thegem'),
        'product_page_layout' => __('Product Layout', 'thegem'),
        'product_page_layout_preset' => __('Layout Preset', 'thegem'),
        'product_page_layout_centered' => __('Centered Product Info', 'thegem'),
        'product_page_layout_centered_top_margin' => __('Product Info Top Margin', 'thegem'),
        'product_page_layout_centered_boxed' => __('Boxed Product Info', 'thegem'),
        'product_page_layout_centered_boxed_color' => __('Box Background', 'thegem'),
        'product_page_layout_column_width' => __('Columns Width Preset', 'thegem'),
        'product_page_layout_style' => __('Layout & Style', 'thegem'),
        'product_page_layout_fullwidth' => __('100% Width Layout', 'thegem'),
        'product_page_layout_sticky' => __('Sticky Product', 'thegem'),
        'product_page_skeleton_loader' => __('Skeleton Preloader', 'thegem'),
        'product_page_layout_background' => __('Product Gallery & Product Info', 'thegem'),
        'product_page_layout_title_area' => __('Title Area', 'thegem'),
        'product_page_layout_breadcrumbs' => __('Breadcrumbs (WooCommerce)', 'thegem'),
        'product_page_ajax_add_to_cart' => __('AJAX Add to Cart', 'thegem'),
        'product_page_desc_review' => __('Description & Reviews', 'thegem'),
        'product_page_desc_review_source' => __('Description Tab Source', 'thegem'),
        'product_page_desc_review_layout' => __('Layout', 'thegem'),
        'product_page_desc_review_layout_tabs_style' => __('Style', 'thegem'),
        'product_page_desc_review_layout_tabs_alignment' => __('Alignment', 'thegem'),
        'product_page_desc_review_layout_acc_position' => __('Position', 'thegem'),
        'product_page_desc_review_layout_one_by_one_backgrounds' => __('One by One Backgrounds', 'thegem'),
        'product_page_desc_review_description' => __('Description', 'thegem'),
        'product_page_desc_review_additional_info' => __('Additional Info', 'thegem'),
        'product_page_desc_review_reviews' => __('Reviews', 'thegem'),
        'product_page_buttons' => __('Buttons', 'thegem'),
        'product_page_button_add_to_cart' => __('Add to Cart', 'thegem'),
        'product_page_button_add_to_cart_icon_show' => __('Icon in Button', 'thegem'),
        'product_page_button_add_to_wishlist' => __('Add to Wishlist', 'thegem'),
        'product_page_clear_attributes' => __('Clear Attributes', 'thegem'),
        'product_page_elements' => __('Elements', 'thegem'),
        'product_page_elements_prev_next' => __('Prev/Next Product', 'thegem'),
        'product_page_elements_preview_on_hover' => __('Product Preview on Hover', 'thegem'),
        'product_page_elements_back_to_shop' => __('Back to Shop', 'thegem'),
        'product_page_elements_back_to_shop_link' => __('Back to Shop Link', 'thegem'),
        'product_page_elements_title' => __('Product Title', 'thegem'),
        'product_page_elements_attributes' => __('Attribute (eg. brand)', 'thegem'),
        'product_page_elements_reviews' => __('Reviews', 'thegem'),
        'product_page_elements_price' => __('Price', 'thegem'),
        'product_page_elements_price_strikethrough' => __('Strikethrough Price', 'thegem'),
        'product_page_elements_description' => __('Product Description', 'thegem'),
        'product_page_elements_stock_amount' => __('In Stock Amount', 'thegem'),
        'product_page_elements_labels' => __('Labels', 'thegem'),
        'product_page_elements_socials' => __('Social Sharing', 'thegem'),
        'product_page_elements_cross_sales' => __('Cross-sells', 'thegem'),
        'product_page_elements_upsell' => __('Upsell Products', 'thegem'),
        'product_page_elements_upsell_title' => __('Upsell Products Title', 'thegem'),
        'product_page_elements_upsell_items' => __('Number of items (-1 for all)', 'thegem'),
        'product_page_elements_upsell_columns' => __('Columns', 'thegem'),
        'product_page_elements_upsell_columns_100' => __('100% Width Columns', 'thegem'),
        'product_page_elements_related' => __('Related Products', 'thegem'),
        'product_page_elements_related_title' => __('Related Products Title', 'thegem'),
        'product_page_elements_related_items' => __('Number of items (-1 for all)', 'thegem'),
        'product_page_elements_related_columns' => __('Columns', 'thegem'),
        'product_page_elements_related_columns_100' => __('100% Width Columns', 'thegem'),
        'product_page_elements_size_guide' => __('Size Guide', 'thegem'),
        'product_page_elements_size_guide_image' => __('Size Guide Image', 'thegem'),
        'product_page_styles' => __('Product Page', 'thegem'),
        'product_page_styles_button_add_to_cart' => __('Add to Cart Button', 'thegem'),
        'product_page_styles_button_add_to_wishlist' => __('Add to Wishlist Icon', 'thegem'),
        'product_page_prev_next_navigation' => __('Prev/Next Navigation', 'thegem'),
        'product_page_title_price_description' => __('Title, Price, Description', 'thegem'),
        'product_page_size_guide' => __('Size Guide', 'thegem'),
        'product_page_meta_elements' => __('Meta Elements', 'thegem'),
        'product_page_upsells_related_products' => __('Upsells & Related Products', 'thegem'),
        'product_page_elements_sku' => __('SKU', 'thegem'),
        'product_page_elements_categories' => __('Categories', 'thegem'),
        'product_page_elements_tags' => __('Tags', 'thegem'),
        'product_page_elements_share' => __('Share Icons', 'thegem'),
        'product_wishlist_styles' => __('Wishlist Page', 'thegem'),
        'product_wishlist_styles_table' => __('Wishlist Table', 'thegem'),
        'website_search' => __('Website Search', 'thegem'),
        'website_search_search' => __('Search', 'thegem'),
        'website_search_layout' => __('Search Layout', 'thegem'),
        'website_search_placeholder_text' => __('Placeholder Text', 'thegem'),
        'website_search_post_types' => __('Post Types', 'thegem'),
        'website_search_ajax' => __('AJAX Live Search', 'thegem'),
        'website_search_products_auto_suggestions' => __('Products Auto-Suggestions', 'thegem'),
        'website_search_posts_auto_suggestions' => __('Posts Auto-Suggestions', 'thegem'),
        'website_search_posts_result_title' => __('Posts Results Title', 'thegem'),
        'website_search_pages_auto_suggestions' => __('Pages Auto-Suggestions', 'thegem'),
        'website_search_pages_result_title' => __('Pages Results Title', 'thegem'),
        'website_search_portfolio_auto_suggestions' => __('Portfolio Auto-Suggestions', 'thegem'),
        'website_search_portfolio_result_title' => __('Portfolio Results Title', 'thegem'),
        'website_search_popular' => __('Popular Searches', 'thegem'),
        'website_search_popular_title' => __('Popular Searches Title', 'thegem'),
        'website_search_select_terms' => __('Select Search Terms', 'thegem'),
        'website_search_view_results_button_text' => __('"View Results" Button Text', 'thegem'),
        'tags_colors' => __('Tags', 'thegem'),
        'tags_colors_default' => __('Tags Defaults', 'thegem'),
        'blog_layout' => __('Blog Layout', 'thegem'),
        'blog_layout_type' => __('Layout Type', 'thegem'),
        'blog_layout_type_grid' => __('Grid Layout', 'thegem'),
        'blog_layout_skin' => __('Skin', 'thegem'),
        'blog_layout_columns' => __('Columns', 'thegem'),
        'blog_layout_columns_100' => __('100% Width Columns', 'thegem'),
        'blog_layout_gaps' => __('Gaps', 'thegem'),
        'blog_layout_sorting' => __('Sorting Control on Frontend', 'thegem'),
        'blog_layout_hover_effect' => __('Hover Effect', 'thegem'),
        'blog_layout_icon_on_hover' => __('Icon on Hover', 'thegem'),
        'blog_layout_caption' => __('Blog Post Caption', 'thegem'),
        'blog_layout_caption_position' => __('Caption Position', 'thegem'),
        'blog_layout_caption_featured_image' => __('Featured Image', 'thegem'),
        'blog_layout_caption_title' => __('Title', 'thegem'),
        'blog_layout_caption_title_preset' => __('Font Size Preset', 'thegem'),
        'blog_layout_caption_description' => __('Description', 'thegem'),
        'blog_layout_caption_date' => __('Date', 'thegem'),
        'blog_layout_caption_categories' => __('Categories', 'thegem'),
        'blog_layout_caption_author' => __('Author', 'thegem'),
        'blog_layout_caption_author_avatar' => __('Author Avatar', 'thegem'),
        'blog_layout_caption_comments' => __('Comments', 'thegem'),
        'blog_layout_caption_likes' => __('Likes', 'thegem'),
        'blog_layout_caption_socials' => __('Social Sharing', 'thegem'),
        'blog_layout_caption_content_alignment' => __('Content Alignment', 'thegem'),
        'blog_layout_caption_container_preset' => __('Caption Container Preset', 'thegem'),
        'blog_layout_caption_container_bottom_border' => __('Bottom Border', 'thegem'),
        'blog_layout_pagination' => __('Pagination', 'thegem'),
        'blog_layout_pagination_items_per_page' => __('Items Per Page', 'thegem'),
        'blog_layout_pagination_type' => __('Pagination Type', 'thegem'),
        'blog_layout_pagination_next_page_preload' => __('Next page preloading', 'thegem'),
        'blog_layout_load_more_text' => __('Button Text', 'thegem'),
        'blog_layout_load_more_icon' => __('Icon', 'thegem'),
        'blog_layout_load_more_stretch' => __('Stretch to Full Width', 'thegem'),
        'blog_layout_load_more_separator' => __('Separator', 'thegem'),
        'blog_layout_load_more_spacing' => __('Top Spacing', 'thegem'),
        'blog_layout_load_more_btn_type' => __('Button Type', 'thegem'),
        'blog_layout_load_more_btn_size' => __('Size', 'thegem'),
        'blog_layout_additional_options' => __('Additional Options', 'thegem'),
        'blog_layout_loading_animation' => __('Lazy Loading Animation', 'thegem'),
        'blog_layout_animation_effect' => __('Animation Effect', 'thegem'),
        'blog_layout_ignore_highlights' => __('Ignore Highlighted Posts', 'thegem'),
        'blog_layout_skeleton_loader' => __('Skeleton Preloader on grid loading', 'thegem'),
        'search_layout' => __('Search Page Layout', 'thegem'),
        'search_layout_type' => __('Layout Type', 'thegem'),
        'search_layout_type_grid' => __('Grid Layout', 'thegem'),
        'search_layout_skin' => __('Skin', 'thegem'),
        'search_layout_columns' => __('Columns', 'thegem'),
        'search_layout_columns_100' => __('100% Width Columns', 'thegem'),
        'search_layout_gaps' => __('Gaps', 'thegem'),
        'search_layout_sorting' => __('Sorting Control on Frontend', 'thegem'),
        'search_layout_hover_effect' => __('Hover Effect', 'thegem'),
        'search_layout_icon_on_hover' => __('Icon on Hover', 'thegem'),
        'search_layout_post_type_indication' => __('Post Type Indication', 'thegem'),
        'search_layout_caption' => __('Search Result Caption', 'thegem'),
        'search_layout_caption_position' => __('Caption Position', 'thegem'),
        'search_layout_caption_featured_image' => __('Featured Image', 'thegem'),
        'search_layout_caption_title' => __('Title', 'thegem'),
        'search_layout_caption_title_preset' => __('Font Size Preset', 'thegem'),
        'search_layout_caption_description' => __('Description', 'thegem'),
        'search_layout_caption_date' => __('Date', 'thegem'),
        'search_layout_caption_categories' => __('Categories', 'thegem'),
        'search_layout_caption_author' => __('Author', 'thegem'),
        'search_layout_caption_author_avatar' => __('Author Avatar', 'thegem'),
        'search_layout_caption_content_alignment' => __('Content Alignment', 'thegem'),
        'search_layout_caption_container_preset' => __('Caption Container Preset', 'thegem'),
        'search_layout_caption_container_bottom_border' => __('Bottom Border', 'thegem'),
        'search_layout_pagination' => __('Pagination', 'thegem'),
        'search_layout_pagination_items_per_page' => __('Items Per Page', 'thegem'),
        'search_layout_pagination_type' => __('Pagination Type', 'thegem'),
        'search_layout_pagination_next_page_preload' => __('Next page preloading', 'thegem'),
        'search_layout_load_more_text' => __('Button Text', 'thegem'),
        'search_layout_load_more_icon' => __('Icon', 'thegem'),
        'search_layout_load_more_stretch' => __('Stretch to Full Width', 'thegem'),
        'search_layout_load_more_separator' => __('Separator', 'thegem'),
        'search_layout_load_more_spacing' => __('Top Spacing', 'thegem'),
        'search_layout_load_more_btn_type' => __('Button Type', 'thegem'),
        'search_layout_load_more_btn_size' => __('Size', 'thegem'),
        'search_layout_mixed_grids' => __('Mixed grids', 'thegem'),
        'search_layout_mixed_grids_items' => __('Items to Display', 'thegem'),
        'search_layout_mixed_grids_title' => __('Title Text', 'thegem'),
        'search_layout_mixed_grids_show_all' => __('"Show all results" Button Text', 'thegem'),
        'search_layout_mixed_grids_show_all_icon' => __('Icon', 'thegem'),
        'search_layout_mixed_grids_show_all_stretch' => __('Stretch to Full Width', 'thegem'),
        'search_layout_mixed_grids_show_all_separator' => __('Separator', 'thegem'),
        'search_layout_mixed_grids_show_all_spacing' => __('Top Spacing', 'thegem'),
        'search_layout_mixed_grids_show_all_btn_type' => __('Button Type', 'thegem'),
        'search_layout_mixed_grids_show_all_btn_size' => __('Size', 'thegem'),
        'search_layout_additional_options' => __('Additional Options', 'thegem'),
        'search_layout_loading_animation' => __('Lazy Loading Animation', 'thegem'),
        'search_layout_animation_effect' => __('Animation Effect', 'thegem'),
        'search_layout_skeleton_loader' => __('Skeleton Preloader on grid loading', 'thegem'),
    ),
    'settings' => array(
        'menu_transparency' => __('Menu Transparency', 'thegem'),
        'menu_opacity' => __('Menu Opacity', 'thegem'),
        'use_light_menu_logo' => __('Use Light Menu & Logo', 'thegem'),
        'search_icon' => __('Search', 'thegem'),
        'top_area_alignment' => __('Top Area Alignment', 'thegem'),
        'top_area_transparency' => __('Top Area Transparency', 'thegem'),
        'top_area_opacity' => __('Top Area Opacity', 'thegem'),
        'top_area_button_text' => __('Button Text', 'thegem'),
        'top_area_button_link' => __('Button Link', 'thegem'),
        'top_area_button_link_target' => __('Button Link Target', 'thegem'),
        'show_contact' => __('Show Contacts', 'thegem'),
        'show_socials' => __('Show Socials', 'thegem'),
        'slider_type' => __('Slider Type', 'thegem'),
        'select_slider' => __('Select Slider', 'thegem'),
        'select_title' => __('Select Title', 'thegem'),
        'slider_preloader' => __('Slider Preloader', 'thegem'),
        'breadcrumbs_alignment' => __('Breadcrumbs Alignment', 'thegem'),
        'breadcrumbs_delimiter' => __('Breadcrumbs Delimiter', 'thegem'),
        'breadcrumbs_shop_category' => __('Hide /shop/ parent category', 'thegem'),
        'horizontal' => __('Horizontal', 'thegem'),
        'vertical' => __('Vertical', 'thegem'),
        'title_top_margin' => __('Title Top Margin', 'thegem'),
        'title_max_width' => __('Title Max Width', 'thegem'),
        'excerpt_top_margin' => __('Excerpt Top Margin', 'thegem'),
        'excerpt_max_width' => __('Excerpt Max Width', 'thegem'),
        'button' => __('Button', 'thegem'),
        'page_numbers' => __('Page Numbers', 'thegem'),
        'load_more' => __('Load More', 'thegem'),
        'infinite_scroll' => __('Infinite Scroll', 'thegem'),
        'image_size_catalog' => __('Product List Image Size', 'thegem'),
        'image_size_product' => __('Product Page Image Size', 'thegem'),
        'image_size_thumb' => __('Thumbnails Image Size', 'thegem'),
        'checkout_multistep' => __('Multi-Step Checkout', 'thegem'),
        'checkout_onepage' => __('One-Page Checkout', 'thegem'),
        'hamburger_position_header' => __('In Header', 'thegem'),
        'hamburger_position_menu' => __('In Menu', 'thegem'),
        'show_positions_amount' => __('Show Positions Amount', 'thegem'),
        'show_total_product_amount' => __('Show Total Product Amount', 'thegem'),
        'address_details' => __('Address Details', 'thegem'),
        'phone_number' => __('Phone Number', 'thegem'),
        'fax_number' => __('Fax Number', 'thegem'),
        'email_address' => __('Email Address', 'thegem'),
        'website_url' => __('Website URL', 'thegem'),
        '404_page_select' => __('Select Custom 404 Page', 'thegem'),
        'featured_content' => __('Featured Content (Image, Video, Audio, Gallery) Inside Post', 'thegem'),
        'author_info' => __('Author Info', 'thegem'),
        'author_name' => __('Author Name', 'thegem'),
        'date' => __('Date', 'thegem'),
        'date_in_blog' => __('Date in Blog Categories', 'thegem'),
        'categories' => __('Categories', 'thegem'),
        'tags' => __('Tags', 'thegem'),
        'comments_icon' => __('Comments Icon', 'thegem'),
        'likes' => __('Likes', 'thegem'),
        'posts_navigation' => __('Posts Navigation', 'thegem'),
        'social_sharing' => __('Social Sharing', 'thegem'),
        'related_posts' => __('Related Posts', 'thegem'),
        'header_transparency' => __('Header Transparency', 'thegem'),
        'header_opacity' => __('Header Opacity', 'thegem'),
        'bottom_margin' => __('Bottom Margin', 'thegem'),
        'sidebar_left' => __('Left Sidebar', 'thegem'),
        'sidebar_right' => __('Right Sidebar', 'thegem'),
        'portfolio_sets' => __('Portfolio Sets', 'thegem'),
        'top_arrows' => __('Top Arrows', 'thegem'),
        'bottom_arrows' => __('Bottom Arrows', 'thegem'),
        'featured_post' => __('Feature this post in featured posts slider', 'thegem'),
        'highlighted_post' => __('Highlight This Post in Extended Grid', 'thegem'),
        'highlighted_product' => __('Highlight This Product in Products Grid', 'thegem'),
        'video_type' => __('Video Type', 'thegem'),
        'aspect_ratio' => __('Aspect Ratio', 'thegem'),
        'gallery_autoscroll' => __('Autoscroll (msec)', 'thegem'),
        'custom_title' => __('Select Title Template', 'thegem'),
        'quote_author' => __('Quote Author', 'thegem'),
        'kenburns_direction' => __('Direction', 'thegem'),
        'kenburns_speed' => __('Transition speed, ms:', 'thegem'),
    ),
    'addicon' => array(
        'all_icons' => __('All Icons', 'thegem'),
        'filter_by_name' => __('Filter by name...', 'thegem'),
        'choose_icon' => __('Choose Icon', 'thegem'),
        'icon_library' => __('Icon Library', 'thegem'),
        'social_name' => __('Social Network Name', 'thegem'),
        'link_to_profile' => __('Link To Profile', 'thegem'),
        'css_class' => __('CSS Class Name', 'thegem'),
        'icon' => __('Icon', 'thegem'),
        'icon_position' => __('Icon Alignment', 'thegem'),
        'icon_color' => __('Icon Color', 'thegem'),
        'icon_no_shape' => __('Icon (No Shape)', 'thegem'),
        'icon_circle_shape' => __('Icon (Circle Shape)', 'thegem'),
        'icon_square_shape' => __('Icon (Square Shape)', 'thegem'),
        'icon_top_area' => __('Icon for Top Area', 'thegem'),
    ),
    'button' => array(
        'reset_section' => __('Reset Section', 'thegem'),
        'preview_changes' => __('Preview Changes', 'thegem'),
        'save_changes' => __('Save Changes', 'thegem'),
        'save_layout' => __('Save Layout', 'thegem'),
        'style' => __('Button Style', 'thegem'),
        'size' => __('Button Size', 'thegem'),
        'position' => __('Button Position', 'thegem'),
        'text_weight' => __('Button Text Weight', 'thegem'),
        'text_style' => __('Button Text Style', 'thegem'),
        'text_transform' => __('Button Text Transform', 'thegem'),
        'border_width' => __('Button Border Width', 'thegem'),
        'border_radius' => __('Button Border Radius', 'thegem'),
        'purge_all' => __('Purge All...', 'thegem'),
        'backup_now' => __('Backup Now', 'thegem'),
        'backup_restore' => __('Restore Last Backup', 'thegem'),
        'copy' => __('Copy', 'thegem'),
        'delete' => __('Delete', 'thegem'),
        'download' => __('Download File', 'thegem'),
        'import' => __('Import from File', 'thegem'),
        'apply' => __('Apply', 'thegem'),
        'reset' => __('Reset Now', 'thegem'),
        'regenerate_css' => __('Regenerate File', 'thegem'),
        'reinstall_previous' => __('Reinstall previous version', 'thegem'),
        'install_activate' => __('Install & Activate', 'thegem'),
        'deactivate_all' => __('Deactivate all', 'thegem'),
        'deactivate_caching' => __('Deactivate caching', 'thegem'),
        'deactivate_minifying' => __('Deactivate minifying', 'thegem'),
        'activate_all' => __('Activate all', 'thegem'),
        'activate_caching' => __('Activate caching', 'thegem'),
        'activate_minifying' => __('Activate minifying', 'thegem'),
        'reinstall_settings' => __('Reinstall', 'thegem'),
        'optimizer_restore' => __('Restore my previous settings', 'thegem'),
        'create_template' => __('Create New Template', 'thegem'),
        'import_template' => __('Import Pre-Built Template', 'thegem'),
        'edit_template' => __('Edit Template', 'thegem'),
    ),
    'gradient' => array(
        'color' => __('Color', 'thegem'),
        'location' => __('Location', 'thegem'),
        'angle' => __('Angle', 'thegem'),
        'type' => __('Type', 'thegem'),
        'type_linear' => __('Linear', 'thegem'),
        'type_radial' => __('Radial', 'thegem'),
        'position' => __('Position', 'thegem'),
        'center_center' => __('Center Center', 'thegem'),
        'center_left' => __('Center Left', 'thegem'),
        'center_right' => __('Center Right', 'thegem'),
        'top_center' => __('Top Center', 'thegem'),
        'top_left' => __('Top Left', 'thegem'),
        'top_right' => __('Top Right', 'thegem'),
        'bottom_center' => __('Bottom Center', 'thegem'),
        'bottom_left' => __('Bottom Left', 'thegem'),
        'bottom_right' => __('Bottom Right', 'thegem'),
    ),
    'image' => array(
        'repeat' => __('Repeat', 'thegem'),
        'size' => __('Size', 'thegem'),
        'horizontal_position' => __('Horizontal Position', 'thegem'),
        'vertical_position' => __('Vertical Position', 'thegem'),
        'size_warning' => __('Note: the pixel size of the selected logo image is too small and not retina ready. Recommended image width for the chosen logo size:', 'thegem'),
    ),
    'video' => array(
        'type' => __('Video Type', 'thegem'),
        'type_none' => __('None', 'thegem'),
        'type_select' => __('Please Select', 'thegem'),
        'type_youtube' => __('Youtube', 'thegem'),
        'type_vimeo' => __('Vimeo', 'thegem'),
        'type_selfhosted' => __('Self-Hosted Video', 'thegem'),
        'aspect_ratio' => __('Aspect Ratio (16:9, 16:10, 4:3...)', 'thegem'),
        'overlay' => __('Overlay Color', 'thegem'),
        'link' => __('Video ID (for YouTube or Vimeo)', 'thegem'),
        'self_link' => __('Link to video', 'thegem'),
        'poster' => __('Video Poster', 'thegem'),
        'play_on_mobile' => __('Play on Mobiles', 'thegem'),
    ),
    'audio' => array(
        'type' => __('Audio Type', 'thegem'),
        'link' => __('Link to audio or select audio', 'thegem')
    ),
    'font' => array(
        'weight_normal' => __('Normal', 'thegem'),
        'weight_bold' => __('Bold', 'thegem'),
        'family' => __('Font Family', 'thegem'),
        'weight' => __('Font Weight', 'thegem'),
        'sets' => __('Font Sets', 'thegem'),
        'style' => __('Font Style', 'thegem'),
        'transform' => __('Text Transform', 'thegem'),
        'size' => __('Font Size', 'thegem'),
        'line_height' => __('Line Height', 'thegem'),
        'letter_spacing' => __('Letter Spacing', 'thegem'),
        'preview' => __('Preview', 'thegem'),
        'get_from_font' => __('Get From Font', 'thegem'),
        'style_normal' => __('Normal', 'thegem'),
        'style_italic' => __('Italic', 'thegem'),
        'style_oblique' => __('Oblique', 'thegem'),
        'transform_none' => __('Normal', 'thegem'),
        'transform_uppercase' => __('Uppercase', 'thegem'),
        'transform_lowercase' => __('Lowercase', 'thegem'),
        'transform_capitalize' => __('Capitalize', 'thegem'),
        'example' => __('Example Text', 'thegem'),
    ),
    'headerLayout' => array(
        'horizontal' => __('Horizontal', 'thegem'),
        'hamburger' => __('Hamburger', 'thegem'),
        'overlay' => __('Overlay', 'thegem'),
        'perspective' => __('Perspective', 'thegem'),
        'vertical' => __('Vertical', 'thegem'),
        'width' => __('Width', 'thegem'),
        'width_menu' => __('Menu Width', 'thegem'),
        'width_top_area' => __('Top Area Width', 'thegem'),
        'logo_align' => __('Logo Align', 'thegem'),
        'width_full' => __('Full', 'thegem'),
        'width_normal' => __('Normal', 'thegem'),
        'menu_and_header_style' => __('Menu & Header Style (Pre-sets)', 'thegem'),
        'light_menu_dark_submenu' => __('Light Main Menu & Dark Submenu', 'thegem'),
        'light_menu_light_submenu' => __('Light Main Menu & Light Submenu', 'thegem'),
        'dark_menu_dark_submenu' => __('Dark Main Menu & Dark Submenu', 'thegem'),
        'elegant_menu' => __('Elegant Font Light Menu', 'thegem'),
        'top_area' => __('Top Area', 'thegem'),
        'top_area_style' => __('Top Area Style (Pre-Sets)', 'thegem'),
        'top_area_style_light' => __('Light Background', 'thegem'),
        'top_area_style_dark' => __('Dark Background', 'thegem'),
        'top_area_style_anthracite' => __('Anthracite Background', 'thegem'),
        'top_area_tablets' => __('Top Area On Tablets', 'thegem'),
        'top_area_mobile' => __('Top Area On Mobiles', 'thegem'),
        'menu_socials_mobile' => __('Socials In Mobile Menu', 'thegem'),
        'menu_layout_tablets_portrait' => __('Menu Layout on Tablets (Portrait)', 'thegem'),
        'menu_layout_tablets_landscape' => __('Menu Layout on Tablets (Landscape)', 'thegem'),
        'mobile_menu_layout_style' => __('Mobile Menu Layout Style (Pre-sets)', 'thegem'),
        'responsive' => __('Responsive', 'thegem'),
        'as_set_for_mobile' => __('As set for mobiles', 'thegem'),
        'centered' => __('Centered', 'thegem'),
        'default' => __('Default', 'thegem'),
        'alternative' => __('Alternative', 'thegem'),
        'slide_left' => __('Slide Left', 'thegem'),
        'slide_top' => __('Slide Top', 'thegem'),
        'light_menu' => __('Light Menu', 'thegem'),
        'dark_menu' => __('Dark Menu', 'thegem'),
        'preview_is_loading' => __('Preview is loading...', 'thegem'),
    ),
    'logo' => array(
        'desktop_dark_width' => __('Desktop Dark Logo Width', 'thegem'),
        'mobile_dark_width' => __('Mobile Dark Logo Width', 'thegem'),
        'desktop_light_width' => __('Desktop Light Logo Width', 'thegem'),
        'mobile_light_width' => __('Mobile Light Logo Width', 'thegem'),
        'desktop_logo_width' => __('Logo Width on Desktops', 'thegem'),
        'mobile_logo_width' => __('Logo Width on Mobiles', 'thegem'),
    ),
    'modal'=>array(
        'alert' => array(
            'title' => __('Attention', 'thegem'),
            'button_ok_title' => __('OK', 'thegem')
        ),
        'confirm' => array(
            'title' => __('Confirmation', 'thegem'),
            'button_yes_title' => __('Yes', 'thegem'),
            'button_no_title' => __('No', 'thegem'),
        )
    ),
    'colors' => array(
        'color' => __('Color', 'thegem'),
        'color_normal' => __('Normal Color', 'thegem'),
        'color_active' => __('Active Color', 'thegem'),
        'color_hover' => __('Hover Color', 'thegem'),
        'color_on_image' => __('Color On Image', 'thegem'),
        'color_filled' => __('Filled Color', 'thegem'),
        'button_text' => __('Button Text', 'thegem'),
        'button_background' => __('Button Background', 'thegem'),
        'button_background_active' => __('Active Button Background', 'thegem'),
        'button_border' => __('Button Border', 'thegem'),
        'button_hover_text' => __('Button Hover Text', 'thegem'),
        'button_hover_background' => __('Button Hover Background', 'thegem'),
        'button_hover_border' => __('Button Hover Border', 'thegem'),
        'button_font' => __('Button Font Color', 'thegem'),
        'button_font_hover' => __('Button Font Color on Hover', 'thegem'),
        'button_font_active' => __('Active Button Font Color', 'thegem'),
        'menu_item_normal' => __('Normal Menu Item', 'thegem'),
        'menu_item_hover' => __('Hover Menu Item', 'thegem'),
        'menu_item_active' => __('Active Menu Item', 'thegem'),
        'menu_item_normal_light' => __('Normal (Light Version)', 'thegem'),
        'menu_item_hover_light' => __('Hover (Light Version)', 'thegem'),
        'menu_item_active_light' => __('Active (Light Version)', 'thegem'),
        'menu_background' => __('Menu Background Color', 'thegem'),
        'overlay_menu_text' => __('Overlay Menu Text', 'thegem'),
        'overlay_menu_hover' => __('Overlay Menu Hover Text', 'thegem'),
        'overlay_menu_active' => __('Overlay Menu Active Text', 'thegem'),
        'top_area_text' => __('Top Area Text Color', 'thegem'),
        'top_area_link' => __('Top Area Link Text Color', 'thegem'),
        'top_area_link_hover' => __('Top Area Link Hover Text Color', 'thegem'),
        'top_area_border_color' => __('Top Area Border Color', 'thegem'),
        'top_area_separator_color' => __('Top Area Separator Color', 'thegem'),
        'background' => __('Background', 'thegem'),
        'background_color' => __('Background Color', 'thegem'),
        'background_hover' => __('Hover Background', 'thegem'),
        'background_active' => __('Active Background', 'thegem'),
        'background_normal' => __('Normal Background', 'thegem'),
        'border' => __('Border', 'thegem'),
        'border_color' => __('Border Color', 'thegem'),
        'border_hover' => __('Hover Border Color', 'thegem'),
        'border_level2' => __('Level 2+ Border', 'thegem'),
        'hamburger_icon' => __('Hamburger Icon', 'thegem'),
        'hamburger_icon_light' => __('Hamburger Icon Light', 'thegem'),
        'overlay_menu_background' => __('Overlay Background Color', 'thegem'),
        'column_title_text' => __('Column Title', 'thegem'),
        'column_title_text_hover' => __('Column Title Hover', 'thegem'),
        'column_title_text_active' => __('Column Titles Active', 'thegem'),
        'mega_menu_icons_color' => __('Icons Color', 'thegem'),
        'widget_title_color' => __('Widget Title Color', 'thegem'),
        'widget_text_color' => __('Widget Text Color', 'thegem'),
        'widget_link_color' => __('Widget Link Color', 'thegem'),
        'widget_hover_link_color' => __('Widget Hover Link Color', 'thegem'),
        'widget_active_link_color' => __('Widget Active Link Color', 'thegem'),
        'widget_triangle_color' => __('Widget\'s title triangle color', 'thegem'),
        'text_color' => __('Text Color', 'thegem'),
        'text_color_hover' => __('Hover Text Color', 'thegem'),
        'text_font_color' => __('Text Font Color', 'thegem'),
        'menu_font_color' => __('Menu Font Color', 'thegem'),
        'menu_hover_font_color' => __('Menu Hover Font Color', 'thegem'),
        'menu_separator_color' => __('Menu Separator Color', 'thegem'),
        'copyright_text_color' => __('Copyright Text Color', 'thegem'),
        'copyright_link_color' => __('Copyright Link Color', 'thegem'),
        'top_border_color' => __('Top Border Color', 'thegem'),
        'styled_element_background' => __('TheGem Elements Background Color', 'thegem'),
        'styled_element_color' => __('Styled Element Color', 'thegem'),
        'divider_color' => __('Divider Default Color', 'thegem'),
        'link_color' => __('Link Color', 'thegem'),
        'link_color_hover' => __('Hover Link Color', 'thegem'),
        'link_color_active' => __('Active Link Color', 'thegem'),
        'normal_text_color' => __('Normal Text Color', 'thegem'),
        'normal_text_color_hover' => __('Hover Text Color', 'thegem'),
        'normal_background_color' => __('Normal Background Color', 'thegem'),
        'normal_background_color_hover' => __('Hover Background Color', 'thegem'),
        'normal_border_color' => __('Normal Border Color', 'thegem'),
        'bullets_icon_color' => __('Bullets Icon Default Color', 'thegem'),
        'testimonials_color' => __('Default Color in Testimonials', 'thegem'),
        'quoted_color' => __('Default Color in Quoted Text', 'thegem'),
        'date_filter_team_color' => __('Date & Team Subtitle Color', 'thegem'),
        'icon' => __('Icon', 'thegem'),
        'icon_on_hover' => __('Icon on Hover', 'thegem'),
        'icon_caption_image' => __('Icon (Caption on Image)', 'thegem'),
        'icon_caption_image_hover' => __('Icon on Hover (Caption on Image)', 'thegem'),
        'icon_color' => __('Icon Color', 'thegem'),
        'icon_color_hover' => __('Icon Color on Hover', 'thegem'),
        'icon_background_color' => __('Icon Background Color', 'thegem'),
        'icon_border_color' => __('Icon Border Color', 'thegem'),
        'icons_color' => __('Default Icons Color', 'thegem'),
        'icons_color_system' => __('System Icons Color', 'thegem'),
        'icons_color_social_top_area' => __('Social Icons in Top Area', 'thegem'),
        'icons_color_social_footer' => __('Social Icons in Footer', 'thegem'),
        'icons_color_social_post_types' => __('Social Icons on Pages, Posts, Portfolio Items', 'thegem'),
        'icons_color_social_woo' => __('Social Icons on WooCommerce Pages', 'thegem'),
        'icons_color_sharing_blog_box_border' => __('Sharing Icons In Blog Posts & Box Border', 'thegem'),
        'elements_border_colors' => __('TheGem Elements Border Colors', 'thegem'),
        'page_number_text' => __('Normal Page Number Text Color', 'thegem'),
        'page_number_text_hover' => __('Hover Page Number Text Color', 'thegem'),
        'page_number_text_active' => __('Active Page Number Background Color', 'thegem'),
        'page_number_background' => __('Normal Page Number Background Color', 'thegem'),
        'dot_color' => __('Normal Dot Color', 'thegem'),
        'dot_color_active' => __('Active Dot Color', 'thegem'),
        'placeholder_color' => __('Placeholder Text Color', 'thegem'),
        'cyan_breeze_hover' => __('«Cyan Breeze» Hover Color', 'thegem'),
        'zooming_white_hover' => __('«Zooming White» Hover Color', 'thegem'),
        'horizontal_sliding_hover' => __('«Horizontal Sliding» Hover Color', 'thegem'),
        'vertical_sliding_hover' => __('«Vertical Sliding» Hover Color', 'thegem'),
        'gradient_hover' => __('«Gradient» Hover Color', 'thegem'),
        'circular_overlay_hover' => __('«Circular Overlay» Hover Color', 'thegem'),
        'listings_and_grids' => __('Listings & Grids Color', 'thegem'),
        'product_grids' => __('Product Grids Color', 'thegem'),
        'product_grids_legacy_color' => __('Classic Grid & TheGem Legacy', 'thegem'),
        'product_price_listing_grids_color' => __('Listings & Grids Color', 'thegem'),
        'product_separator' => __('Product Separator', 'thegem'),
        'product_page' => __('Product Page Color', 'thegem'),
        'product_categories' => __('Product Categories Color', 'thegem'),
        'widget_color' => __('Widget Color', 'thegem'),
        'cart_color' => __('Cart Color', 'thegem'),
        'amount_minicart' => __('Amount in minicart widget', 'thegem'),
        'titles_text' => __('Titles Text Color', 'thegem'),
        'header_background' => __('Header Background Color', 'thegem'),
        'labels_text' => __('Labels Text Color', 'thegem'),
        'inactive_step' => __('Inactive Step Title', 'thegem'),
        'inactive_step_background' => __('Inactive Step Background', 'thegem'),
        'active_step_background' => __('Active Step Background', 'thegem'),
        'active_step' => __('Active Step Title', 'thegem'),
        'in_top_area' => __('In Top Area', 'thegem'),
        'in_footer' => __('In Footer', 'thegem'),
        'in_content' => __('In Content', 'thegem'),
        'in_woo' => __('In WooCommerce', 'thegem'),
        'line' => __('Line', 'thegem'),
        'link_color' => __('Link Color', 'thegem'),
        'link_color_hover' => __('Hover Link Color', 'thegem'),
        'arrow_normal' => __('Normal Arrow', 'thegem'),
        'arrow_hover' => __('Hover Arrow', 'thegem'),
        'gallery_lightbox_caption' => __('Gallery Lightbox Caption Background', 'thegem'),
        'gallery_lightbox_title' => __('Gallery Lightbox Title Text', 'thegem'),
        'gallery_lightbox_description' => __('Gallery Lightbox Description Text', 'thegem'),
        'sorting_controls_font' => __('Sorting Controls Font Color', 'thegem'),
        'sorting_controls_background' => __('Sorting Controls Background', 'thegem'),
        'sorting_controls_switch' => __('Sorting Controls Switch', 'thegem'),
        'date_sets' => __('Date & Sets Color', 'thegem'),
        'separator' => __('Separator Color', 'thegem'),
        'arrow_font' => __('Arrow Font Color', 'thegem'),
        'arrow_font_hover' => __('Arrow Font Color on Hover', 'thegem'),
        'arrow_background' => __('Arrow Background Color', 'thegem'),
        'arrow_background_hover' => __('Arrow Background on Hover', 'thegem'),
        'arrow_icon' => __('Arrow Icon', 'thegem'),
        'arrow_icon_hover' => __('Arrow Icon on Hover', 'thegem'),
        'author_color' => __('Author & Link Color', 'thegem'),
        'label_background_color' => __('Label Background Color', 'thegem'),
        'dark_icon' => __('Dark Icon', 'thegem'),
        'light_icon' => __('Light Icon', 'thegem'),
        'hide_icon' => __('"X" (Hide Menu) Color', 'thegem'),
        'additional_color' => __('Additional Color', 'thegem'),
        'date_color' => __('Date Color', 'thegem'),
        'overlay' => __('Overlay Color', 'thegem'),
        'social_icons' => __('Social Icons Color', 'thegem'),
        'font_color' => __('Font Color', 'thegem'),
        'font_color_cart' => __('Font Color (Cart)', 'thegem'),
        'font_color_checkout' => __('Font Color (Checkout)', 'thegem'),
        'triangle_color' => __('Triangle Color', 'thegem'),
        'product_gallery_elements_color' => __('Arrows and Icons Color', 'thegem'),
        'separator_color' => __('Separator Color', 'thegem'),
        'overlay_color' => __('Overlay Color', 'thegem'),
        'product_labels_text_color' => __('Label Text Color', 'thegem'),
        'product_labels_sale_background' => __('"Sale" Label Background', 'thegem'),
        'product_labels_new_background' => __('"New" Label Background', 'thegem'),
        'product_labels_out_of_stock_background' => __('"Out Of Stock" Label Background ', 'thegem'),
        'caption_below_image' => __('Caption Below Image', 'thegem'),
        'caption_on_image' => __('Caption On Image', 'thegem'),
        'caption_on_image_dark' => __('Caption On Image (Dark)', 'thegem'),
        'caption_on_image_light' => __('Caption On Image (Light)', 'thegem'),
        'text_color_on_hover' => __('Text Color on Hover', 'thegem'),
        'background_color_on_hover' => __('Background Color on Hover', 'thegem'),
        'border_color_on_hover' => __('Border Color on Hover', 'thegem'),
        'tag_background_color' => __('Tag Background Color', 'thegem'),
        'tag_font_color' => __('Tag Font Color', 'thegem'),
        'highlight_title_left_background' => __('Background Color (Post Has a Left Position in Grid)', 'thegem'),
        'highlight_title_left_color' => __('Text Color (Post Has a Left Position in Grid)', 'thegem'),
        'highlight_title_right_background' => __('Background Color (Post Has a Right Position in Grid)', 'thegem'),
        'highlight_title_right_color' => __('Text Color (Post Has a Right Position in Grid)', 'thegem'),
    ),
    'reset' => array(
        'confirm_title' => __('Warning', 'thegem'),
        'confirm_message' => __('Reset all theme options settings to the default state (reset factory settings)? Note: all your current settings will be overwritten. We recommend to backup your current settings before proceeding with reset.', 'thegem'),
        'done' => __('Theme Options have been reset', 'thegem')
    ),
    'backup' => array (
        'invalid_import_data' => __('Invalid import data', 'thegem'),
        'import_done' => __('Theme Options have been imported', 'thegem'),
        'current_settings_copied_to_clipboard' => __('Current theme options have been copied to clipboard', 'thegem'),
        'backup_success' => __('Backup completed successfully', 'thegem'),
        'restore_success' => __('Restoring completed successfully', 'thegem'),
        'backup_failed' => __('Backup failed', 'thegem'),
    ),
    'alert' => array(
        'background_colors' => __('For background colors go to', 'thegem'),
        'button_color' => __('For color settings go to', 'thegem'),
        'font_colors' => __('To setup font colors go to', 'thegem'),
        'top_area_button_color' => __('To setup top area button colors go to', 'thegem'),
        'custom_post_types' => __('Here you can enable TheGem page options for public custom post types. Public means this post types can be visible on front end.', 'thegem'),
        'no_custom_post_types' => __('No public custom post types found.', 'thegem'),
        'top_area_text_color' => __('To setup top area text colors go to', 'thegem'),
        'widget_color' => __('For additional color settings go to', 'thegem'),
        'menu_color_settings' => __('Menu Color Settings', 'thegem'),
        'menu_typography_settings' => __('Menu Typography Settings', 'thegem'),
        'menu_layout_settings' => __('Menu Layout Settings', 'thegem'),
        'menu_transparency_part1' => __('You can adjust top padding of', 'thegem'),
        'menu_transparency_part2' => __('if needed.', 'thegem'),
        'menu_transparency_part3' => __('To adjust top padding of', 'thegem'),
        'menu_transparency_part4' => __('enable custom settings.', 'thegem'),
        'button_color_settings' => __('Button Color Settings', 'thegem'),
        'widgets_color_settings' => __('Sidebar widgets color settings', 'thegem'),
        'last_backup' => __('Last Backup:', 'thegem'),
        'no_last_backup' => __('No backups yet', 'thegem'),
        'warning' => __('Warning: Lorem Ipsum dolor sit amet', 'thegem'),
        'setup_contact' => __('To setup contact details and social links go to Contacts & Socials', 'thegem'),
        'contacts_and_socials' => __('Contacts & Socials', 'thegem'),
        'create_custom_title' => __('To create new title template go to', 'thegem'),
        'create_custom_title_link' => __('Templates Builder -> Title Area -> Add New', 'thegem'),
        'create_custom_footer' => __('To create new footer template go to', 'thegem'),
        'create_custom_footer_link' => __('Templates Builder -> Footer -> Add New', 'thegem'),
        'add_widgets_footer' => __('To add widgets to footer widget area go to', 'thegem'),
        'add_widgets_sidebar' => __('To add widgets to a sidebar go to', 'thegem'),
        'add_widgets_sidebar_filter' => __('To add widgets to WooCommerce Sidebar go to', 'thegem'),
        'add_widgets_sidebar_filter_native' => __('Add widgets "Filter Products by..." to WooCommerce Sidebar in', 'thegem'),
        'add_widgets_footer_link' => __('Appearance -> Widgets', 'thegem'),
        'add_widgets_footer_woo' => __('To add widgets to WooCommerce Bottom Area go to', 'thegem'),
        'add_widgets_footer_woo_link' => __('Appearance -> Widgets', 'thegem'),
        'style_breadcrumbs' => __('To style breadcrumbs go to', 'thegem'),
        'theme_options' => __('Theme Options', 'thegem'),
        'to_setup_preloader_go_to' => __('To setup preloader go to', 'thegem'),
        'sidebar_widgets' => __('You can setup sidebar widgets in "Page Widgets" section below.', 'thegem'),
        'sidebar_widgets_part1' => __('You can setup default sidebar widgets in', 'thegem'),
        'sidebar_widgets_part2' => __('or in page options for posts/pages individually.', 'thegem'),
        'top_area_social_contact_color' => __('To setup top area colors for socials & contact icons go to', 'thegem'),
        'contacts_socials_settings' => __('Contacts & Socials Settings', 'thegem'),
        'product_archive_customize_typography' => __('For typography settings go to ', 'thegem'),
        'product_archive_customize_icons' => __('For icons style settings go to', 'thegem'),
        'product_archive_customize_buttons' => __('For buttons style settings go to', 'thegem'),
        'product_archive_customize_quick_view' => __('For quick view label style settings go to', 'thegem'),
        'product_archive_customize_labels' => __('For labels style settings go to', 'thegem'),
        'product_archive_customize_link' => __('WooCommerce -> Elements Styles', 'thegem'),
        'product_page_btn_style' => __('For style settings go to', 'thegem'),
        'product_page_btn_style_link' => __('WooCommerce -> Elements Styles', 'thegem'),
        'product_grid_sidebar' => __('For sidebar settings go to', 'thegem'),
        'product_grid_sidebar_link' => __('WooCommerce -> Shop Grid', 'thegem'),
        'product_page_layout' => __('For general page layout settings like header, sidebar & footer go to', 'thegem'),
        'product_page_layout_link' => __('Single Pages -> Product Page', 'thegem'),
        'product_page_tabs_typography' => __('For tabs/accordion typography settings go to', 'thegem'),
        'product_page_tabs_typography_link' => __('Typography -> Elements', 'thegem'),
        'product_grid_layout' => __('For general page layout settings like header, sidebar & footer go to', 'thegem'),
        'product_grid_layout_link' => __('Archive Pages -> Product Categories', 'thegem'),
        'header_builder_template' => __('To create new header template go to', 'thegem'),
        'header_builder_template_sticky' => __('To create new sticky header template go to', 'thegem'),
        'header_builder_template_link' => __('Templates Builder -> Header -> Add New ', 'thegem'),
        'search_layout_mixed_grids_part1' => __('In case search for products has been activated, the search results page will contain two grids: products grid as set under', 'thegem'),
        'search_layout_mixed_grids_link' => __('WooCommerce -> Shop Grid', 'thegem'),
        'search_layout_mixed_grids_part2' => __('and search results for all other post types.', 'thegem'),
    ),
    'filesystem' => array(
        'direct' => __("Direct Filesystem", 'thegem'),
        'ssh2' => __("SSH2", 'thegem'),
        'ftpext' => __("FTP Filesystem", 'thegem'),
        'ftpsockets' => __("FTP Sockets Filesystem", 'thegem'),
    ),
    'downgrade' => array(
        'title' => __('Attention', 'thegem'),
        'message' => __('Are you sure you want to re-install the previous version of TheGem theme and TheGem Elements plugin?', 'thegem'),
    ),
    'productGallery' => array(
        'click' => __('Click on Thumbnail', 'thegem'),
        'hover' => __('Hover on Thumbnail', 'thegem'),
        'carousel' => __('Carousel', 'thegem'),
        'dots' => __('Dots', 'thegem'),
        'horizontal' => __('Horizontal', 'thegem'),
        'vertical' => __('Vertical', 'thegem'),
        'single' => __('Single', 'thegem'),
        'grid' => __('Grid', 'thegem'),
        'new' => __('New', 'thegem'),
        'old' => __('Old', 'thegem'),
        'default' => __('Default', 'thegem'),
        'enabled' => __('Enabled', 'thegem'),
        'disabled' => __('Disabled', 'thegem'),
        'legacy' => __('Legacy TheGem', 'thegem'),
        'native' => __('Native WooCommerce', 'thegem'),
        'default_settings' => __('Default Settings', 'thegem'),
        'custom_settings' => __('Custom Settings', 'thegem'),
    ),
    'productArchive' => array(
        'content_width_boxed' => __('Boxed', 'thegem'),
        'content_width_full' => __('Full Width', 'thegem'),
        'content_width_full_no_gaps' => __('Full Width (no paddings)', 'thegem'),
        'layout_grid' => __('Products Grid', 'thegem'),
        'layout_legacy' => __('Classic Grid', 'thegem'),
        'justified' => __('Justified', 'thegem'),
        'masonry' => __('Masonry', 'thegem'),
        'metro' => __('Metro', 'thegem'),
        'col-1x' => __('1x columns', 'thegem'),
        'col-2x' => __('2x columns', 'thegem'),
        'col-3x' => __('3x columns', 'thegem'),
        'col-4x' => __('4x columns', 'thegem'),
        'col-5x' => __('5x columns', 'thegem'),
        'col-6x' => __('6x columns', 'thegem'),
        'col-100%' => __('100% width', 'thegem'),
        'col-4' => __('4 Columns', 'thegem'),
        'col-5' => __('5 Columns', 'thegem'),
        'col-6' => __('6 Columns', 'thegem'),
        'portrait' => __('Portrait', 'thegem'),
        'square' => __('Square', 'thegem'),
        'default' => __('WooCommerce Default Sorting', 'thegem'),
        'date' => __('Date', 'thegem'),
        'popularity' => __('Popularity', 'thegem'),
        'rating' => __('Rating', 'thegem'),
        'name' => __('Name', 'thegem'),
        'title' => __('Name', 'thegem'),
        'price' => __('Price', 'thegem'),
        'rand' => __('Random', 'thegem'),
        'asc' => __('ASC', 'thegem'),
        'desc' => __('DESC', 'thegem'),
        'orderby' => __('Order By', 'thegem'),
        'order' => __('Order', 'thegem'),
        'icon' => __('Icon', 'thegem'),
        'button' => __('Button', 'thegem'),
        'pagination_standard' => __('Standard', 'thegem'),
        'pagination_numbers' => __('Numbers', 'thegem'),
        'pagination_more' => __('Load More Button', 'thegem'),
        'pagination_scroll' => __('Infinite Scroll', 'thegem'),
        'filter_woo' => __('WooCommerce Sidebar Widgets', 'thegem'),
        'filter_thegem' => __('TheGem Filters', 'thegem'),
        'filter_disabled' => __('Disabled', 'thegem'),
        'filter_standard' => __('Horizontal', 'thegem'),
        'filter_sidebar' => __('Sidebar', 'thegem'),
        'filter_hidden' => __('Hidden Sidebar', 'thegem'),
        'filter_name' => __('Name', 'thegem'),
        'filter_term_order' => __('Category Order', 'thegem'),
        'bounce' => __('Bounce', 'thegem'),
        'move_up' => __('Move Up', 'thegem'),
        'fade_in' => __('Fade In', 'thegem'),
        'fall_perspective' => __('Fall Perspective', 'thegem'),
        'scale' => __('Scale', 'thegem'),
        'flip' => __('Flip', 'thegem'),
        'effect_slide' => __('Show Next Image (Slide)', 'thegem'),
        'effect_fade' => __('Show Next Image (Fade)', 'thegem'),
        'effect_default' => __('Cyan Breeze', 'thegem'),
        'effect_zooming_blur' => __('Zooming White', 'thegem'),
        'effect_horizontal_sliding' => __('Horizontal Sliding', 'thegem'),
        'effect_vertical_sliding' => __('Vertical Sliding', 'thegem'),
        'effect_gradient' => __('Gradient', 'thegem'),
        'effect_circular' => __('Circular Overlay', 'thegem'),
        'effect_disabled' => __('Disabled', 'thegem'),
        'effect_zooming' => __('Zooming White', 'thegem'),
        'effect_sliding' => __('Horizontal Sliding', 'thegem'),
        'default_cart_button' => __('Default, Cart Button', 'thegem'),
        'default_cart_icon' => __('Default, Cart Icon', 'thegem'),
        'cart_disabled' => __('Cart Disabled', 'thegem'),
        'border_cart_icon' => __('Border, Cart Icon', 'thegem'),
        'shadow_hover_01' => __('Shadow Hover 01', 'thegem'),
        'shadow_hover_02' => __('Shadow Hover 02', 'thegem'),
        'rounded_images' => __('Rounded Images', 'thegem'),
        'rectangle_button' => __('Rectangle Button', 'thegem'),
        'rectangle_button_01' => __('Rectangle Button 01', 'thegem'),
        'rectangle_button_02' => __('Rectangle Button 02', 'thegem'),
        'separator_01' => __('Product Separator 01', 'thegem'),
        'separator_02' => __('Product Separator 02', 'thegem'),
        'solid_background' => __('Solid Caption Background', 'thegem'),
        'rounded_corners' => __('Rounded Corners', 'thegem'),
        'shadow' => __('Shadow', 'thegem'),
        'default_hover' => __('Default', 'thegem'),
        'hover_separator' => __('Product Separator', 'thegem'),
        'centered_caption' => __('Centered Caption', 'thegem'),
        'shadow_hover' => __('Shadow Hover', 'thegem'),
        'gradient_hover' => __('Gradient Hover', 'thegem'),
        'transparent' => __('Transparent', 'thegem'),
        'white' => __('White', 'thegem'),
        'gray' => __('Gray', 'thegem'),
        'dark' => __('Dark', 'thegem'),
        'light_gradient' => __('Light Gradient', 'thegem'),
        'dark_gradient' => __('Dark Gradient', 'thegem'),
        'solid_transparent' => __('Solid transparent', 'thegem'),
        'filter_attr_add_item' => __('+ Add Item', 'thegem'),
        'filter_attr_title' => __('Title', 'thegem'),
        'filter_attr_attribute' => __('Attribute', 'thegem'),
        'filter_attr_query_type' => __('Query Type', 'thegem'),
        'filter_attr_query_type_and' => __('AND'), 'thegem',
        'filter_attr_query_type_or' => __('OR', 'thegem'),
        'filter_border_radius' => __('Border Radius', 'thegem'),
        'filter_bottom_spacing' => __('Bottom Spacing', 'thegem'),
        'filter_separator' => __('Separator Width', 'thegem'),
        'filter_shadow' => __('Shadow', 'thegem'),
        'above_shop_grid' => __('Above the shop grid', 'thegem'),
        'below_shop_grid' => __('Below the shop grid', 'thegem'),
    ),
    'productPage' => array(
        'layout_default' => __('Advanced Layout', 'thegem'),
        'layout_legacy' => __('Simple Layout', 'thegem'),
        'desc_position_column' => __('In the Column', 'thegem'),
        'desc_position_fullwidth' => __('Fullwidth', 'thegem'),
        'desc_position_disabled' => __('Disabled', 'thegem'),
        'fixed_column_disabled' => __('Disabled', 'thegem'),
        'fixed_column_left' => __('Left', 'thegem'),
        'fixed_column_right' => __('Right', 'thegem'),
        'desc_style_tabs' => __('Tabs', 'thegem'),
        'desc_style_acc' => __('Accordion', 'thegem'),
        'desc_style_one_by_one' => __('One by One', 'thegem'),
        'desc_tab_style_modern' => __('Modern', 'thegem'),
        'desc_tab_style_horizontal' => __('Horizontal Tabs', 'thegem'),
        'desc_tab_style_vertical' => __('Vertical Tabs', 'thegem'),
        'desc_tab_style_legacy' => __('Legacy TheGem', 'thegem'),
        'desc_acc_style_modern' => __('Modern', 'thegem'),
        'desc_acc_style_legacy' => __('Legacy', 'thegem'),
        'desc_acc_next_to_gallery' => __('Next to Product Gallery', 'thegem'),
        'desc_tab_below_gallery' => __('Below Product Gallery', 'thegem'),
        'btn_text' => __('Button Text', 'thegem'),
        'btn_add_to_cart' => __('Add to Cart', 'thegem'),
        'btn_add_to_wishlist_icon' => __('“Add to Wishlist” Icon', 'thegem'),
        'btn_added_to_wishlist_icon' => __('“Added to Wishlist” Icon', 'thegem'),
        'btn_clear_attributes' => __('“Clear Attributes” Text', 'thegem'),
        'title_area_default' => __('Default Settings', 'thegem'),
        'title_area_disabled' => __('Disabled', 'thegem'),
        'breadcrumbs_default' => __('Default Settings', 'thegem'),
        'breadcrumbs_enabled' => __('Enabled', 'thegem'),
        'breadcrumbs_disabled' => __('Disabled', 'thegem'),
        'description_title' => __('“Description” Title', 'thegem'),
        'additional_title' => __('“Additional Info” Title', 'thegem'),
        'reviews_title' => __('“Reviews” Title', 'thegem'),
        'description_back' => __('Description Background', 'thegem'),
        'additional_back' => __('Additional Info Background', 'thegem'),
        'reviews_back' => __('Review Background', 'thegem'),
        'back_to_shop_main_shop' => __('Main Shop', 'thegem'),
        'back_to_shop_category' => __('Category', 'thegem'),
        'back_to_shop_custom_url' => __('Custom Url', 'thegem'),
        'attr_select' => __('Select Attribute', 'thegem'),
        'reviews_link_text' => __('Customer Reviews Link Text', 'thegem'),
        'stock_amount' => __('Products in Stock Text ', 'thegem'),
        'col-40-60' => __('40%/60%', 'thegem'),
        'col-50-50' => __('50%/50%', 'thegem'),
        'col-60-40' => __('60%/40%', 'thegem'),
        'col-100' => __('Width 100%', 'thegem'),
        'label_sale' => __('"Sale" Label', 'thegem'),
        'label_new' => __('"New" Label', 'thegem'),
        'label_out_stock' => __('"Out of stock" Label', 'thegem'),
        'label_text' => __('Label Text', 'thegem'),
        'label_sale_type' => __('Sale Label Type', 'thegem'),
        'label_sale_prefix' => __('Prefix', 'thegem'),
        'label_sale_suffix' => __('Suffix', 'thegem'),
        'label_style' => __('Style', 'thegem'),
        'show_percentage' => __('Show Discount Percentage', 'thegem'),
        'show_text' => __('Show Text', 'thegem'),
        'sku_title' => __('SKU Title', 'thegem'),
        'cat_title' => __('Categories Title', 'thegem'),
        'tags_title' => __('Tags Title', 'thegem'),
        'share_title' => __('Share Icons Title', 'thegem'),
        'bottom_spacing' => __('Bottom Spacing', 'thegem'),
        'header_separator' => __('Menu & Header Separator', 'thegem'),
        'horizontal_tabs' => __('Horizontal Tabs', 'thegem'),
        'vertical_tabs' => __('Vertical Tabs', 'thegem'),
        'accordion' => __('Accordion', 'thegem'),
        'one_by_one' => __('One By One', 'thegem'),
        'fullwidth' => __('100% Width', 'thegem'),
        'swapped_columns' => __('Swapped Columns', 'thegem'),
        'no_gallery_margins' => __('100% Width, No Gallery Margins', 'thegem'),
        'centered' => __('Centered Product Info', 'thegem'),
        'centered_boxed' => __('Boxed Info', 'thegem'),
        'extra_description' => __('Product Extra Description', 'thegem'),
        'page_builder' => __('Product Content (Page Builder)', 'thegem'),
        'boxed_background' => __('Box Background', 'thegem'),
        'background' => __('Background Color', 'thegem'),
        'share_facebook' => __('Facebook', 'thegem'),
        'share_twitter' => __('Twitter', 'thegem'),
        'share_pinterest' => __('Pinterest', 'thegem'),
        'share_tumblr' => __('Tumblr', 'thegem'),
        'share_linkedin' => __('Linkedin', 'thegem'),
        'share_reddit' => __('Reddit', 'thegem'),
        'sticky_offset' => __('Sticky Offset', 'thegem'),
        'layout_source_default' => __('Built-In Layouts', 'thegem'),
        'layout_source_builder' => __('Templates Builder', 'thegem'),
        'select_template' => __('Select Template', 'thegem'),
    ),
    'cartCheckout' => array(
        'cart_classic' => __('Classic', 'thegem'),
        'cart_modern' => __('Modern', 'thegem'),
        'checkout_onepage' => __('One-Page Checkout', 'thegem'),
        'checkout_multistep' => __('Multi-Step Checkout', 'thegem'),
        'content_area' => __('Content Area', 'thegem'),
        'title_area' => __('Title Area', 'thegem'),
        'icon_cart' => __('Cart Icon', 'thegem'),
        'icon_bag' => __('Bag Icon', 'thegem'),
        'icon_heart' => __('Heart Icon', 'thegem'),
        'icon_custom' => __('Custom Icon', 'thegem'),
        'label' => __('Label', 'thegem'),
        'titles_text' => __('Titles Text Color', 'thegem'),
        'header_background' => __('Header Background Color', 'thegem'),
    ),
    'search' => array(
        'search' => __('Search', 'thegem'),
        'layout_dropdown' => __('Dropdown', 'thegem'),
        'layout_fullscreen' => __('Fullscreen Overlay', 'thegem'),
        'post_type_products' => __('Products', 'thegem'),
        'post_type_posts' => __('Blog Posts', 'thegem'),
        'post_type_pages' => __('Pages', 'thegem'),
        'post_type_portfolio' => __('Portfolio', 'thegem'),
        'add_term_item' => __('+ Add Search Term', 'thegem'),
    ),
    'optimizer' => array(
        'confirm' => 'TheGem has detected that WP Rocket and/or Autoptimize plugins have been already installed on your WordPress installation previously. Note: by proceeding all current settings of this plugins will be automatically replaced by the settings recommended for TheGem theme.<br/><br/>Do you wish to proceed?',
        'action_failed' => 'Action failed. Please try again'
    ),
    'headerBuilder' => array(
        'header_default' => __('Built-In Header', 'thegem'),
        'header_builder' => __('Header Builder', 'thegem'),
        'default_template' => __('Select Header Template', 'thegem'),
        'sticky_template' => __('Select Sticky Header Template', 'thegem'),
        'sticky_template_opacity' => __('Sticky Header Opacity', 'thegem'),
        'desktop_menu_presets' => __('Desktop Menu & Submenu Color Pre-Sets', 'thegem'),
        'mobile_menu_presets' => __('Mobile Menu Color Pre-Sets', 'thegem'),
        'mobile_menu_search' => __('Search In Mobile Menu', 'thegem'),
        'mobile_menu_socials' => __('Socials In Mobile Menu', 'thegem'),
        'light_submenu' => __('Light Submenu', 'thegem'),
        'dark_submenu' => __('Dark Submenu', 'thegem'),
        'white_main_menu' => __('White Main Menu', 'thegem'),
        'header_opacity' => __('Header Opacity', 'thegem'),
        'light_scheme' => __('Use Light Color Scheme', 'thegem'),
        'light_scheme_color' => __('Light Color', 'thegem'),
        'light_scheme_color_hover' => __('Light Color Hover', 'thegem'),
        'hide_on_scroll' => __('Hide On Scroll', 'thegem'),
    ),
    'blogLayout' =>  array(
        'type_list' => __('Blog List', 'thegem'),
        'type_grid' => __('Blog Extended Grid', 'thegem'),
        'grid_justified' => __('Justified', 'thegem'),
        'grid_masonry' => __('Masonry', 'thegem'),
        'grid_metro' => __('Metro', 'thegem'),
        'skin_classic' => __('Classic', 'thegem'),
        'skin_alternative' => __('Alternative', 'thegem'),
        'col-1x' => __('1x columns', 'thegem'),
        'col-2x' => __('2x columns', 'thegem'),
        'col-3x' => __('3x columns', 'thegem'),
        'col-4x' => __('4x columns', 'thegem'),
        'col-5x' => __('5x columns', 'thegem'),
        'col-6x' => __('6x columns', 'thegem'),
        'col-100%' => __('100% width', 'thegem'),
        'col-4' => __('4 Columns', 'thegem'),
        'col-5' => __('5 Columns', 'thegem'),
        'col-6' => __('6 Columns', 'thegem'),
        'hover_default' => __('Cyan Breeze', 'thegem'),
        'hover_zooming_blur' => __('Zooming White', 'thegem'),
        'hover_horizontal_sliding' => __('Horizontal Sliding', 'thegem'),
        'hover_vertical_sliding' => __('Vertical Sliding', 'thegem'),
        'hover_gradient' => __('Gradient', 'thegem'),
        'hover_circular' => __('Circular Overlay', 'thegem'),
        'caption_bellow_image' => __('Below Image', 'thegem'),
        'caption_on_image' => __('On Image', 'thegem'),
        'caption_title_h5' => __('H5 Size', 'thegem'),
        'caption_title_h6' => __('H6 Size', 'thegem'),
        'caption_container_transparent' => __('Transparent', 'thegem'),
        'caption_container_white' => __('White', 'thegem'),
        'caption_container_gray' => __('Gray', 'thegem'),
        'caption_container_dark' => __('Dark', 'thegem'),
        'pagination_standard' => __('Standard', 'thegem'),
        'pagination_numbers' => __('Numbers', 'thegem'),
        'pagination_more' => __('Load More Button', 'thegem'),
        'pagination_scroll' => __('Infinite Scroll', 'thegem'),
        'animation_bounce' => __('Bounce', 'thegem'),
        'animation_move_up' => __('Move Up', 'thegem'),
        'animation_fade_in' => __('Fade In', 'thegem'),
        'animation_fall_perspective' => __('Fall Perspective', 'thegem'),
        'animation_scale' => __('Scale', 'thegem'),
        'animation_flip' => __('Flip', 'thegem'),
        'loadmore_type_flat' => __('Flat', 'thegem'),
        'loadmore_type_outline' => __('Outline', 'thegem'),
        'loadmore_size_small' => __('Small', 'thegem'),
        'loadmore_size_medium' => __('Medium', 'thegem'),
        'loadmore_size_large' => __('Large', 'thegem'),
        'bottom_border_in_caption' => __('Show/hide bottom border in caption container', 'thegem'),
    ),
    'searchLayout' =>  array(
        'type_default' => __('Default Masonry', 'thegem'),
        'type_grid' => __('Extended Grid', 'thegem'),
        'type_list_01' => __('Compact List 01', 'thegem'),
        'type_list_02' => __('Compact List 02', 'thegem'),
        'grid_justified' => __('Justified', 'thegem'),
        'grid_masonry' => __('Masonry', 'thegem'),
        'grid_metro' => __('Metro', 'thegem'),
        'skin_classic' => __('Classic', 'thegem'),
        'skin_alternative' => __('Alternative', 'thegem'),
        'col-1x' => __('1x columns', 'thegem'),
        'col-2x' => __('2x columns', 'thegem'),
        'col-3x' => __('3x columns', 'thegem'),
        'col-4x' => __('4x columns', 'thegem'),
        'col-5x' => __('5x columns', 'thegem'),
        'col-6x' => __('6x columns', 'thegem'),
        'col-100%' => __('100% width', 'thegem'),
        'col-4' => __('4 Columns', 'thegem'),
        'col-5' => __('5 Columns', 'thegem'),
        'col-6' => __('6 Columns', 'thegem'),
        'hover_default' => __('Cyan Breeze', 'thegem'),
        'hover_zooming_blur' => __('Zooming White', 'thegem'),
        'hover_horizontal_sliding' => __('Horizontal Sliding', 'thegem'),
        'hover_vertical_sliding' => __('Vertical Sliding', 'thegem'),
        'hover_gradient' => __('Gradient', 'thegem'),
        'hover_circular' => __('Circular Overlay', 'thegem'),
        'hover_simple_zoom' => __('Simple Zoom', 'thegem'),
        'caption_bellow_image' => __('Below Image', 'thegem'),
        'caption_on_image' => __('On Image', 'thegem'),
        'caption_title_h5' => __('H5 Size', 'thegem'),
        'caption_title_h6' => __('H6 Size', 'thegem'),
        'caption_container_transparent' => __('Transparent', 'thegem'),
        'caption_container_white' => __('White', 'thegem'),
        'caption_container_gray' => __('Gray', 'thegem'),
        'caption_container_dark' => __('Dark', 'thegem'),
        'pagination_standard' => __('Standard', 'thegem'),
        'pagination_numbers' => __('Numbers', 'thegem'),
        'pagination_more' => __('Load More Button', 'thegem'),
        'pagination_scroll' => __('Infinite Scroll', 'thegem'),
        'animation_bounce' => __('Bounce', 'thegem'),
        'animation_move_up' => __('Move Up', 'thegem'),
        'animation_fade_in' => __('Fade In', 'thegem'),
        'animation_fall_perspective' => __('Fall Perspective', 'thegem'),
        'animation_scale' => __('Scale', 'thegem'),
        'animation_flip' => __('Flip', 'thegem'),
        'loadmore_type_flat' => __('Flat', 'thegem'),
        'loadmore_type_outline' => __('Outline', 'thegem'),
        'loadmore_size_small' => __('Small', 'thegem'),
        'loadmore_size_medium' => __('Medium', 'thegem'),
        'loadmore_size_large' => __('Large', 'thegem'),
        'bottom_border_in_caption' => __('Show/hide bottom border in caption container', 'thegem'),
    ),
);
